/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc.da;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICurrency;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JIVariantMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(JIVariantMarshaller.class);
    public static final String DEFAULT_MSG = "Using default case for variant conversion: {} : {} : {}";

    public static Integer extractError(JIVariant variant) throws JIException {
        if (variant.getType() == 10) {
            return variant.getObjectAsSCODE();
        }
        return null;
    }

    public static Object toJavaType(JIVariant variant) throws JIException {
        int type = variant.getType();
        if ((type & 0x2000) == 8192) {
            JIArray array = variant.getObjectAsArray();
            return JIVariantMarshaller.jIArrayToJavaArray(array, type);
        }
        switch (type) {
            case 0: 
            case 1: {
                return null;
            }
            case 10: {
                return JIVariantMarshaller.extractError(variant);
            }
            case 16: {
                return (byte)variant.getObjectAsChar();
            }
            case 2: {
                return variant.getObjectAsShort();
            }
            case 3: 
            case 22: {
                return variant.getObjectAsInt();
            }
            case 20: {
                return variant.getObjectAsLong();
            }
            case 7: {
                return Instant.ofEpochMilli(variant.getObjectAsDate().getTime());
            }
            case 4: {
                return Float.valueOf(variant.getObjectAsFloat());
            }
            case 5: {
                return variant.getObjectAsDouble();
            }
            case 17: {
                return variant.getObjectAsUnsigned().getValue().byteValue();
            }
            case 18: {
                return variant.getObjectAsUnsigned().getValue().shortValue();
            }
            case 19: 
            case 23: {
                return variant.getObjectAsUnsigned().getValue().intValue();
            }
            case 8: {
                return String.valueOf(variant.getObjectAsString2());
            }
            case 11: {
                return variant.getObjectAsBoolean();
            }
            case 6: {
                JICurrency currency = (JICurrency)variant.getObject();
                BigDecimal cyRetVal = JIVariantMarshaller.currencyToBigDecimal(currency);
                return cyRetVal;
            }
        }
        String value = variant.getObject().toString();
        logger.warn(DEFAULT_MSG, new Object[]{value, variant.getObject().getClass().getName(), Integer.toHexString(type)});
        return value;
    }

    private static BigDecimal currencyToBigDecimal(JICurrency currency) {
        BigDecimal cyRetVal = new BigDecimal((double)currency.getUnits() + (double)currency.getFractionalUnits() / 10000.0);
        return cyRetVal;
    }

    public static Object[] jIArrayToJavaArray(JIArray jIArray, int type) {
        Object[] objArray = (Object[])jIArray.getArrayInstance();
        int arrayLength = objArray.length;
        switch (type ^ 0x2000) {
            case 0: 
            case 1: {
                return new Void[objArray.length];
            }
            case 7: {
                return Arrays.stream(objArray).map(d -> Instant.ofEpochMilli(((Date)d).getTime())).toArray();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                return objArray;
            }
            case 6: {
                Object[] cyRetVal = new BigDecimal[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    cyRetVal[i] = JIVariantMarshaller.currencyToBigDecimal((JICurrency)objArray[i]);
                }
                return cyRetVal;
            }
            case 8: {
                Object[] strRetVal = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    strRetVal[i] = ((JIString)objArray[i]).getString();
                }
                return strRetVal;
            }
        }
        logger.warn(DEFAULT_MSG, new Object[]{jIArray, jIArray.getArrayClass().getName(), Integer.toHexString(type)});
        return objArray;
    }

    public static Class<?> findJavaClass(int type) {
        boolean isArray = false;
        if ((type & 0x2000) == 8192) {
            isArray = true;
            type ^= 0x2000;
        }
        switch (type) {
            case 16: {
                return isArray ? Character[].class : Character.class;
            }
            case 2: 
            case 18: {
                return isArray ? Short[].class : Short.class;
            }
            case 3: 
            case 10: 
            case 19: 
            case 22: 
            case 23: {
                return isArray ? Integer[].class : Integer.class;
            }
            case 20: {
                return isArray ? Long[].class : Long.class;
            }
            case 7: {
                return isArray ? Instant[].class : Instant.class;
            }
            case 4: {
                return isArray ? Float[].class : Float.class;
            }
            case 5: {
                return isArray ? Double[].class : Double.class;
            }
            case 17: {
                return isArray ? Byte[].class : Byte.class;
            }
            case 11: {
                return isArray ? Boolean[].class : Boolean.class;
            }
            case 6: {
                return isArray ? BigDecimal[].class : BigDecimal.class;
            }
            case 0: 
            case 1: {
                return isArray ? Void[].class : Void.class;
            }
        }
        return isArray ? String[].class : String.class;
    }
}

