/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionConfiguration {
    private final Map<String, Duration> samplingIntervalByTag = new HashMap<String, Duration>();
    private Duration defaultSamplingInterval = Duration.ofSeconds(10L);

    public Duration getDefaultSamplingInterval() {
        return this.defaultSamplingInterval;
    }

    public void setDefaultSamplingInterval(Duration defaultSamplingInterval) {
        if (defaultSamplingInterval == null) {
            throw new IllegalArgumentException("Parameter is expected not to be null");
        }
        this.defaultSamplingInterval = defaultSamplingInterval;
    }

    public SubscriptionConfiguration withDefaultSamplingInterval(Duration defaultSamplingInterval) {
        this.setDefaultSamplingInterval(defaultSamplingInterval);
        return this;
    }

    public Duration samplingIntervalForTag(String tagId) {
        return this.samplingIntervalByTag.getOrDefault(tagId, this.defaultSamplingInterval);
    }

    public SubscriptionConfiguration withTagSamplingIntervalForTag(String tagId, Duration samplingInterval) {
        if (samplingInterval == null) {
            throw new IllegalArgumentException("Parameter samplingInterval is expected not to be null");
        }
        this.samplingIntervalByTag.put(tagId, samplingInterval);
        return this;
    }

    public String toString() {
        return "SubscriptionConfiguration{samplingIntervalByTag=" + this.samplingIntervalByTag + ", defaultSamplingInterval=" + this.defaultSamplingInterval + '}';
    }
}

