/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc;

import com.hurence.opc.OpcObjectInfo;
import com.hurence.opc.OpcTagAccessRights;
import com.hurence.opc.OpcTagProperty;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class OpcTagInfo
extends OpcObjectInfo<OpcTagInfo> {
    private Type type;
    private Optional<Duration> scanRate = Optional.empty();
    private final OpcTagAccessRights accessRights = new OpcTagAccessRights();
    private Set<OpcTagProperty> properties = new HashSet<OpcTagProperty>();

    public OpcTagInfo(String id) {
        super(id);
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Set<OpcTagProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<OpcTagProperty> properties) {
        this.properties = properties;
    }

    public Optional<Duration> getScanRate() {
        return this.scanRate;
    }

    public Type getType() {
        return this.type;
    }

    public void setScanRate(Optional<Duration> scanRate) {
        this.scanRate = scanRate;
    }

    public synchronized OpcObjectInfo addProperty(OpcTagProperty property) {
        this.properties.add(property);
        return this;
    }

    public OpcTagInfo withType(Type type) {
        this.setType(type);
        return this;
    }

    public OpcTagInfo withScanRate(Duration scanRate) {
        this.setScanRate(Optional.ofNullable(scanRate));
        return this;
    }

    public OpcTagAccessRights getAccessRights() {
        return this.accessRights;
    }

    public OpcTagInfo withReadAccessRights(boolean readable) {
        this.getAccessRights().setReadable(readable);
        return this;
    }

    public OpcTagInfo withWriteAccessRights(boolean writable) {
        this.getAccessRights().setWritable(writable);
        return this;
    }

    @Override
    public String toString() {
        return "OpcTagInfo{type=" + this.type + ", scanRate=" + this.scanRate + ", accessRights=" + this.accessRights + ", properties=" + this.properties + "} " + super.toString();
    }
}

