/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc;

import java.util.Objects;
import java.util.Optional;

public abstract class OpcObjectInfo<T extends OpcObjectInfo<T>> {
    private final String id;
    private String name;
    private Optional<String> description = Optional.empty();

    public OpcObjectInfo(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public void setDescription(Optional<String> description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T withName(String name) {
        this.setName(name);
        return (T)this;
    }

    public T withDescription(String description) {
        this.setDescription(Optional.ofNullable(description));
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpcObjectInfo that = (OpcObjectInfo)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "OpcObjectInfo{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description=" + this.description + '}';
    }
}

