/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc;

import com.hurence.opc.auth.Credentials;
import java.net.URI;
import java.time.Duration;

public abstract class ConnectionProfile<T extends ConnectionProfile<T>> {
    private URI connectionUri;
    private Duration socketTimeout;
    private Duration keepAliveInterval = Duration.ofSeconds(10L);
    private Credentials credentials = Credentials.ANONYMOUS_CREDENTIALS;

    public final T withConnectionUri(URI connectionUri) {
        this.setConnectionUri(connectionUri);
        return (T)this;
    }

    public final T withSocketTimeout(Duration socketTimeout) {
        this.setSocketTimeout(socketTimeout);
        return (T)this;
    }

    public final T withKeepAliveInterval(Duration keepAliveInterval) {
        this.setKeepAliveInterval(keepAliveInterval);
        return (T)this;
    }

    public final T withCredentials(Credentials credentials) {
        this.setCredentials(credentials);
        return (T)this;
    }

    public final Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public final void setSocketTimeout(Duration socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(Duration keepAliveInterval) {
        if (keepAliveInterval == null) {
            throw new IllegalArgumentException("keepAliveInterval must be a valid non null duration");
        }
        this.keepAliveInterval = keepAliveInterval;
    }

    public URI getConnectionUri() {
        return this.connectionUri;
    }

    public void setConnectionUri(URI connectionUri) {
        this.connectionUri = connectionUri;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String toString() {
        return "ConnectionProfile{connectionUri=" + this.connectionUri + ", socketTimeout=" + this.socketTimeout + ", keepAliveInterval=" + this.keepAliveInterval + ", credentials=" + this.credentials + '}';
    }
}

