/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc;

import com.hurence.opc.ConnectionProfile;
import com.hurence.opc.ConnectionState;
import com.hurence.opc.OpcOperations;
import com.hurence.opc.OpcSession;
import com.hurence.opc.SessionProfile;
import com.hurence.opc.util.ExecutorServiceFactory;
import java.util.Optional;

public abstract class AbstractOpcOperations<T extends ConnectionProfile, U extends SessionProfile, V extends OpcSession>
implements OpcOperations<T, U, V> {
    private volatile ConnectionState connectionState = ConnectionState.DISCONNECTED;
    protected final ExecutorServiceFactory executorServiceFactory;

    protected AbstractOpcOperations(ExecutorServiceFactory executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }

    protected synchronized ConnectionState getStateAndSet(Optional<ConnectionState> next) {
        ConnectionState ret = this.connectionState;
        if (next.isPresent()) {
            this.connectionState = next.get();
        }
        return ret;
    }

    @Override
    public final ConnectionState getConnectionState() {
        return this.getStateAndSet(Optional.empty());
    }

    @Override
    public final boolean awaitConnected() {
        while (this.getConnectionState() != ConnectionState.CONNECTED) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean awaitDisconnected() {
        while (this.getConnectionState() != ConnectionState.DISCONNECTED) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isChannelSecured() {
        return false;
    }
}

