/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.album;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.core.content.PermissionChecker;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Album;
import com.huantansheng.easyphotos.models.album.entity.AlbumItem;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.utils.String.StringUtils;
import java.io.File;
import java.util.ArrayList;

public class AlbumModel {
    private static final String TAG = "AlbumModel";
    public static AlbumModel instance;
    public Album album = new Album();
    private String[] projections;
    public volatile boolean canRun = true;

    private AlbumModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlbumModel getInstance() {
        if (null != instance) return instance;
        Class<AlbumModel> clazz = AlbumModel.class;
        synchronized (AlbumModel.class) {
            if (null != instance) return instance;
            instance = new AlbumModel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void query(Context context, final CallBack callBack) {
        final Context appCxt = context.getApplicationContext();
        if (PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            if (null != callBack) {
                callBack.onAlbumWorkedCallBack();
            }
            return;
        }
        this.canRun = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                AlbumModel.this.initAlbum(appCxt);
                if (null != callBack) {
                    callBack.onAlbumWorkedCallBack();
                }
            }
        }).start();
    }

    public void stopQuery() {
        this.canRun = false;
    }

    private synchronized void initAlbum(Context context) {
        Uri contentUri;
        this.album.clear();
        if (Setting.selectedPhotos.size() > Setting.count) {
            throw new RuntimeException("AlbumBuilder: \u9ed8\u8ba4\u52fe\u9009\u7684\u56fe\u7247\u5f20\u6570\u4e0d\u80fd\u5927\u4e8e\u8bbe\u7f6e\u7684\u9009\u62e9\u6570\uff01|\u9ed8\u8ba4\u52fe\u9009\u56fe\u7247\u5f20\u6570\uff1a" + Setting.selectedPhotos.size() + "|\u8bbe\u7f6e\u7684\u9009\u62e9\u6570\uff1a" + Setting.count);
        }
        boolean canReadWidth = Build.VERSION.SDK_INT >= 16;
        String sortOrder = "date_modified DESC";
        String selection = null;
        String[] selectionAllArgs = null;
        if (Setting.isOnlyVideo()) {
            contentUri = MediaStore.Video.Media.getContentUri((String)"external");
        } else if (!Setting.showVideo) {
            contentUri = MediaStore.Images.Media.getContentUri((String)"external");
        } else {
            contentUri = MediaStore.Files.getContentUri((String)"external");
            selection = "(media_type=? OR media_type=?)";
            selectionAllArgs = new String[]{String.valueOf(1), String.valueOf(3)};
        }
        ContentResolver contentResolver = context.getContentResolver();
        ArrayList<String> projectionList = new ArrayList<String>();
        projectionList.add("_id");
        projectionList.add("_data");
        projectionList.add("_display_name");
        projectionList.add("date_modified");
        projectionList.add("mime_type");
        projectionList.add("_size");
        projectionList.add("bucket_display_name");
        if (!Setting.useWidth && Setting.minWidth != 1 && Setting.minHeight != 1) {
            Setting.useWidth = true;
        }
        if (canReadWidth && Setting.useWidth) {
            projectionList.add("width");
            projectionList.add("height");
            if (!Setting.isOnlyVideo()) {
                projectionList.add("orientation");
            }
        }
        if (Setting.showVideo) {
            projectionList.add("duration");
        }
        this.projections = projectionList.toArray(new String[0]);
        Cursor cursor = contentResolver.query(contentUri, this.projections, selection, selectionAllArgs, "date_modified DESC");
        if (cursor != null && cursor.moveToFirst()) {
            String albumItem_all_name = this.getAllAlbumName(context);
            String albumItem_video_name = context.getString(R.string.selector_folder_video_easy_photos);
            int albumNameCol = cursor.getColumnIndex("bucket_display_name");
            int durationCol = cursor.getColumnIndex("duration");
            int WidthCol = 0;
            int HeightCol = 0;
            int orientationCol = -1;
            if (canReadWidth && Setting.useWidth) {
                WidthCol = cursor.getColumnIndex("width");
                HeightCol = cursor.getColumnIndex("height");
                orientationCol = cursor.getColumnIndex("orientation");
            }
            boolean hasTime = durationCol > 0;
            do {
                String folderPath;
                String albumName;
                long id2 = cursor.getLong(0);
                String path = cursor.getString(1);
                String name = cursor.getString(2);
                long dateTime = cursor.getLong(3);
                String type = cursor.getString(4);
                long size = cursor.getLong(5);
                long duration = 0L;
                if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)type) || size < Setting.minSize) continue;
                boolean isVideo = type.contains("video");
                int width = 0;
                int height = 0;
                int orientation = 0;
                if (isVideo) {
                    if (hasTime) {
                        duration = cursor.getLong(durationCol);
                    }
                    if (duration <= Setting.videoMinSecond || duration >= Setting.videoMaxSecond) {
                        continue;
                    }
                } else {
                    if (orientationCol != -1) {
                        orientation = cursor.getInt(orientationCol);
                    }
                    if (!Setting.showGif && (path.endsWith("gif") || type.endsWith("gif"))) continue;
                    if (Setting.useWidth) {
                        if (canReadWidth) {
                            width = cursor.getInt(WidthCol);
                            height = cursor.getInt(HeightCol);
                        }
                        if (width == 0 || height == 0) {
                            BitmapFactory.Options options = new BitmapFactory.Options();
                            options.inJustDecodeBounds = true;
                            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                            width = options.outWidth;
                            height = options.outHeight;
                        }
                        if (orientation == 90 || orientation == 270) {
                            int temp = width;
                            width = height;
                            height = temp;
                        }
                        if (width < Setting.minWidth || height < Setting.minHeight) continue;
                    }
                }
                Uri uri = ContentUris.withAppendedId((Uri)(isVideo ? MediaStore.Video.Media.getContentUri((String)"external") : MediaStore.Images.Media.getContentUri((String)"external")), (long)id2);
                File file = new File(path);
                if (!file.isFile()) continue;
                Photo imageItem = new Photo(name, uri, path, dateTime, width, height, orientation, size, duration, type);
                if (!Setting.selectedPhotos.isEmpty()) {
                    int selectSize = Setting.selectedPhotos.size();
                    for (int i = 0; i < selectSize; ++i) {
                        Photo selectedPhoto = Setting.selectedPhotos.get(i);
                        if (!path.equals(selectedPhoto.path)) continue;
                        imageItem.selectedOriginal = Setting.selectedOriginal;
                        Result.addPhoto(imageItem);
                    }
                }
                if (this.album.isEmpty()) {
                    this.album.addAlbumItem(albumItem_all_name, "", path, uri);
                }
                this.album.getAlbumItem(albumItem_all_name).addImageItem(imageItem);
                if (Setting.showVideo && isVideo && !albumItem_video_name.equals(albumItem_all_name)) {
                    this.album.addAlbumItem(albumItem_video_name, "", path, uri);
                    this.album.getAlbumItem(albumItem_video_name).addImageItem(imageItem);
                }
                if (albumNameCol > 0) {
                    folderPath = albumName = cursor.getString(albumNameCol);
                } else {
                    File parentFile = new File(path).getParentFile();
                    if (null == parentFile) continue;
                    folderPath = parentFile.getAbsolutePath();
                    albumName = StringUtils.getLastPathSegment(folderPath);
                }
                this.album.addAlbumItem(albumName, folderPath, path, uri);
                this.album.getAlbumItem(albumName).addImageItem(imageItem);
            } while (cursor.moveToNext() && this.canRun);
            cursor.close();
            if (!Setting.selectedPhotos.isEmpty() && Setting.isSequentialSelectedPhotos) {
                int selectSize = Setting.selectedPhotos.size();
                int photoSize = Result.photos.size();
                ArrayList<Photo> tempList = new ArrayList<Photo>(photoSize);
                for (int i = 0; i < selectSize; ++i) {
                    for (int j = 0; j < photoSize; ++j) {
                        if (!Result.photos.get((int)j).path.equals(Setting.selectedPhotos.get((int)i).path)) continue;
                        tempList.add(i, Result.photos.get(j));
                    }
                }
                Result.photos = tempList;
            }
        }
    }

    public String getAllAlbumName(Context context) {
        String albumItem_all_name = context.getString(R.string.selector_folder_all_video_photo_easy_photos);
        if (Setting.isOnlyVideo()) {
            albumItem_all_name = context.getString(R.string.selector_folder_video_easy_photos);
        } else if (!Setting.showVideo) {
            albumItem_all_name = context.getString(R.string.selector_folder_all_easy_photos);
        }
        return albumItem_all_name;
    }

    public ArrayList<Photo> getCurrAlbumItemPhotos(int currAlbumItemIndex) {
        return this.album.getAlbumItem((int)currAlbumItemIndex).photos;
    }

    public ArrayList<AlbumItem> getAlbumItems() {
        return this.album.albumItems;
    }

    public String[] getProjections() {
        if (null == this.projections || this.projections.length == 0) {
            this.projections = Setting.useWidth ? new String[]{"_id", "_data", "_display_name", "date_modified", "mime_type", "_size", "bucket_display_name", "width", "height", "orientation"} : new String[]{"_id", "_data", "_display_name", "date_modified", "mime_type", "_size", "bucket_display_name"};
        }
        return this.projections;
    }

    public static interface CallBack {
        public void onAlbumWorkedCallBack();
    }
}

