/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.utils.uri;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import androidx.core.content.FileProvider;
import com.huantansheng.easyphotos.setting.Setting;
import java.io.File;
import java.util.Locale;

public class UriUtils {
    private static final String TAG = "UriUtils";

    public static Uri getUri(Context cxt, File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            if (null == Setting.fileProviderAuthority) {
                throw new NullPointerException("Setting.fileProviderAuthority must not be null.");
            }
            return FileProvider.getUriForFile((Context)cxt, (String)Setting.fileProviderAuthority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    @SuppressLint(value={"NewApi"})
    public static String getPathByUri(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (UriUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    if (Build.VERSION.SDK_INT < 29) {
                        return Environment.getExternalStorageDirectory() + "/" + split[1];
                    }
                    return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) + "/" + split[1];
                }
            } else {
                if (UriUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return UriUtils.getDataColumn(context, contentUri, null, null);
                }
                if (UriUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.getContentUri((String)"external");
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.getContentUri((String)"external");
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.getContentUri((String)"external");
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return UriUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (UriUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return UriUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        catch (IllegalArgumentException ex) {
            Log.i((String)TAG, (String)String.format(Locale.getDefault(), "getDataColumn: _data - [%s]", ex.getMessage()));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isGooglePlayPhotosUri(Uri uri) {
        return "com.google.android.apps.photos.contentprovider".equals(uri.getAuthority());
    }

    public static Uri getUriByPath(Context context, String path) {
        Uri contentUri;
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(contentUri = MediaStore.Files.getContentUri((String)"external"), new String[]{"_id"}, "_data=? ", new String[]{path}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            cursor.close();
            return Uri.withAppendedPath((Uri)contentUri, (String)("" + id2));
        }
        if (new File(path).exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", path);
            return contentResolver.insert(contentUri, values);
        }
        return null;
    }
}

