/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.puzzle.PuzzleLayout;
import com.huantansheng.easyphotos.models.puzzle.SquarePuzzleView;
import com.huantansheng.easyphotos.models.puzzle.template.slant.NumberSlantLayout;
import com.huantansheng.easyphotos.models.puzzle.template.straight.NumberStraightLayout;
import java.util.ArrayList;
import java.util.List;

public class PuzzleAdapter
extends RecyclerView.Adapter<PuzzleViewHolder> {
    private List<PuzzleLayout> layoutData = new ArrayList<PuzzleLayout>();
    private OnItemClickListener onItemClickListener;
    private int selectedNumber = 0;

    public PuzzleViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_puzzle_easy_photos, parent, false);
        return new PuzzleViewHolder(itemView);
    }

    public void onBindViewHolder(PuzzleViewHolder holder, int position) {
        final PuzzleLayout puzzleLayout = this.layoutData.get(position);
        final int p = position;
        if (this.selectedNumber == position) {
            holder.mFrame.setVisibility(0);
        } else {
            holder.mFrame.setVisibility(8);
        }
        holder.puzzleView.setNeedDrawLine(true);
        holder.puzzleView.setNeedDrawOuterLine(true);
        holder.puzzleView.setTouchEnable(false);
        holder.puzzleView.setPuzzleLayout(puzzleLayout);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PuzzleAdapter.this.selectedNumber == p) {
                    return;
                }
                if (PuzzleAdapter.this.onItemClickListener != null) {
                    int themeType = 0;
                    int themeId = 0;
                    if (puzzleLayout instanceof NumberSlantLayout) {
                        themeType = 0;
                        themeId = ((NumberSlantLayout)puzzleLayout).getTheme();
                    } else if (puzzleLayout instanceof NumberStraightLayout) {
                        themeType = 1;
                        themeId = ((NumberStraightLayout)puzzleLayout).getTheme();
                    }
                    PuzzleAdapter.this.selectedNumber = p;
                    PuzzleAdapter.this.onItemClickListener.onItemClick(themeType, themeId);
                    PuzzleAdapter.this.notifyDataSetChanged();
                }
            }
        });
    }

    public int getItemCount() {
        return this.layoutData == null ? 0 : this.layoutData.size();
    }

    public void refreshData(List<PuzzleLayout> layoutData) {
        this.layoutData = layoutData;
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, int var2);
    }

    public static class PuzzleViewHolder
    extends RecyclerView.ViewHolder {
        SquarePuzzleView puzzleView;
        View mFrame;

        public PuzzleViewHolder(View itemView) {
            super(itemView);
            this.puzzleView = (SquarePuzzleView)itemView.findViewById(R.id.puzzle);
            this.mFrame = itemView.findViewById(R.id.m_selector);
        }
    }
}

