/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.album.entity;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class Photo
implements Parcelable {
    private static final String TAG = "Photo";
    public Uri uri;
    public String name;
    public String path;
    public String type;
    public int width;
    public int height;
    public long size;
    public long duration;
    public long time;
    public boolean selected;
    public boolean selectedOriginal;
    public static final Parcelable.Creator<Photo> CREATOR = new Parcelable.Creator<Photo>(){

        public Photo createFromParcel(Parcel source) {
            return new Photo(source);
        }

        public Photo[] newArray(int size) {
            return new Photo[size];
        }
    };

    public Photo(String name, Uri uri, String path, long time, int width, int height, long size, long duration, String type) {
        this.name = name;
        this.uri = uri;
        this.path = path;
        this.time = time;
        this.width = width;
        this.height = height;
        this.type = type;
        this.size = size;
        this.duration = duration;
        this.selected = false;
        this.selectedOriginal = false;
    }

    public boolean equals(Object o) {
        try {
            Photo other = (Photo)o;
            return this.path.equalsIgnoreCase(other.path);
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)("equals: " + Log.getStackTraceString((Throwable)e)));
            return super.equals(o);
        }
    }

    public String toString() {
        return "Photo{name='" + this.name + '\'' + ", uri='" + this.uri.toString() + '\'' + ", path='" + this.path + '\'' + ", time=" + this.time + '\'' + ", minWidth=" + this.width + '\'' + ", minHeight=" + this.height + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Uri.writeToParcel((Parcel)dest, (Uri)this.uri);
        dest.writeString(this.name);
        dest.writeString(this.path);
        dest.writeString(this.type);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeLong(this.size);
        dest.writeLong(this.duration);
        dest.writeLong(this.time);
        dest.writeByte(this.selected ? (byte)1 : 0);
        dest.writeByte(this.selectedOriginal ? (byte)1 : 0);
    }

    protected Photo(Parcel in) {
        this.uri = (Uri)Uri.CREATOR.createFromParcel(in);
        this.name = in.readString();
        this.path = in.readString();
        this.type = in.readString();
        this.width = in.readInt();
        this.height = in.readInt();
        this.size = in.readLong();
        this.duration = in.readLong();
        this.time = in.readLong();
        this.selected = in.readByte() != 0;
        this.selectedOriginal = in.readByte() != 0;
    }
}

