/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.github.chrisbanes.photoview.OnScaleChangedListener;
import com.github.chrisbanes.photoview.PhotoView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.setting.Setting;
import java.util.ArrayList;

public class PreviewPhotosAdapter
extends RecyclerView.Adapter<PreviewPhotosViewHolder> {
    private ArrayList<Photo> photos;
    private OnClickListener listener;
    private LayoutInflater inflater;

    public PreviewPhotosAdapter(Context cxt, ArrayList<Photo> photos, OnClickListener listener) {
        this.photos = photos;
        this.inflater = LayoutInflater.from((Context)cxt);
        this.listener = listener;
    }

    public PreviewPhotosViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PreviewPhotosViewHolder(this.inflater.inflate(R.layout.item_preview_photo_easy_photos, parent, false));
    }

    public void onBindViewHolder(PreviewPhotosViewHolder holder, int position) {
        String path = this.photos.get((int)position).path;
        String type = this.photos.get((int)position).type;
        if (path.endsWith(".gif") || type.endsWith(".gif")) {
            Setting.imageEngine.loadGif(holder.ivPhoto.getContext(), path, (ImageView)holder.ivPhoto);
        } else {
            Setting.imageEngine.loadPhoto(holder.ivPhoto.getContext(), path, (ImageView)holder.ivPhoto);
        }
        holder.ivPhoto.setScale(1.0f);
        holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewPhotosAdapter.this.listener.onPhotoClick();
            }
        });
        holder.ivPhoto.setOnScaleChangeListener(new OnScaleChangedListener(){

            public void onScaleChange(float scaleFactor, float focusX, float focusY) {
                PreviewPhotosAdapter.this.listener.onPhotoScaleChanged();
            }
        });
    }

    public int getItemCount() {
        return this.photos.size();
    }

    public class PreviewPhotosViewHolder
    extends RecyclerView.ViewHolder {
        public PhotoView ivPhoto;

        PreviewPhotosViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (PhotoView)itemView.findViewById(R.id.iv_photo);
        }
    }

    public static interface OnClickListener {
        public void onPhotoClick();

        public void onPhotoScaleChanged();
    }
}

