/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.puzzle.straight;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import com.huantansheng.easyphotos.models.puzzle.Line;

class StraightLine
implements Line {
    private PointF start;
    private PointF end;
    private PointF previousStart = new PointF();
    private PointF previousEnd = new PointF();
    public Line.Direction direction = Line.Direction.HORIZONTAL;
    StraightLine attachLineStart;
    StraightLine attachLineEnd;
    private Line upperLine;
    private Line lowerLine;
    private RectF bounds = new RectF();

    StraightLine(PointF start, PointF end) {
        this.start = start;
        this.end = end;
        if (start.x == end.x) {
            this.direction = Line.Direction.VERTICAL;
        } else if (start.y == end.y) {
            this.direction = Line.Direction.HORIZONTAL;
        } else {
            Log.d((String)"StraightLine", (String)"StraightLine: current only support two direction");
        }
    }

    @Override
    public float length() {
        return (float)Math.sqrt(Math.pow(this.end.x - this.start.x, 2.0) + Math.pow(this.end.y - this.start.y, 2.0));
    }

    @Override
    public PointF startPoint() {
        return this.start;
    }

    @Override
    public PointF endPoint() {
        return this.end;
    }

    @Override
    public Line lowerLine() {
        return this.lowerLine;
    }

    @Override
    public Line upperLine() {
        return this.upperLine;
    }

    @Override
    public Line attachStartLine() {
        return this.attachLineStart;
    }

    @Override
    public Line attachEndLine() {
        return this.attachLineEnd;
    }

    @Override
    public void setLowerLine(Line lowerLine) {
        this.lowerLine = lowerLine;
    }

    @Override
    public void setUpperLine(Line upperLine) {
        this.upperLine = upperLine;
    }

    void setAttachLineStart(StraightLine attachLineStart) {
        this.attachLineStart = attachLineStart;
    }

    void setAttachLineEnd(StraightLine attachLineEnd) {
        this.attachLineEnd = attachLineEnd;
    }

    @Override
    public Line.Direction direction() {
        return this.direction;
    }

    @Override
    public float slope() {
        return this.direction == Line.Direction.HORIZONTAL ? 0.0f : Float.MAX_VALUE;
    }

    @Override
    public boolean contains(float x, float y, float extra) {
        if (this.direction == Line.Direction.HORIZONTAL) {
            this.bounds.left = this.start.x;
            this.bounds.right = this.end.x;
            this.bounds.top = this.start.y - extra / 2.0f;
            this.bounds.bottom = this.start.y + extra / 2.0f;
        } else if (this.direction == Line.Direction.VERTICAL) {
            this.bounds.top = this.start.y;
            this.bounds.bottom = this.end.y;
            this.bounds.left = this.start.x - extra / 2.0f;
            this.bounds.right = this.start.x + extra / 2.0f;
        }
        return this.bounds.contains(x, y);
    }

    @Override
    public void prepareMove() {
        this.previousStart.set(this.start);
        this.previousEnd.set(this.end);
    }

    @Override
    public boolean move(float offset, float extra) {
        if (this.direction == Line.Direction.HORIZONTAL) {
            if (this.previousStart.y + offset < this.lowerLine.maxY() + extra || this.previousStart.y + offset > this.upperLine.minY() - extra || this.previousEnd.y + offset < this.lowerLine.maxY() + extra || this.previousEnd.y + offset > this.upperLine.minY() - extra) {
                return false;
            }
            this.start.y = this.previousStart.y + offset;
            this.end.y = this.previousEnd.y + offset;
        } else {
            if (this.previousStart.x + offset < this.lowerLine.maxX() + extra || this.previousStart.x + offset > this.upperLine.minX() - extra || this.previousEnd.x + offset < this.lowerLine.maxX() + extra || this.previousEnd.x + offset > this.upperLine.minX() - extra) {
                return false;
            }
            this.start.x = this.previousStart.x + offset;
            this.end.x = this.previousEnd.x + offset;
        }
        return true;
    }

    @Override
    public void update(float layoutWidth, float layoutHeight) {
        if (this.direction == Line.Direction.HORIZONTAL) {
            if (this.attachLineStart != null) {
                this.start.x = this.attachLineStart.getPosition();
            }
            if (this.attachLineEnd != null) {
                this.end.x = this.attachLineEnd.getPosition();
            }
        } else if (this.direction == Line.Direction.VERTICAL) {
            if (this.attachLineStart != null) {
                this.start.y = this.attachLineStart.getPosition();
            }
            if (this.attachLineEnd != null) {
                this.end.y = this.attachLineEnd.getPosition();
            }
        }
    }

    public float getPosition() {
        if (this.direction == Line.Direction.HORIZONTAL) {
            return this.start.y;
        }
        return this.start.x;
    }

    @Override
    public float minX() {
        return Math.min(this.start.x, this.end.x);
    }

    @Override
    public float maxX() {
        return Math.max(this.start.x, this.end.x);
    }

    @Override
    public float minY() {
        return Math.min(this.start.y, this.end.y);
    }

    @Override
    public float maxY() {
        return Math.max(this.start.y, this.end.y);
    }

    @Override
    public void offset(float x, float y) {
        this.start.offset(x, y);
        this.end.offset(x, y);
    }

    public String toString() {
        return "start --> " + this.start.toString() + ",end --> " + this.end.toString();
    }
}

