/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.ad.AdViewHolder;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.widget.PressedImageView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PhotosAdapter
extends RecyclerView.Adapter {
    private static final int TYPE_AD = 0;
    private static final int TYPE_ALBUM_ITEMS = 1;
    ArrayList<Object> dataList;
    RequestManager mGlide;
    LayoutInflater mInflater;
    OnClickListener listener;
    boolean unable;
    boolean isSingle;
    int singlePosition;

    public PhotosAdapter(Context cxt, ArrayList<Object> dataList, OnClickListener listener) {
        this.dataList = dataList;
        this.listener = listener;
        this.mInflater = LayoutInflater.from((Context)cxt);
        this.unable = Result.count() == Setting.count;
        this.isSingle = Setting.count == 1;
        this.mGlide = Glide.with((Context)cxt);
        RequestOptions options = new RequestOptions().centerCrop();
        this.mGlide.applyDefaultRequestOptions(options);
    }

    public void change() {
        this.unable = Result.count() == Setting.count;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                return new AdViewHolder(this.mInflater.inflate(R.layout.item_ad_easy_photos, parent, false));
            }
        }
        return new PhotoViewHolder(this.mInflater.inflate(R.layout.item_rv_photos_easy_photos, parent, false));
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof PhotoViewHolder) {
            final Photo item = (Photo)this.dataList.get(position);
            this.updateSelector(((PhotoViewHolder)holder).tvSelector, item.selected, item, position);
            String path = item.path;
            String type = item.type;
            if (Setting.showGif) {
                if (path.endsWith(".gif") || type.endsWith(".gif")) {
                    this.mGlide.asBitmap().load(path).into((ImageView)((PhotoViewHolder)holder).ivPhoto);
                    ((PhotoViewHolder)holder).tvGif.setVisibility(0);
                } else {
                    this.mGlide.load(path).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into((ImageView)((PhotoViewHolder)holder).ivPhoto);
                    ((PhotoViewHolder)holder).tvGif.setVisibility(8);
                }
            } else {
                this.mGlide.load(path).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into((ImageView)((PhotoViewHolder)holder).ivPhoto);
                ((PhotoViewHolder)holder).tvGif.setVisibility(8);
            }
            ((PhotoViewHolder)holder).vSelector.setVisibility(0);
            ((PhotoViewHolder)holder).tvSelector.setVisibility(0);
            ((PhotoViewHolder)holder).ivPhoto.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int realPosition = position;
                    if (Setting.hasPhotosAd()) {
                        --realPosition;
                    }
                    PhotosAdapter.this.listener.onPhotoClick(position, realPosition);
                }
            });
            ((PhotoViewHolder)holder).vSelector.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotosAdapter.this.isSingle) {
                        PhotosAdapter.this.singleSelector(item, position);
                        return;
                    }
                    if (PhotosAdapter.this.unable) {
                        if (item.selected) {
                            Result.removePhoto(item);
                            if (PhotosAdapter.this.unable) {
                                PhotosAdapter.this.unable = false;
                            }
                            PhotosAdapter.this.listener.onSelectorChanged();
                            PhotosAdapter.this.notifyDataSetChanged();
                            return;
                        }
                        PhotosAdapter.this.listener.onSelectorOutOfMax();
                        return;
                    }
                    boolean bl = item.selected = !item.selected;
                    if (item.selected) {
                        Result.addPhoto(item);
                        ((PhotoViewHolder)holder).tvSelector.setBackgroundResource(R.drawable.bg_select_true_easy_photos);
                        ((PhotoViewHolder)holder).tvSelector.setText((CharSequence)String.valueOf(Result.count()));
                        if (Result.count() == Setting.count) {
                            PhotosAdapter.this.unable = true;
                            PhotosAdapter.this.notifyDataSetChanged();
                        }
                    } else {
                        Result.removePhoto(item);
                        if (PhotosAdapter.this.unable) {
                            PhotosAdapter.this.unable = false;
                        }
                        PhotosAdapter.this.notifyDataSetChanged();
                    }
                    PhotosAdapter.this.listener.onSelectorChanged();
                }
            });
            return;
        }
        if (holder instanceof AdViewHolder) {
            View adView;
            if (!Setting.photoAdIsOk) {
                ((AdViewHolder)holder).adFrame.setVisibility(8);
                return;
            }
            WeakReference weakReference = (WeakReference)this.dataList.get(position);
            if (null != weakReference && null != (adView = (View)weakReference.get())) {
                if (null != adView.getParent() && adView.getParent() instanceof FrameLayout) {
                    ((FrameLayout)adView.getParent()).removeAllViews();
                }
                ((AdViewHolder)holder).adFrame.setVisibility(0);
                ((AdViewHolder)holder).adFrame.removeAllViews();
                ((AdViewHolder)holder).adFrame.addView(adView);
            }
        }
    }

    private void singleSelector(Photo photo, int position) {
        if (!Result.isEmpty()) {
            if (Result.getPhotoPath(0).equals(photo.path)) {
                Result.removePhoto(photo);
                this.notifyItemChanged(position);
            } else {
                Result.removePhoto(0);
                Result.addPhoto(photo);
                this.notifyItemChanged(this.singlePosition);
                this.notifyItemChanged(position);
            }
        } else {
            Result.addPhoto(photo);
            this.notifyItemChanged(position);
        }
        this.listener.onSelectorChanged();
    }

    private void updateSelector(TextView tvSelector, boolean selected, Photo photo, int position) {
        if (selected) {
            String number = Result.getSelectorNumber(photo);
            if (number.equals("0")) {
                tvSelector.setBackgroundResource(R.drawable.bg_select_false_easy_photos);
                tvSelector.setText(null);
                return;
            }
            tvSelector.setText((CharSequence)number);
            tvSelector.setBackgroundResource(R.drawable.bg_select_true_easy_photos);
            if (this.isSingle) {
                this.singlePosition = position;
                tvSelector.setText((CharSequence)"\u221a");
            }
        } else {
            if (this.unable) {
                tvSelector.setBackgroundResource(R.drawable.bg_select_false_unable_easy_photos);
            } else {
                tvSelector.setBackgroundResource(R.drawable.bg_select_false_easy_photos);
            }
            tvSelector.setText(null);
        }
    }

    public int getItemCount() {
        return this.dataList.size();
    }

    public int getItemViewType(int position) {
        if (0 == position && Setting.hasPhotosAd()) {
            return 0;
        }
        return 1;
    }

    public class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        PressedImageView ivPhoto;
        TextView tvSelector;
        View vSelector;
        TextView tvGif;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (PressedImageView)itemView.findViewById(R.id.iv_photo);
            this.tvSelector = (TextView)itemView.findViewById(R.id.tv_selector);
            this.vSelector = itemView.findViewById(R.id.v_selector);
            this.tvGif = (TextView)itemView.findViewById(R.id.tv_gif);
        }
    }

    public static interface OnClickListener {
        public void onPhotoClick(int var1, int var2);

        public void onSelectorOutOfMax();

        public void onSelectorChanged();
    }
}

