/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.utils.system;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;

public class SystemUtils {
    private static SystemUtils instance = null;
    private Context cxt = null;
    private Boolean hasNavigation = null;

    private SystemUtils(Context context) {
        this.cxt = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemUtils getInstance(Context context) {
        if (null != instance) return instance;
        Class<SystemUtils> clazz = SystemUtils.class;
        synchronized (SystemUtils.class) {
            if (null != instance) return instance;
            instance = new SystemUtils(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public boolean hasNavigationBar() {
        if (null == this.hasNavigation) {
            boolean hasMenuKey = ViewConfiguration.get((Context)this.cxt).hasPermanentMenuKey();
            boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
            this.hasNavigation = !hasMenuKey && !hasBackKey;
        }
        return this.hasNavigation;
    }

    public void systemUiInit(Activity activity, View decorView) {
        if (!this.hasNavigationBar()) {
            activity.getWindow().addFlags(256);
            activity.getWindow().addFlags(512);
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            decorView.setSystemUiVisibility(512);
        }
    }

    private void hideStatusBar(Activity activity) {
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        attrs.flags |= 0x400;
        activity.getWindow().setAttributes(attrs);
    }

    private void showStatusBar(Activity activity) {
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        attrs.flags &= 0xFFFFFBFF;
        activity.getWindow().setAttributes(attrs);
    }

    public void systemUiHide(Activity activity, View decorView) {
        if (!this.hasNavigationBar()) {
            this.hideStatusBar(activity);
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            decorView.setSystemUiVisibility(4871);
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            decorView.setSystemUiVisibility(775);
        }
    }

    public void systemUiShow(Activity activity, View decorView) {
        if (!this.hasNavigationBar()) {
            this.showStatusBar(activity);
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            decorView.setSystemUiVisibility(1536);
        }
    }

    public int getStatusBarHeight(Context cxt) {
        int statusBarHeight = -1;
        int resourceId = cxt.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = cxt.getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }
}

