/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.sticker.view;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.TextView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.sticker.view.TextSticker;

public class EditFragment
extends DialogFragment
implements View.OnClickListener {
    private TextView tvSample;
    private EditText et;
    private SeekBar seekBar;
    private TextSticker textSticker = null;
    private InputMethodManager inputMethodManager;

    public static EditFragment show(FragmentManager fm, TextSticker sticker) {
        EditFragment editFragment = new EditFragment();
        editFragment.textSticker = sticker;
        editFragment.show(fm, "edit");
        return editFragment;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getDialog().requestWindowFeature(1);
        View rootView = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.fragment_text_sticker_easy_photos, container);
        this.tvSample = (TextView)rootView.findViewById(R.id.tv_sample);
        this.et = (EditText)rootView.findViewById(R.id.et);
        this.seekBar = (SeekBar)rootView.findViewById(R.id.m_seek_bar);
        this.l(rootView, R.id.iv_red, R.id.iv_orange, R.id.iv_yellow, R.id.iv_green, R.id.iv_cyan, R.id.iv_blue, R.id.iv_purple, R.id.iv_black, R.id.iv_gray, R.id.iv_white, R.id.tv_done, R.id.iv_clear);
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                if (b) {
                    EditFragment.this.setTextAlpha(i);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.et.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                EditFragment.this.tvSample.setText((CharSequence)editable.toString());
                if (null != EditFragment.this.textSticker) {
                    EditFragment.this.textSticker.resetText(editable.toString());
                }
            }
        });
        return rootView;
    }

    private void l(View view, int ... resIds) {
        for (int resId : resIds) {
            view.findViewById(resId).setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onResume() {
        super.onResume();
        this.bindingSticker();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        Window dialogWindow = this.getDialog().getWindow();
        if (null != dialogWindow) {
            dialogWindow.requestFeature(1);
        }
        super.onActivityCreated(savedInstanceState);
        if (null != dialogWindow) {
            dialogWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            dialogWindow.setLayout(-1, -1);
            dialogWindow.setSoftInputMode(16);
        }
    }

    public void bindingSticker() {
        String text = this.textSticker.getText();
        this.tvSample.setText((CharSequence)text);
        this.et.setText((CharSequence)text);
        this.et.setSelection(text.length());
        int alpha = this.textSticker.getTextAlpha();
        float alphaF = (float)alpha / 255.0f;
        this.seekBar.setProgress(alpha);
        this.tvSample.setTextColor(this.textSticker.getTextColor());
        this.tvSample.setAlpha(alphaF);
        this.inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (null != this.inputMethodManager) {
            this.inputMethodManager.showSoftInput((View)this.et, 0);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (R.id.iv_red == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_red_easy_photos));
        } else if (R.id.iv_orange == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_orange_easy_photos));
        } else if (R.id.iv_yellow == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_yellow_easy_photos));
        } else if (R.id.iv_green == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_green_easy_photos));
        } else if (R.id.iv_cyan == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_cyan_easy_photos));
        } else if (R.id.iv_blue == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_blue_easy_photos));
        } else if (R.id.iv_purple == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_purple_easy_photos));
        } else if (R.id.iv_black == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_black_easy_photos));
        } else if (R.id.iv_gray == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_gray_easy_photos));
        } else if (R.id.iv_white == id2) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.text_sticker_white_easy_photos));
        } else if (R.id.tv_done == id2) {
            this.dismiss();
        } else if (R.id.iv_clear == id2) {
            this.et.setText(null);
        }
    }

    private void setTextColor(int color2) {
        this.tvSample.setTextColor(color2);
        this.textSticker.setTextColor(color2);
    }

    private void setTextAlpha(int alpha) {
        this.tvSample.setAlpha((float)alpha / 225.0f);
        this.textSticker.setTextAlpha(alpha);
    }
}

