/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.github.chrisbanes.photoview.OnScaleChangedListener;
import com.github.chrisbanes.photoview.PhotoView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import java.util.ArrayList;

public class PreviewPhotosAdapter
extends RecyclerView.Adapter<PreviewPhotosViewHolder> {
    ArrayList<Photo> photos;
    RequestManager mGlide;
    OnClickListener listener;
    LayoutInflater inflater;

    public PreviewPhotosAdapter(Context cxt, ArrayList<Photo> photos, OnClickListener listener) {
        this.photos = photos;
        this.inflater = LayoutInflater.from((Context)cxt);
        this.listener = listener;
        this.mGlide = Glide.with((Context)cxt);
        RequestOptions options = new RequestOptions().centerInside().error(R.drawable.ic_photo_error_easy_photos);
        this.mGlide.applyDefaultRequestOptions(options);
    }

    public PreviewPhotosViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PreviewPhotosViewHolder(this.inflater.inflate(R.layout.item_preview_photo_easy_photos, parent, false));
    }

    public void onBindViewHolder(PreviewPhotosViewHolder holder, int position) {
        this.mGlide.load((Object)this.photos.get((int)position).path).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into((ImageView)holder.ivPhoto);
        holder.ivPhoto.setScale(1.0f);
        holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewPhotosAdapter.this.listener.onPhotoClick();
            }
        });
        holder.ivPhoto.setOnScaleChangeListener(new OnScaleChangedListener(){

            public void onScaleChange(float scaleFactor, float focusX, float focusY) {
                PreviewPhotosAdapter.this.listener.onPhotoScaleChanged();
            }
        });
    }

    public int getItemCount() {
        return this.photos.size();
    }

    public class PreviewPhotosViewHolder
    extends RecyclerView.ViewHolder {
        public PhotoView ivPhoto;

        public PreviewPhotosViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (PhotoView)itemView.findViewById(R.id.iv_photo);
        }
    }

    public static interface OnClickListener {
        public void onPhotoClick();

        public void onPhotoScaleChanged();
    }
}

