/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.puzzle;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.huantansheng.easyphotos.R;

public class DegreeSeekBar
extends View {
    private static final String TAG = "DegreeSeekBar";
    private Paint mTextPaint;
    private Paint mCirclePaint;
    private Paint.FontMetricsInt mFontMetrics;
    private int mBaseLine;
    private float[] mTextWidths;
    private final Rect mCanvasClipBounds = new Rect();
    private ScrollingListener mScrollingListener;
    private float mLastTouchedPosition;
    private Paint mPointPaint;
    private float mPointMargin;
    private boolean mScrollStarted;
    private int mTotalScrollDistance;
    private Path mIndicatorPath = new Path();
    private int mCurrentDegrees = 0;
    private int mPointCount = 51;
    private int mPointColor;
    private int mTextColor;
    private int mCenterTextColor;
    private float mDragFactor = 2.1f;
    private int mMinReachableDegrees = -45;
    private int mMaxReachableDegrees = 45;
    private String suffix = "";

    public DegreeSeekBar(Context context) {
        this(context, null);
    }

    public DegreeSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DegreeSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public DegreeSeekBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mPointColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.puzzle_menu_easy_photos);
        this.mTextColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.puzzle_menu_easy_photos);
        this.mCenterTextColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.puzzle_selected_frame_easy_photos);
        this.mPointPaint = new Paint(1);
        this.mPointPaint.setStyle(Paint.Style.STROKE);
        this.mPointPaint.setColor(this.mPointColor);
        this.mPointPaint.setStrokeWidth(2.0f);
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setStyle(Paint.Style.STROKE);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(24.0f);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        this.mTextPaint.setAlpha(100);
        this.mFontMetrics = this.mTextPaint.getFontMetricsInt();
        this.mTextWidths = new float[1];
        this.mTextPaint.getTextWidths("0", this.mTextWidths);
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setAlpha(255);
        this.mCirclePaint.setAntiAlias(true);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mPointMargin = (float)w / (float)this.mPointCount;
        this.mBaseLine = (h - this.mFontMetrics.bottom + this.mFontMetrics.top) / 2 - this.mFontMetrics.top;
        this.mIndicatorPath.moveTo((float)(w / 2), (float)(h / 2 + this.mFontMetrics.top / 2 - 18));
        this.mIndicatorPath.rLineTo(-8.0f, -8.0f);
        this.mIndicatorPath.rLineTo(16.0f, 0.0f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mLastTouchedPosition = event.getX();
                if (this.mScrollStarted) break;
                this.mScrollStarted = true;
                if (this.mScrollingListener == null) break;
                this.mScrollingListener.onScrollStart();
                break;
            }
            case 1: {
                this.mScrollStarted = false;
                if (this.mScrollingListener != null) {
                    this.mScrollingListener.onScrollEnd();
                }
                this.invalidate();
                break;
            }
            case 2: {
                float distance = event.getX() - this.mLastTouchedPosition;
                if (this.mCurrentDegrees >= this.mMaxReachableDegrees && distance < 0.0f) {
                    this.mCurrentDegrees = this.mMaxReachableDegrees;
                    this.invalidate();
                    break;
                }
                if (this.mCurrentDegrees <= this.mMinReachableDegrees && distance > 0.0f) {
                    this.mCurrentDegrees = this.mMinReachableDegrees;
                    this.invalidate();
                    break;
                }
                if (distance == 0.0f) break;
                this.onScrollEvent(event, distance);
            }
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        canvas.getClipBounds(this.mCanvasClipBounds);
        int zeroIndex = this.mPointCount / 2 + (0 - this.mCurrentDegrees) / 2;
        this.mPointPaint.setColor(this.mPointColor);
        for (i = 0; i < this.mPointCount; ++i) {
            if (i > zeroIndex - Math.abs(this.mMinReachableDegrees) / 2 && i < zeroIndex + Math.abs(this.mMaxReachableDegrees) / 2 && this.mScrollStarted) {
                this.mPointPaint.setAlpha(255);
            } else {
                this.mPointPaint.setAlpha(100);
            }
            if (i > this.mPointCount / 2 - 8 && i < this.mPointCount / 2 + 8 && i > zeroIndex - Math.abs(this.mMinReachableDegrees) / 2 && i < zeroIndex + Math.abs(this.mMaxReachableDegrees) / 2) {
                if (this.mScrollStarted) {
                    this.mPointPaint.setAlpha(Math.abs(this.mPointCount / 2 - i) * 255 / 8);
                } else {
                    this.mPointPaint.setAlpha(Math.abs(this.mPointCount / 2 - i) * 100 / 8);
                }
            }
            canvas.drawPoint((float)this.mCanvasClipBounds.centerX() + (float)(i - this.mPointCount / 2) * this.mPointMargin, (float)this.mCanvasClipBounds.centerY(), this.mPointPaint);
            if (this.mCurrentDegrees == 0 || i != zeroIndex) continue;
            if (this.mScrollStarted) {
                this.mTextPaint.setAlpha(255);
            } else {
                this.mTextPaint.setAlpha(192);
            }
            this.mPointPaint.setStrokeWidth(4.0f);
            canvas.drawPoint((float)this.mCanvasClipBounds.centerX() + (float)(i - this.mPointCount / 2) * this.mPointMargin, (float)this.mCanvasClipBounds.centerY(), this.mPointPaint);
            this.mPointPaint.setStrokeWidth(2.0f);
            this.mTextPaint.setAlpha(100);
        }
        for (i = -180; i <= 180; i += 15) {
            if (i >= this.mMinReachableDegrees && i <= this.mMaxReachableDegrees) {
                this.drawDegreeText(i, canvas, true);
                continue;
            }
            this.drawDegreeText(i, canvas, false);
        }
        this.mTextPaint.setTextSize(28.0f);
        this.mTextPaint.setAlpha(255);
        this.mTextPaint.setColor(this.mCenterTextColor);
        if (this.mCurrentDegrees >= 10) {
            canvas.drawText(this.mCurrentDegrees + this.suffix, (float)(this.getWidth() / 2) - this.mTextWidths[0], (float)this.mBaseLine, this.mTextPaint);
        } else if (this.mCurrentDegrees <= -10) {
            canvas.drawText(this.mCurrentDegrees + this.suffix, (float)(this.getWidth() / 2) - this.mTextWidths[0] / 2.0f * 3.0f, (float)this.mBaseLine, this.mTextPaint);
        } else if (this.mCurrentDegrees < 0) {
            canvas.drawText(this.mCurrentDegrees + this.suffix, (float)(this.getWidth() / 2) - this.mTextWidths[0], (float)this.mBaseLine, this.mTextPaint);
        } else {
            canvas.drawText(this.mCurrentDegrees + this.suffix, (float)(this.getWidth() / 2) - this.mTextWidths[0] / 2.0f, (float)this.mBaseLine, this.mTextPaint);
        }
        this.mTextPaint.setAlpha(100);
        this.mTextPaint.setTextSize(24.0f);
        this.mTextPaint.setColor(this.mTextColor);
        this.mCirclePaint.setColor(this.mCenterTextColor);
        canvas.drawPath(this.mIndicatorPath, this.mCirclePaint);
        this.mCirclePaint.setColor(this.mCenterTextColor);
    }

    private void drawDegreeText(int degrees, Canvas canvas, boolean canReach) {
        if (canReach) {
            if (this.mScrollStarted) {
                this.mTextPaint.setAlpha(Math.min(255, Math.abs(degrees - this.mCurrentDegrees) * 255 / 15));
                if (Math.abs(degrees - this.mCurrentDegrees) <= 7) {
                    this.mTextPaint.setAlpha(0);
                }
            } else {
                this.mTextPaint.setAlpha(100);
                if (Math.abs(degrees - this.mCurrentDegrees) <= 7) {
                    this.mTextPaint.setAlpha(0);
                }
            }
        } else {
            this.mTextPaint.setAlpha(100);
        }
        if (degrees == 0) {
            if (Math.abs(this.mCurrentDegrees) >= 15 && !this.mScrollStarted) {
                this.mTextPaint.setAlpha(180);
            }
            canvas.drawText("0\u00b0", (float)(this.getWidth() / 2) - this.mTextWidths[0] / 2.0f - (float)(this.mCurrentDegrees / 2) * this.mPointMargin, (float)(this.getHeight() / 2 - 10), this.mTextPaint);
        } else {
            canvas.drawText(degrees + this.suffix, (float)(this.getWidth() / 2) + this.mPointMargin * (float)degrees / 2.0f - this.mTextWidths[0] / 2.0f * 3.0f - (float)(this.mCurrentDegrees / 2) * this.mPointMargin, (float)(this.getHeight() / 2 - 10), this.mTextPaint);
        }
    }

    private void onScrollEvent(MotionEvent event, float distance) {
        this.mTotalScrollDistance = (int)((float)this.mTotalScrollDistance - distance);
        this.postInvalidate();
        this.mLastTouchedPosition = event.getX();
        this.mCurrentDegrees = (int)((float)this.mTotalScrollDistance * this.mDragFactor / this.mPointMargin);
        if (this.mScrollingListener != null) {
            this.mScrollingListener.onScroll(this.mCurrentDegrees);
        }
    }

    public void setDegreeRange(int min, int max) {
        if (min > max) {
            Log.e((String)TAG, (String)"setDegreeRange: error, max must greater than min");
        } else {
            this.mMinReachableDegrees = min;
            this.mMaxReachableDegrees = max;
            if (this.mCurrentDegrees > this.mMaxReachableDegrees || this.mCurrentDegrees < this.mMinReachableDegrees) {
                this.mCurrentDegrees = (this.mMinReachableDegrees + this.mMaxReachableDegrees) / 2;
            }
            this.mTotalScrollDistance = (int)((float)this.mCurrentDegrees * this.mPointMargin / this.mDragFactor);
            this.invalidate();
        }
    }

    public void setCurrentDegrees(int degrees) {
        if (degrees <= this.mMaxReachableDegrees && degrees >= this.mMinReachableDegrees) {
            this.mCurrentDegrees = degrees;
            this.mTotalScrollDistance = (int)((float)degrees * this.mPointMargin / this.mDragFactor);
            this.invalidate();
        }
    }

    public void setScrollingListener(ScrollingListener scrollingListener) {
        this.mScrollingListener = scrollingListener;
    }

    public int getPointColor() {
        return this.mPointColor;
    }

    public void setPointColor(int pointColor) {
        this.mPointColor = pointColor;
        this.mPointPaint.setColor(this.mPointColor);
        this.postInvalidate();
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.mTextPaint.setColor(textColor);
        this.postInvalidate();
    }

    public int getCenterTextColor() {
        return this.mCenterTextColor;
    }

    public void setCenterTextColor(int centerTextColor) {
        this.mCenterTextColor = centerTextColor;
        this.postInvalidate();
    }

    public float getDragFactor() {
        return this.mDragFactor;
    }

    public void setDragFactor(float dragFactor) {
        this.mDragFactor = dragFactor;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public static interface ScrollingListener {
        public void onScrollStart();

        public void onScroll(int var1);

        public void onScrollEnd();
    }
}

