/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.bumptech.glide.Glide;
import com.huantansheng.easyphotos.EasyPhotos;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.models.puzzle.DegreeSeekBar;
import com.huantansheng.easyphotos.models.puzzle.PuzzleLayout;
import com.huantansheng.easyphotos.models.puzzle.PuzzlePiece;
import com.huantansheng.easyphotos.models.puzzle.PuzzleUtils;
import com.huantansheng.easyphotos.models.puzzle.PuzzleView;
import com.huantansheng.easyphotos.ui.adapter.PuzzleAdapter;
import com.huantansheng.easyphotos.utils.bitmap.SaveBitmapCallBack;
import com.huantansheng.easyphotos.utils.permission.PermissionUtil;
import com.huantansheng.easyphotos.utils.settings.SettingsUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PuzzleActivity
extends AppCompatActivity
implements View.OnClickListener,
PuzzleAdapter.OnItemClickListener {
    private static WeakReference<Class<? extends Activity>> toClass;
    ArrayList<Photo> photos = null;
    ArrayList<String> paths = null;
    ArrayList<Bitmap> bitmaps = new ArrayList();
    boolean fileTypeIsPhoto;
    String saveDirPath;
    String saveNamePrefix;
    private PuzzleView puzzleView;
    private PuzzleLayout puzzleLayout;
    private RecyclerView rvPuzzleTemplet;
    private PuzzleAdapter puzzleAdapter;
    private ProgressBar progressBar;
    private int fileCount = 0;
    private LinearLayout llMenu;
    private DegreeSeekBar degreeSeekBar;
    private ArrayList<ImageView> ivMenus = new ArrayList();
    private ArrayList<Integer> degrees = new ArrayList();
    private int degreeIndex = -1;
    private int controlFlag;
    private static final int FLAG_CONTROL_PADDING = 0;
    private static final int FLAG_CONTROL_CORNER = 1;
    private static final int FLAG_CONTROL_ROTATE = 2;
    private int deviceWidth = 0;

    public static void startWithPhotos(Activity act, ArrayList<Photo> photos, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom) {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        Intent intent = new Intent((Context)act, PuzzleActivity.class);
        intent.putExtra("keyOfPuzzleFilesTypeIsPhoto", true);
        intent.putParcelableArrayListExtra("keyOfPuzzleFiles", photos);
        intent.putExtra("keyOfPuzzleSaveDir", puzzleSaveDirPath);
        intent.putExtra("keyOfPuzzleSaveNamePrefix", puzzleSaveNamePrefix);
        if (replaceCustom) {
            toClass = new WeakReference(act.getClass());
        }
        act.startActivityForResult(intent, requestCode);
    }

    public static void startWithPaths(Activity act, ArrayList<String> paths, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom) {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        Intent intent = new Intent((Context)act, PuzzleActivity.class);
        intent.putExtra("keyOfPuzzleFilesTypeIsPhoto", false);
        intent.putStringArrayListExtra("keyOfPuzzleFiles", paths);
        intent.putExtra("keyOfPuzzleSaveDir", puzzleSaveDirPath);
        intent.putExtra("keyOfPuzzleSaveNamePrefix", puzzleSaveNamePrefix);
        if (replaceCustom) {
            toClass = new WeakReference(act.getClass());
        }
        act.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_puzzle_easy_photos);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
        this.initData();
        this.initView();
    }

    private void initView() {
        this.initIvMenu();
        this.initPuzzleView();
        this.initRecyclerView();
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress);
        this.findViewById(R.id.tv_back).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.tv_done).setOnClickListener((View.OnClickListener)this);
    }

    private void initIvMenu() {
        this.llMenu = (LinearLayout)this.findViewById(R.id.ll_menu);
        ImageView ivReplace = (ImageView)this.findViewById(R.id.iv_replace);
        ImageView ivRotate = (ImageView)this.findViewById(R.id.iv_rotate);
        ImageView ivMirror = (ImageView)this.findViewById(R.id.iv_mirror);
        ImageView ivFlip = (ImageView)this.findViewById(R.id.iv_flip);
        ImageView ivCorner = (ImageView)this.findViewById(R.id.iv_corner);
        ImageView ivPadding = (ImageView)this.findViewById(R.id.iv_padding);
        ivReplace.setOnClickListener((View.OnClickListener)this);
        ivRotate.setOnClickListener((View.OnClickListener)this);
        ivMirror.setOnClickListener((View.OnClickListener)this);
        ivFlip.setOnClickListener((View.OnClickListener)this);
        ivCorner.setOnClickListener((View.OnClickListener)this);
        ivPadding.setOnClickListener((View.OnClickListener)this);
        this.ivMenus.add(ivRotate);
        this.ivMenus.add(ivCorner);
        this.ivMenus.add(ivPadding);
        this.degreeSeekBar = (DegreeSeekBar)this.findViewById(R.id.degree_seek_bar);
        this.degreeSeekBar.setScrollingListener(new DegreeSeekBar.ScrollingListener(){

            @Override
            public void onScrollStart() {
            }

            @Override
            public void onScroll(int currentDegrees) {
                switch (PuzzleActivity.this.controlFlag) {
                    case 0: {
                        PuzzleActivity.this.puzzleView.setPiecePadding(currentDegrees);
                        break;
                    }
                    case 1: {
                        if (currentDegrees < 0) {
                            currentDegrees = 0;
                        }
                        PuzzleActivity.this.puzzleView.setPieceRadian(currentDegrees);
                        break;
                    }
                    case 2: {
                        PuzzleActivity.this.puzzleView.rotate(currentDegrees - (Integer)PuzzleActivity.this.degrees.get(PuzzleActivity.this.degreeIndex));
                        PuzzleActivity.this.degrees.remove(PuzzleActivity.this.degreeIndex);
                        PuzzleActivity.this.degrees.add(PuzzleActivity.this.degreeIndex, currentDegrees);
                    }
                }
            }

            @Override
            public void onScrollEnd() {
            }
        });
    }

    private void initRecyclerView() {
        this.rvPuzzleTemplet = (RecyclerView)this.findViewById(R.id.rv_puzzle_template);
        this.puzzleAdapter = new PuzzleAdapter();
        this.puzzleAdapter.setOnItemClickListener(this);
        this.rvPuzzleTemplet.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        this.rvPuzzleTemplet.setAdapter((RecyclerView.Adapter)this.puzzleAdapter);
        this.puzzleAdapter.refreshData(PuzzleUtils.getPuzzleLayouts(this.fileCount));
    }

    private void initPuzzleView() {
        int themeType = this.fileCount > 3 ? 1 : 0;
        this.puzzleLayout = PuzzleUtils.getPuzzleLayout(themeType, this.fileCount, 0);
        this.puzzleView = (PuzzleView)this.findViewById(R.id.puzzle_view);
        this.puzzleView.setPuzzleLayout(this.puzzleLayout);
        this.puzzleView.setOnPieceSelectedListener(new PuzzleView.OnPieceSelectedListener(){

            @Override
            public void onPieceSelected(PuzzlePiece piece, int position) {
                if (null == piece) {
                    PuzzleActivity.this.toggleIvMenu(R.id.iv_replace);
                    PuzzleActivity.this.llMenu.setVisibility(4);
                    PuzzleActivity.this.degreeSeekBar.setVisibility(4);
                    PuzzleActivity.this.degreeIndex = -1;
                    PuzzleActivity.this.controlFlag = -1;
                    return;
                }
                if (PuzzleActivity.this.degreeIndex != position) {
                    PuzzleActivity.this.controlFlag = -1;
                    PuzzleActivity.this.toggleIvMenu(R.id.iv_replace);
                    PuzzleActivity.this.degreeSeekBar.setVisibility(4);
                }
                PuzzleActivity.this.llMenu.setVisibility(0);
                PuzzleActivity.this.degreeIndex = position;
            }
        });
    }

    private void loadPhoto() {
        this.puzzleView.addPieces(this.bitmaps);
    }

    private void initData() {
        this.deviceWidth = this.getResources().getDisplayMetrics().widthPixels;
        Intent intent = this.getIntent();
        this.fileTypeIsPhoto = intent.getBooleanExtra("keyOfPuzzleFilesTypeIsPhoto", false);
        this.saveDirPath = intent.getStringExtra("keyOfPuzzleSaveDir");
        this.saveNamePrefix = intent.getStringExtra("keyOfPuzzleSaveNamePrefix");
        if (this.fileTypeIsPhoto) {
            this.photos = intent.getParcelableArrayListExtra("keyOfPuzzleFiles");
            this.fileCount = this.photos.size() > 9 ? 9 : this.photos.size();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < PuzzleActivity.this.fileCount; ++i) {
                        Bitmap bitmap = PuzzleActivity.this.getScaleBitmap(PuzzleActivity.this.photos.get((int)i).path);
                        PuzzleActivity.this.bitmaps.add(bitmap);
                        PuzzleActivity.this.degrees.add(0);
                    }
                    PuzzleActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            PuzzleActivity.this.puzzleView.post(new Runnable(){

                                @Override
                                public void run() {
                                    PuzzleActivity.this.loadPhoto();
                                }
                            });
                        }
                    });
                }
            }).start();
        } else {
            this.paths = intent.getStringArrayListExtra("keyOfPuzzleFiles");
            this.fileCount = this.paths.size() > 0 ? 9 : this.paths.size();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < PuzzleActivity.this.fileCount; ++i) {
                        Bitmap bitmap = PuzzleActivity.this.getScaleBitmap(PuzzleActivity.this.paths.get(i));
                        PuzzleActivity.this.bitmaps.add(bitmap);
                        PuzzleActivity.this.degrees.add(0);
                    }
                    PuzzleActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            PuzzleActivity.this.puzzleView.post(new Runnable(){

                                @Override
                                public void run() {
                                    PuzzleActivity.this.loadPhoto();
                                }
                            });
                        }
                    });
                }
            }).start();
        }
    }

    private Bitmap getScaleBitmap(String path) {
        Bitmap bitmap = null;
        try {
            bitmap = (Bitmap)Glide.with((FragmentActivity)this).asBitmap().load(path).submit(this.deviceWidth, this.deviceWidth).get();
        }
        catch (Exception e) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)BitmapFactory.decodeFile((String)path), (int)this.deviceWidth, (int)this.deviceWidth, (boolean)true);
        }
        return bitmap;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (R.id.tv_back == id2) {
            this.finish();
        } else if (R.id.tv_done == id2) {
            if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
                this.savePhoto();
            }
        } else if (R.id.iv_replace == id2) {
            this.controlFlag = -1;
            this.degreeSeekBar.setVisibility(4);
            this.toggleIvMenu(R.id.iv_replace);
            if (null == toClass) {
                EasyPhotos.createAlbum((Activity)this, true).setCount(1).start(91);
            } else {
                Intent intent = new Intent((Context)this, (Class)toClass.get());
                this.startActivityForResult(intent, 91);
            }
        } else if (R.id.iv_rotate == id2) {
            if (this.controlFlag == 2) {
                if (this.degrees.get(this.degreeIndex) % 90 != 0) {
                    this.puzzleView.rotate(-this.degrees.get(this.degreeIndex).intValue());
                    this.degrees.remove(this.degreeIndex);
                    this.degrees.add(this.degreeIndex, 0);
                    this.degreeSeekBar.setCurrentDegrees(0);
                    return;
                }
                this.puzzleView.rotate(90.0f);
                int degree = this.degrees.get(this.degreeIndex) + 90;
                if (degree == 360 || degree == -360) {
                    degree = 0;
                }
                this.degrees.remove(this.degreeIndex);
                this.degrees.add(this.degreeIndex, degree);
                this.degreeSeekBar.setCurrentDegrees(this.degrees.get(this.degreeIndex));
                return;
            }
            this.handleSeekBar(2, -360, 360, this.degrees.get(this.degreeIndex).intValue());
            this.toggleIvMenu(R.id.iv_rotate);
        } else if (R.id.iv_mirror == id2) {
            this.degreeSeekBar.setVisibility(4);
            this.controlFlag = -1;
            this.toggleIvMenu(R.id.iv_mirror);
            this.puzzleView.flipHorizontally();
        } else if (R.id.iv_flip == id2) {
            this.controlFlag = -1;
            this.degreeSeekBar.setVisibility(4);
            this.toggleIvMenu(R.id.iv_flip);
            this.puzzleView.flipVertically();
        } else if (R.id.iv_corner == id2) {
            this.handleSeekBar(1, 0, 1000, this.puzzleView.getPieceRadian());
            this.toggleIvMenu(R.id.iv_corner);
        } else if (R.id.iv_padding == id2) {
            this.handleSeekBar(0, 0, 100, this.puzzleView.getPiecePadding());
            this.toggleIvMenu(R.id.iv_padding);
        }
    }

    private void handleSeekBar(int controlFlag, int rangeStart, int rangeEnd, float degrees) {
        this.controlFlag = controlFlag;
        this.degreeSeekBar.setVisibility(0);
        this.degreeSeekBar.setDegreeRange(rangeStart, rangeEnd);
        this.degreeSeekBar.setCurrentDegrees((int)degrees);
    }

    private void savePhoto() {
        this.progressBar.setVisibility(0);
        this.findViewById(R.id.tv_done).setVisibility(4);
        this.findViewById(R.id.progress_frame).setVisibility(0);
        final Bitmap bitmap = EasyPhotos.createBitmapFromView(this.puzzleView);
        EasyPhotos.saveBitmapToDir((Activity)this, this.saveDirPath, this.saveNamePrefix, bitmap, true, new SaveBitmapCallBack(){

            @Override
            public void onSuccess(String path) {
                Intent intent = new Intent();
                intent.putExtra("keyOfEasyPhotosResultPuzzlePath", path);
                File file = new File(path);
                Photo photo = new Photo(false, file.getName(), path, file.lastModified() / 1000L, bitmap.getWidth(), bitmap.getHeight(), file.length(), "image/png");
                intent.putExtra("keyOfEasyPhotosResultPuzzlePhoto", (Parcelable)photo);
                PuzzleActivity.this.setResult(-1, intent);
                PuzzleActivity.this.finish();
            }

            @Override
            public void onFailed(String errorInfo) {
                PuzzleActivity.this.setResult(-1);
                PuzzleActivity.this.finish();
            }
        });
    }

    private void toggleIvMenu(@IdRes int resId) {
        for (ImageView ivMenu : this.ivMenus) {
            if (ivMenu.getId() == resId) {
                ivMenu.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.puzzle_selected_frame_easy_photos));
                continue;
            }
            ivMenu.clearColorFilter();
        }
    }

    @Override
    public void onItemClick(int themeType, int themeId) {
        this.puzzleView.setPuzzleLayout(PuzzleUtils.getPuzzleLayout(themeType, this.fileCount, themeId));
        this.loadPhoto();
        this.resetDegress();
    }

    private void resetDegress() {
        this.degreeIndex = -1;
        this.llMenu.setVisibility(4);
        this.degreeSeekBar.setVisibility(4);
        for (int i = 0; i < this.degrees.size(); ++i) {
            this.degrees.remove(i);
            this.degrees.add(i, 0);
        }
    }

    protected void onDestroy() {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 14) {
            if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
                this.savePhoto();
            }
            return;
        }
        switch (resultCode) {
            case -1: {
                this.degrees.remove(this.degreeIndex);
                this.degrees.add(this.degreeIndex, 0);
                String tempPath = "";
                if (this.fileTypeIsPhoto) {
                    ArrayList photos = data.getParcelableArrayListExtra("keyOfEasyPhotosResult");
                    Photo photo = (Photo)photos.get(0);
                    tempPath = photo.path;
                } else {
                    tempPath = (String)data.getStringArrayListExtra("keyOfEasyPhotosResultPaths").get(0);
                }
                final String path = tempPath;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final Bitmap bitmap = PuzzleActivity.this.getScaleBitmap(path);
                        PuzzleActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                PuzzleActivity.this.puzzleView.replace(bitmap);
                            }
                        });
                    }
                }).start();
                break;
            }
            case 0: {
                break;
            }
        }
    }

    protected String[] getNeedPermissions() {
        if (Build.VERSION.SDK_INT >= 16) {
            return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onPermissionResult((Activity)this, permissions, grantResults, new PermissionUtil.PermissionCallBack(){

            @Override
            public void onSuccess() {
                PuzzleActivity.this.savePhoto();
            }

            @Override
            public void onShouldShow() {
                Snackbar.make((View)PuzzleActivity.this.rvPuzzleTemplet, (int)R.string.permissions_again_easy_photos, (int)-2).setAction((CharSequence)"go", new View.OnClickListener(){

                    public void onClick(View view) {
                        if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)PuzzleActivity.this, PuzzleActivity.this.getNeedPermissions())) {
                            PuzzleActivity.this.savePhoto();
                        }
                    }
                }).show();
            }

            @Override
            public void onFailed() {
                Snackbar.make((View)PuzzleActivity.this.rvPuzzleTemplet, (int)R.string.permissions_die_easy_photos, (int)-2).setAction((CharSequence)"go", new View.OnClickListener(){

                    public void onClick(View view) {
                        SettingsUtils.startMyApplicationDetailsForResult((Activity)PuzzleActivity.this, PuzzleActivity.this.getPackageName());
                    }
                }).show();
            }
        });
    }
}

