/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.puzzle;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.puzzle.Area;
import com.huantansheng.easyphotos.models.puzzle.Line;
import com.huantansheng.easyphotos.models.puzzle.MatrixUtils;
import com.huantansheng.easyphotos.models.puzzle.PuzzleLayout;
import com.huantansheng.easyphotos.models.puzzle.PuzzlePiece;
import java.util.ArrayList;
import java.util.List;

public class PuzzleView
extends View {
    private static final String TAG = "SlantPuzzleView";
    private ActionMode currentMode = ActionMode.NONE;
    private List<PuzzlePiece> puzzlePieces = new ArrayList<PuzzlePiece>();
    private List<PuzzlePiece> needChangePieces = new ArrayList<PuzzlePiece>();
    private PuzzleLayout puzzleLayout;
    private RectF bounds;
    private int lineSize;
    private int duration;
    private Line handlingLine;
    private PuzzlePiece handlingPiece;
    private PuzzlePiece replacePiece;
    private PuzzlePiece previousHandlingPiece;
    private Paint linePaint;
    private Paint selectedAreaPaint;
    private Paint handleBarPaint;
    private float downX;
    private float downY;
    private float previousDistance;
    private PointF midPoint;
    private boolean needDrawLine;
    private boolean needDrawOuterLine;
    private boolean touchEnable = true;
    private int lineColor;
    private int selectedLineColor;
    private int handleBarColor;
    private float piecePadding;
    private float pieceRadian;
    private boolean needResetPieceMatrix = true;
    private OnPieceSelectedListener onPieceSelectedListener;
    private Runnable switchToSwapAction = new Runnable(){

        @Override
        public void run() {
            PuzzleView.this.currentMode = ActionMode.SWAP;
            PuzzleView.this.invalidate();
        }
    };

    public PuzzleView(Context context) {
        this(context, null);
    }

    public PuzzleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PuzzleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.PuzzleView);
        this.lineSize = ta.getInt(R.styleable.PuzzleView_line_size, 4);
        this.lineColor = ta.getColor(R.styleable.PuzzleView_line_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.puzzle_menu_easy_photos));
        this.selectedLineColor = ta.getColor(R.styleable.PuzzleView_selected_line_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.puzzle_selected_frame_easy_photos));
        this.handleBarColor = ta.getColor(R.styleable.PuzzleView_handle_bar_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.puzzle_selected_controller_easy_photos));
        this.piecePadding = ta.getDimensionPixelSize(R.styleable.PuzzleView_piece_padding, 0);
        this.needDrawLine = ta.getBoolean(R.styleable.PuzzleView_need_draw_line, false);
        this.needDrawOuterLine = ta.getBoolean(R.styleable.PuzzleView_need_draw_outer_line, false);
        this.duration = ta.getInt(R.styleable.PuzzleView_animation_duration, 300);
        this.pieceRadian = ta.getFloat(R.styleable.PuzzleView_radian, 0.0f);
        ta.recycle();
        this.bounds = new RectF();
        this.linePaint = new Paint();
        this.linePaint.setAntiAlias(true);
        this.linePaint.setColor(this.lineColor);
        this.linePaint.setStrokeWidth((float)this.lineSize);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setStrokeJoin(Paint.Join.ROUND);
        this.linePaint.setStrokeCap(Paint.Cap.SQUARE);
        this.selectedAreaPaint = new Paint();
        this.selectedAreaPaint.setAntiAlias(true);
        this.selectedAreaPaint.setStyle(Paint.Style.STROKE);
        this.selectedAreaPaint.setStrokeJoin(Paint.Join.ROUND);
        this.selectedAreaPaint.setStrokeCap(Paint.Cap.ROUND);
        this.selectedAreaPaint.setColor(this.selectedLineColor);
        this.selectedAreaPaint.setStrokeWidth((float)this.lineSize);
        this.handleBarPaint = new Paint();
        this.handleBarPaint.setAntiAlias(true);
        this.handleBarPaint.setStyle(Paint.Style.FILL);
        this.handleBarPaint.setColor(this.handleBarColor);
        this.handleBarPaint.setStrokeWidth((float)(this.lineSize * 3));
        this.midPoint = new PointF();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.resetPuzzleBounds();
        if (this.puzzlePieces.size() != 0) {
            for (int i = 0; i < this.puzzlePieces.size(); ++i) {
                PuzzlePiece piece = this.puzzlePieces.get(i);
                piece.setArea(this.puzzleLayout.getArea(i));
                if (this.needResetPieceMatrix) {
                    piece.set(MatrixUtils.generateMatrix(piece, 0.0f));
                    continue;
                }
                piece.fillArea(this, true);
            }
        }
        this.invalidate();
    }

    private void resetPuzzleBounds() {
        this.bounds.left = this.getPaddingLeft();
        this.bounds.top = this.getPaddingTop();
        this.bounds.right = this.getWidth() - this.getPaddingRight();
        this.bounds.bottom = this.getHeight() - this.getPaddingBottom();
        if (this.puzzleLayout != null) {
            this.puzzleLayout.reset();
            this.puzzleLayout.setOuterBounds(this.bounds);
            this.puzzleLayout.layout();
            this.puzzleLayout.setPadding(this.piecePadding);
            this.puzzleLayout.setRadian(this.pieceRadian);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.puzzleLayout == null) {
            return;
        }
        this.linePaint.setStrokeWidth((float)this.lineSize);
        this.selectedAreaPaint.setStrokeWidth((float)this.lineSize);
        this.handleBarPaint.setStrokeWidth((float)(this.lineSize * 3));
        for (int i = 0; i < this.puzzleLayout.getAreaCount() && i < this.puzzlePieces.size(); ++i) {
            PuzzlePiece piece = this.puzzlePieces.get(i);
            if (piece == this.handlingPiece && this.currentMode == ActionMode.SWAP || this.puzzlePieces.size() <= i) continue;
            piece.draw(canvas);
        }
        if (this.needDrawOuterLine) {
            for (Line outerLine : this.puzzleLayout.getOuterLines()) {
                this.drawLine(canvas, outerLine);
            }
        }
        if (this.needDrawLine) {
            for (Line line : this.puzzleLayout.getLines()) {
                this.drawLine(canvas, line);
            }
        }
        if (this.handlingPiece != null && this.currentMode != ActionMode.SWAP) {
            this.drawSelectedArea(canvas, this.handlingPiece);
        }
        if (this.handlingPiece != null && this.currentMode == ActionMode.SWAP) {
            this.handlingPiece.draw(canvas, 128);
            if (this.replacePiece != null) {
                this.drawSelectedArea(canvas, this.replacePiece);
            }
        }
    }

    private void drawSelectedArea(Canvas canvas, PuzzlePiece piece) {
        Area area = piece.getArea();
        canvas.drawPath(area.getAreaPath(), this.selectedAreaPaint);
        for (Line line : area.getLines()) {
            if (!this.puzzleLayout.getLines().contains(line)) continue;
            PointF[] handleBarPoints = area.getHandleBarPoints(line);
            canvas.drawLine(handleBarPoints[0].x, handleBarPoints[0].y, handleBarPoints[1].x, handleBarPoints[1].y, this.handleBarPaint);
            canvas.drawCircle(handleBarPoints[0].x, handleBarPoints[0].y, (float)(this.lineSize * 3 / 2), this.handleBarPaint);
            canvas.drawCircle(handleBarPoints[1].x, handleBarPoints[1].y, (float)(this.lineSize * 3 / 2), this.handleBarPaint);
        }
    }

    private void drawLine(Canvas canvas, Line line) {
        canvas.drawLine(line.startPoint().x, line.startPoint().y, line.endPoint().x, line.endPoint().y, this.linePaint);
    }

    public void setPuzzleLayout(PuzzleLayout puzzleLayout) {
        this.clearPieces();
        this.puzzleLayout = puzzleLayout;
        this.puzzleLayout.setOuterBounds(this.bounds);
        this.puzzleLayout.layout();
        this.invalidate();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.touchEnable) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.downX = event.getX();
                this.downY = event.getY();
                this.decideActionMode(event);
                this.prepareAction(event);
                break;
            }
            case 5: {
                this.previousDistance = this.calculateDistance(event);
                this.calculateMidPoint(event, this.midPoint);
                this.decideActionMode(event);
                break;
            }
            case 2: {
                this.performAction(event);
                if (!(Math.abs(event.getX() - this.downX) > 10.0f) && !(Math.abs(event.getY() - this.downY) > 10.0f) || this.currentMode == ActionMode.SWAP) break;
                this.removeCallbacks(this.switchToSwapAction);
                break;
            }
            case 1: 
            case 3: {
                this.finishAction(event);
                this.currentMode = ActionMode.NONE;
                this.removeCallbacks(this.switchToSwapAction);
            }
        }
        this.invalidate();
        return true;
    }

    private void decideActionMode(MotionEvent event) {
        for (PuzzlePiece piece : this.puzzlePieces) {
            if (!piece.isAnimateRunning()) continue;
            this.currentMode = ActionMode.NONE;
            return;
        }
        if (event.getPointerCount() == 1) {
            this.handlingLine = this.findHandlingLine();
            if (this.handlingLine != null) {
                this.currentMode = ActionMode.MOVE;
            } else {
                this.handlingPiece = this.findHandlingPiece();
                if (this.handlingPiece != null) {
                    this.currentMode = ActionMode.DRAG;
                    this.postDelayed(this.switchToSwapAction, 500L);
                }
            }
        } else if (event.getPointerCount() > 1 && this.handlingPiece != null && this.handlingPiece.contains(event.getX(1), event.getY(1)) && this.currentMode == ActionMode.DRAG) {
            this.currentMode = ActionMode.ZOOM;
        }
    }

    private void prepareAction(MotionEvent event) {
        switch (this.currentMode) {
            case NONE: {
                break;
            }
            case DRAG: {
                this.handlingPiece.record();
                break;
            }
            case ZOOM: {
                this.handlingPiece.record();
                break;
            }
            case MOVE: {
                this.handlingLine.prepareMove();
                this.needChangePieces.clear();
                this.needChangePieces.addAll(this.findNeedChangedPieces());
                for (PuzzlePiece piece : this.needChangePieces) {
                    piece.record();
                    piece.setPreviousMoveX(this.downX);
                    piece.setPreviousMoveY(this.downY);
                }
                break;
            }
        }
    }

    private void performAction(MotionEvent event) {
        switch (this.currentMode) {
            case NONE: {
                break;
            }
            case DRAG: {
                this.dragPiece(this.handlingPiece, event);
                break;
            }
            case ZOOM: {
                this.zoomPiece(this.handlingPiece, event);
                break;
            }
            case SWAP: {
                this.dragPiece(this.handlingPiece, event);
                this.replacePiece = this.findReplacePiece(event);
                break;
            }
            case MOVE: {
                this.moveLine(this.handlingLine, event);
            }
        }
    }

    private void finishAction(MotionEvent event) {
        switch (this.currentMode) {
            case NONE: {
                break;
            }
            case DRAG: {
                if (this.handlingPiece != null && !this.handlingPiece.isFilledArea()) {
                    this.handlingPiece.moveToFillArea(this);
                }
                if (this.previousHandlingPiece == this.handlingPiece && Math.abs(this.downX - event.getX()) < 3.0f && Math.abs(this.downY - event.getY()) < 3.0f) {
                    this.handlingPiece = null;
                }
                if (this.onPieceSelectedListener != null) {
                    this.onPieceSelectedListener.onPieceSelected(this.handlingPiece, this.puzzlePieces.indexOf(this.handlingPiece));
                }
                this.previousHandlingPiece = this.handlingPiece;
                break;
            }
            case ZOOM: {
                if (this.handlingPiece != null && !this.handlingPiece.isFilledArea()) {
                    if (this.handlingPiece.canFilledArea()) {
                        this.handlingPiece.moveToFillArea(this);
                    } else {
                        this.handlingPiece.fillArea(this, false);
                    }
                }
                this.previousHandlingPiece = this.handlingPiece;
                break;
            }
            case MOVE: {
                break;
            }
            case SWAP: {
                if (this.handlingPiece == null || this.replacePiece == null) break;
                Drawable temp = this.handlingPiece.getDrawable();
                this.handlingPiece.setDrawable(this.replacePiece.getDrawable());
                this.replacePiece.setDrawable(temp);
                this.handlingPiece.fillArea(this, true);
                this.replacePiece.fillArea(this, true);
                this.handlingPiece = null;
                this.replacePiece = null;
                this.previousHandlingPiece = null;
                if (this.onPieceSelectedListener == null) break;
                this.onPieceSelectedListener.onPieceSelected(null, 0);
            }
        }
        this.handlingLine = null;
        this.needChangePieces.clear();
    }

    private void moveLine(Line line, MotionEvent event) {
        if (line == null || event == null) {
            return;
        }
        boolean needUpdate = line.direction() == Line.Direction.HORIZONTAL ? line.move(event.getY() - this.downY, 80.0f) : line.move(event.getX() - this.downX, 80.0f);
        if (needUpdate) {
            this.puzzleLayout.update();
            this.updatePiecesInArea(line, event);
        }
    }

    private void updatePiecesInArea(Line line, MotionEvent event) {
        for (int i = 0; i < this.needChangePieces.size(); ++i) {
            this.needChangePieces.get(i).updateWith(event, line);
        }
    }

    private void zoomPiece(PuzzlePiece piece, MotionEvent event) {
        if (piece == null || event == null || event.getPointerCount() < 2) {
            return;
        }
        float scale = this.calculateDistance(event) / this.previousDistance;
        piece.zoomAndTranslate(scale, scale, this.midPoint, event.getX() - this.downX, event.getY() - this.downY);
    }

    private void dragPiece(PuzzlePiece piece, MotionEvent event) {
        if (piece == null || event == null) {
            return;
        }
        piece.translate(event.getX() - this.downX, event.getY() - this.downY);
    }

    public void replace(Bitmap bitmap) {
        this.replace((Drawable)new BitmapDrawable(this.getResources(), bitmap));
    }

    public void replace(final Drawable bitmapDrawable) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (PuzzleView.this.handlingPiece == null) {
                    return;
                }
                PuzzleView.this.handlingPiece.setDrawable(bitmapDrawable);
                PuzzleView.this.handlingPiece.set(MatrixUtils.generateMatrix(PuzzleView.this.handlingPiece, 0.0f));
                PuzzleView.this.postInvalidate();
            }
        });
    }

    public void flipVertically() {
        if (this.handlingPiece == null) {
            return;
        }
        this.handlingPiece.postFlipVertically();
        this.handlingPiece.record();
        this.invalidate();
    }

    public void flipHorizontally() {
        if (this.handlingPiece == null) {
            return;
        }
        this.handlingPiece.postFlipHorizontally();
        this.handlingPiece.record();
        this.invalidate();
    }

    public void rotate(float degree) {
        if (this.handlingPiece == null) {
            return;
        }
        this.handlingPiece.postRotate(degree);
        this.handlingPiece.record();
        this.invalidate();
    }

    private PuzzlePiece findHandlingPiece() {
        for (PuzzlePiece piece : this.puzzlePieces) {
            if (!piece.contains(this.downX, this.downY)) continue;
            return piece;
        }
        return null;
    }

    private Line findHandlingLine() {
        for (Line line : this.puzzleLayout.getLines()) {
            if (!line.contains(this.downX, this.downY, 40.0f)) continue;
            return line;
        }
        return null;
    }

    private PuzzlePiece findReplacePiece(MotionEvent event) {
        for (PuzzlePiece piece : this.puzzlePieces) {
            if (!piece.contains(event.getX(), event.getY())) continue;
            return piece;
        }
        return null;
    }

    private List<PuzzlePiece> findNeedChangedPieces() {
        if (this.handlingLine == null) {
            return new ArrayList<PuzzlePiece>();
        }
        ArrayList<PuzzlePiece> needChanged = new ArrayList<PuzzlePiece>();
        for (PuzzlePiece piece : this.puzzlePieces) {
            if (!piece.contains(this.handlingLine)) continue;
            needChanged.add(piece);
        }
        return needChanged;
    }

    private float calculateDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void calculateMidPoint(MotionEvent event, PointF point) {
        point.x = (event.getX(0) + event.getX(1)) / 2.0f;
        point.y = (event.getY(0) + event.getY(1)) / 2.0f;
    }

    public void reset() {
        this.clearPieces();
        if (this.puzzleLayout != null) {
            this.puzzleLayout.reset();
        }
    }

    public void clearPieces() {
        this.handlingLine = null;
        this.handlingPiece = null;
        this.replacePiece = null;
        this.needChangePieces.clear();
        this.puzzlePieces.clear();
    }

    public void addPieces(List<Bitmap> bitmaps) {
        for (Bitmap bitmap : bitmaps) {
            this.addPiece(bitmap);
        }
        this.postInvalidate();
    }

    public void addPiece(Bitmap bitmap) {
        BitmapDrawable bitmapDrawable = new BitmapDrawable(this.getResources(), bitmap);
        bitmapDrawable.setAntiAlias(true);
        bitmapDrawable.setFilterBitmap(true);
        this.addPiece((Drawable)bitmapDrawable);
    }

    public void addPiece(Drawable drawable) {
        int position = this.puzzlePieces.size();
        if (position >= this.puzzleLayout.getAreaCount()) {
            Log.e((String)TAG, (String)("addPiece: can not add more. the current puzzle layout can contains " + this.puzzleLayout.getAreaCount() + " puzzle piece."));
            return;
        }
        Area area = this.puzzleLayout.getArea(position);
        area.setPadding(this.piecePadding);
        PuzzlePiece piece = new PuzzlePiece(drawable, area, new Matrix());
        Matrix matrix = MatrixUtils.generateMatrix(area, drawable, 0.0f);
        piece.set(matrix);
        piece.setAnimateDuration(this.duration);
        this.puzzlePieces.add(piece);
        this.setPiecePadding(this.piecePadding);
        this.setPieceRadian(this.pieceRadian);
        this.invalidate();
    }

    public void setAnimateDuration(int duration) {
        this.duration = duration;
        for (PuzzlePiece piece : this.puzzlePieces) {
            piece.setAnimateDuration(duration);
        }
    }

    public boolean isNeedDrawLine() {
        return this.needDrawLine;
    }

    public void setNeedDrawLine(boolean needDrawLine) {
        this.needDrawLine = needDrawLine;
        this.handlingPiece = null;
        this.previousHandlingPiece = null;
        this.invalidate();
    }

    public boolean isNeedDrawOuterLine() {
        return this.needDrawOuterLine;
    }

    public void setNeedDrawOuterLine(boolean needDrawOuterLine) {
        this.needDrawOuterLine = needDrawOuterLine;
        this.invalidate();
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(int lineColor) {
        this.lineColor = lineColor;
        this.linePaint.setColor(lineColor);
        this.invalidate();
    }

    public int getLineSize() {
        return this.lineSize;
    }

    public void setLineSize(int lineSize) {
        this.lineSize = lineSize;
        this.invalidate();
    }

    public int getSelectedLineColor() {
        return this.selectedLineColor;
    }

    public void setSelectedLineColor(int selectedLineColor) {
        this.selectedLineColor = selectedLineColor;
        this.selectedAreaPaint.setColor(selectedLineColor);
        this.invalidate();
    }

    public int getHandleBarColor() {
        return this.handleBarColor;
    }

    public void setHandleBarColor(int handleBarColor) {
        this.handleBarColor = handleBarColor;
        this.handleBarPaint.setColor(handleBarColor);
        this.invalidate();
    }

    public boolean isTouchEnable() {
        return this.touchEnable;
    }

    public void setTouchEnable(boolean touchEnable) {
        this.touchEnable = touchEnable;
    }

    public void clearHandling() {
        this.handlingPiece = null;
        this.handlingLine = null;
        this.replacePiece = null;
        this.previousHandlingPiece = null;
        this.needChangePieces.clear();
    }

    public void setPiecePadding(float padding) {
        this.piecePadding = padding;
        if (this.puzzleLayout != null) {
            this.puzzleLayout.setPadding(padding);
        }
        this.invalidate();
    }

    public void setPieceRadian(float radian) {
        this.pieceRadian = radian;
        if (this.puzzleLayout != null) {
            this.puzzleLayout.setRadian(radian);
        }
        this.invalidate();
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        if (this.puzzleLayout != null) {
            this.puzzleLayout.setColor(color2);
        }
    }

    public void setNeedResetPieceMatrix(boolean needResetPieceMatrix) {
        this.needResetPieceMatrix = needResetPieceMatrix;
    }

    public float getPiecePadding() {
        return this.piecePadding;
    }

    public float getPieceRadian() {
        return this.pieceRadian;
    }

    public void setOnPieceSelectedListener(OnPieceSelectedListener onPieceSelectedListener) {
        this.onPieceSelectedListener = onPieceSelectedListener;
    }

    public static interface OnPieceSelectedListener {
        public void onPieceSelected(PuzzlePiece var1, int var2);
    }

    private static enum ActionMode {
        NONE,
        DRAG,
        ZOOM,
        MOVE,
        SWAP;

    }
}

