/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.puzzle;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.huantansheng.easyphotos.models.puzzle.Area;
import com.huantansheng.easyphotos.models.puzzle.PuzzlePiece;
import java.util.Arrays;

public class MatrixUtils {
    private static final float[] sMatrixValues = new float[9];
    private static final Matrix sTempMatrix = new Matrix();

    private MatrixUtils() {
    }

    public static float getMatrixScale(Matrix matrix) {
        return (float)Math.sqrt(Math.pow(MatrixUtils.getMatrixValue(matrix, 0), 2.0) + Math.pow(MatrixUtils.getMatrixValue(matrix, 3), 2.0));
    }

    public static float getMatrixAngle(Matrix matrix) {
        return (float)(-(Math.atan2(MatrixUtils.getMatrixValue(matrix, 1), MatrixUtils.getMatrixValue(matrix, 0)) * 57.29577951308232));
    }

    public static float getMatrixValue(Matrix matrix, int valueIndex) {
        matrix.getValues(sMatrixValues);
        return sMatrixValues[valueIndex];
    }

    public static float getMinMatrixScale(PuzzlePiece piece) {
        if (piece != null) {
            sTempMatrix.reset();
            sTempMatrix.setRotate(-piece.getMatrixAngle());
            float[] unrotatedCropBoundsCorners = MatrixUtils.getCornersFromRect(piece.getArea().getAreaRect());
            sTempMatrix.mapPoints(unrotatedCropBoundsCorners);
            RectF unrotatedCropRect = MatrixUtils.trapToRect(unrotatedCropBoundsCorners);
            return Math.max(unrotatedCropRect.width() / (float)piece.getWidth(), unrotatedCropRect.height() / (float)piece.getHeight());
        }
        return 1.0f;
    }

    static boolean judgeIsImageContainsBorder(PuzzlePiece piece, float rotateDegrees) {
        sTempMatrix.reset();
        sTempMatrix.setRotate(-rotateDegrees);
        float[] unrotatedWrapperCorner = new float[8];
        float[] unrotateBorderCorner = new float[8];
        sTempMatrix.mapPoints(unrotatedWrapperCorner, piece.getCurrentDrawablePoints());
        sTempMatrix.mapPoints(unrotateBorderCorner, MatrixUtils.getCornersFromRect(piece.getArea().getAreaRect()));
        return MatrixUtils.trapToRect(unrotatedWrapperCorner).contains(MatrixUtils.trapToRect(unrotateBorderCorner));
    }

    static float[] calculateImageIndents(PuzzlePiece piece) {
        if (piece == null) {
            return new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        }
        sTempMatrix.reset();
        sTempMatrix.setRotate(-piece.getMatrixAngle());
        float[] currentImageCorners = piece.getCurrentDrawablePoints();
        float[] unrotatedImageCorners = Arrays.copyOf(currentImageCorners, currentImageCorners.length);
        float[] unrotatedCropBoundsCorners = MatrixUtils.getCornersFromRect(piece.getArea().getAreaRect());
        sTempMatrix.mapPoints(unrotatedImageCorners);
        sTempMatrix.mapPoints(unrotatedCropBoundsCorners);
        RectF unrotatedImageRect = MatrixUtils.trapToRect(unrotatedImageCorners);
        RectF unrotatedCropRect = MatrixUtils.trapToRect(unrotatedCropBoundsCorners);
        float deltaLeft = unrotatedImageRect.left - unrotatedCropRect.left;
        float deltaTop = unrotatedImageRect.top - unrotatedCropRect.top;
        float deltaRight = unrotatedImageRect.right - unrotatedCropRect.right;
        float deltaBottom = unrotatedImageRect.bottom - unrotatedCropRect.bottom;
        float[] indents = new float[]{deltaLeft > 0.0f ? deltaLeft : 0.0f, deltaTop > 0.0f ? deltaTop : 0.0f, deltaRight < 0.0f ? deltaRight : 0.0f, deltaBottom < 0.0f ? deltaBottom : 0.0f};
        sTempMatrix.reset();
        sTempMatrix.setRotate(piece.getMatrixAngle());
        sTempMatrix.mapPoints(indents);
        return indents;
    }

    public static RectF trapToRect(float[] array) {
        RectF r = new RectF(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        for (int i = 1; i < array.length; i += 2) {
            float x = (float)Math.round(array[i - 1] * 10.0f) / 10.0f;
            float y = (float)Math.round(array[i] * 10.0f) / 10.0f;
            r.left = x < r.left ? x : r.left;
            r.top = y < r.top ? y : r.top;
            r.right = x > r.right ? x : r.right;
            r.bottom = y > r.bottom ? y : r.bottom;
        }
        r.sort();
        return r;
    }

    public static float[] getCornersFromRect(RectF r) {
        return new float[]{r.left, r.top, r.right, r.top, r.right, r.bottom, r.left, r.bottom};
    }

    public static Matrix generateMatrix(PuzzlePiece piece, float extra) {
        return MatrixUtils.generateMatrix(piece.getArea(), piece.getDrawable(), extra);
    }

    public static Matrix generateMatrix(Area area, Drawable drawable, float extraSize) {
        return MatrixUtils.generateCenterCropMatrix(area, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), extraSize);
    }

    private static Matrix generateCenterCropMatrix(Area area, int width, int height, float extraSize) {
        RectF rectF = area.getAreaRect();
        Matrix matrix = new Matrix();
        float offsetX = rectF.centerX() - (float)(width / 2);
        float offsetY = rectF.centerY() - (float)(height / 2);
        matrix.postTranslate(offsetX, offsetY);
        float scale = (float)width * rectF.height() > rectF.width() * (float)height ? (rectF.height() + extraSize) / (float)height : (rectF.width() + extraSize) / (float)width;
        matrix.postScale(scale, scale, rectF.centerX(), rectF.centerY());
        return matrix;
    }
}

