/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.utils.bitmap;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import java.util.List;

public class BitmapUtils {
    public static void recycle(Bitmap bitmap) {
        if (null != bitmap && !bitmap.isRecycled()) {
            bitmap.recycle();
            bitmap = null;
        }
        System.gc();
    }

    public static void recycle(Bitmap ... bitmaps) {
        for (Bitmap b : bitmaps) {
            BitmapUtils.recycle(b);
        }
    }

    public static void recycle(List<Bitmap> bitmaps) {
        for (Bitmap b : bitmaps) {
            BitmapUtils.recycle(b);
        }
    }

    public static void addWatermark(Bitmap watermark, Bitmap image, int srcWaterMarkImageWidth, int offsetX, int offsetY, boolean addInLeft) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (0 == imageWidth || 0 == imageHeight) {
            throw new RuntimeException("EasyPhotos: \u52a0\u6c34\u5370\u7684\u539f\u56fe\u5bbd\u6216\u9ad8\u4e0d\u80fd\u4e3a0\uff01");
        }
        int watermarkWidth = watermark.getWidth();
        int watermarkHeight = watermark.getHeight();
        float scale = (float)imageWidth / (float)srcWaterMarkImageWidth;
        if (scale > 1.0f) {
            scale = 1.0f;
        } else if ((double)scale < 0.4) {
            scale = 0.4f;
        }
        int scaleWatermarkWidth = (int)((float)watermarkWidth * scale);
        int scaleWatermarkHeight = (int)((float)watermarkHeight * scale);
        Bitmap scaleWatermark = Bitmap.createScaledBitmap((Bitmap)watermark, (int)scaleWatermarkWidth, (int)scaleWatermarkHeight, (boolean)true);
        Canvas canvas = new Canvas(image);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        if (addInLeft) {
            canvas.drawBitmap(scaleWatermark, (float)offsetX, (float)(imageHeight - scaleWatermarkHeight - offsetY), paint);
        } else {
            canvas.drawBitmap(scaleWatermark, (float)(imageWidth - offsetX - scaleWatermarkWidth), (float)(imageHeight - scaleWatermarkHeight - offsetY), paint);
        }
        BitmapUtils.recycle(scaleWatermark);
    }

    public static void addWatermarkWithText(Bitmap watermark, Bitmap image, int srcWaterMarkImageWidth, @NonNull String text, int offsetX, int offsetY, boolean addInLeft) {
        float imageWidth = image.getWidth();
        float imageHeight = image.getHeight();
        if (0.0f == imageWidth || 0.0f == imageHeight) {
            throw new RuntimeException("EasyPhotos: \u52a0\u6c34\u5370\u7684\u539f\u56fe\u5bbd\u6216\u9ad8\u4e0d\u80fd\u4e3a0\uff01");
        }
        float watermarkWidth = watermark.getWidth();
        float watermarkHeight = watermark.getHeight();
        float scale = imageWidth / (float)srcWaterMarkImageWidth;
        if (scale > 1.0f) {
            scale = 1.0f;
        } else if ((double)scale < 0.4) {
            scale = 0.4f;
        }
        float scaleWatermarkWidth = watermarkWidth * scale;
        float scaleWatermarkHeight = watermarkHeight * scale;
        Bitmap scaleWatermark = Bitmap.createScaledBitmap((Bitmap)watermark, (int)((int)scaleWatermarkWidth), (int)((int)scaleWatermarkHeight), (boolean)true);
        Canvas canvas = new Canvas(image);
        TextPaint textPaint = new TextPaint();
        textPaint.setAntiAlias(true);
        textPaint.setColor(-1);
        float textsize = (float)(scaleWatermark.getHeight() * 2) / 3.0f;
        textPaint.setTextSize(textsize);
        Rect textRect = new Rect();
        textPaint.getTextBounds(text, 0, text.length(), textRect);
        if (addInLeft) {
            canvas.drawText(text, scaleWatermarkWidth + (float)offsetX, imageHeight - (float)textRect.height() - (float)textRect.top - (float)offsetY, (Paint)textPaint);
        } else {
            canvas.drawText(text, imageWidth - (float)offsetX - (float)textRect.width() - (float)textRect.left, imageHeight - (float)textRect.height() - (float)textRect.top - (float)offsetY, (Paint)textPaint);
        }
        Paint sacleWatermarkPaint = new Paint();
        sacleWatermarkPaint.setAntiAlias(true);
        if (addInLeft) {
            canvas.drawBitmap(scaleWatermark, (float)offsetX, imageHeight - (float)textRect.height() - (float)offsetY - scaleWatermarkHeight / 6.0f, sacleWatermarkPaint);
        } else {
            canvas.drawBitmap(scaleWatermark, imageWidth - (float)textRect.width() - (float)offsetX - scaleWatermarkWidth / 6.0f, imageHeight - (float)textRect.height() - (float)offsetY - scaleWatermarkHeight / 6.0f, sacleWatermarkPaint);
        }
        BitmapUtils.recycle(scaleWatermark);
    }
}

