/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.huantansheng.easyphotos.EasyPhotos;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.ad.AdListener;
import com.huantansheng.easyphotos.models.album.AlbumModel;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.PreviewEasyPhotosActivity;
import com.huantansheng.easyphotos.ui.adapter.AlbumItemsAdapter;
import com.huantansheng.easyphotos.ui.adapter.PhotosAdapter;
import com.huantansheng.easyphotos.ui.widget.PressedImageView;
import com.huantansheng.easyphotos.ui.widget.PressedTextView;
import com.huantansheng.easyphotos.utils.media.MediaScannerConnectionUtils;
import com.huantansheng.easyphotos.utils.permission.PermissionUtil;
import com.huantansheng.easyphotos.utils.settings.SettingsUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class EasyPhotosActivity
extends AppCompatActivity
implements AlbumModel.CallBack,
View.OnClickListener,
AlbumItemsAdapter.OnClickListener,
PhotosAdapter.OnClickListener,
AdListener {
    private boolean isShowCamera;
    private boolean onlyStartCamera;
    private String fileProviderText;
    private File mTempImageFile;
    private AlbumModel albumModel;
    private ArrayList<Object> photoList = new ArrayList();
    private ArrayList<Object> albumItemList = new ArrayList();
    private ArrayList<Photo> resultList = new ArrayList();
    private RecyclerView rvPhotos;
    private PhotosAdapter photosAdapter;
    private GridLayoutManager gridLayoutManager;
    private RecyclerView rvAlbumItems;
    private AlbumItemsAdapter albumItemsAdapter;
    private RelativeLayout rootViewAlbumItems;
    private View mBottomBar;
    private PressedTextView tvAlbumItems;
    private PressedTextView tvDone;
    private TextView tvOriginal;
    private AnimatorSet setHide;
    private AnimatorSet setShow;
    private int columns = 3;
    private int albumItemsAdIndex = 0;
    private PressedTextView tvClear;
    private int currAlbumItemIndex = 0;

    public static void start(Activity activity, boolean onlyStartCamera, boolean isShowCamera, String fileProviderText, int requestCode) {
        Intent intent = new Intent((Context)activity, EasyPhotosActivity.class);
        intent.putExtra("keyOfIsShowCamera", isShowCamera);
        intent.putExtra("keyOfFileProviderText", fileProviderText);
        intent.putExtra("keyOfOnlyStartCamera", onlyStartCamera);
        activity.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_easy_photos);
        this.hideActionBar();
        this.initConfig();
        this.mBottomBar = this.findViewById(R.id.m_bottom_bar);
        this.rootViewAlbumItems = (RelativeLayout)this.findViewById(R.id.root_view_album_items);
        if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
            this.hasPermissions();
        }
    }

    private void hasPermissions() {
        if (this.onlyStartCamera) {
            this.launchCamera(11);
            return;
        }
        AlbumModel.clear();
        this.albumModel = AlbumModel.getInstance((Activity)this, this.isShowCamera, this);
    }

    protected String[] getNeedPermissions() {
        if (Build.VERSION.SDK_INT >= 16) {
            return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onPermissionResult((Activity)this, permissions, grantResults, new PermissionUtil.PermissionCallBack(){

            @Override
            public void onSuccess() {
                EasyPhotosActivity.this.hasPermissions();
            }

            @Override
            public void onShouldShow() {
                Snackbar.make((View)EasyPhotosActivity.this.mBottomBar, (int)R.string.permissions_again_easy_photos, (int)-2).setAction((CharSequence)"go", new View.OnClickListener(){

                    public void onClick(View view) {
                        if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)EasyPhotosActivity.this, EasyPhotosActivity.this.getNeedPermissions())) {
                            EasyPhotosActivity.this.hasPermissions();
                        }
                    }
                }).show();
            }

            @Override
            public void onFailed() {
                Snackbar.make((View)EasyPhotosActivity.this.mBottomBar, (int)R.string.permissions_die_easy_photos, (int)-2).setAction((CharSequence)"go", new View.OnClickListener(){

                    public void onClick(View view) {
                        SettingsUtils.startMyApplicationDetailsForResult((Activity)EasyPhotosActivity.this, EasyPhotosActivity.this.getPackageName());
                        EasyPhotosActivity.this.finish();
                    }
                }).show();
            }
        });
    }

    private void initConfig() {
        Intent intent = this.getIntent();
        this.isShowCamera = intent.getBooleanExtra("keyOfIsShowCamera", false);
        this.onlyStartCamera = intent.getBooleanExtra("keyOfOnlyStartCamera", false);
        this.fileProviderText = intent.getStringExtra("keyOfFileProviderText");
    }

    private void launchCamera(int requestCode) {
        if (TextUtils.isEmpty((CharSequence)this.fileProviderText)) {
            throw new RuntimeException("EasyPhotos : \u8bf7\u6267\u884c setFileProviderAuthoritiesText()\u65b9\u6cd5");
        }
        this.toAndroidCamera(requestCode);
    }

    private void toAndroidCamera(int requestCode) {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            this.createCameraTempImageFile();
            if (this.mTempImageFile != null) {
                Uri imageUri = null;
                if (Build.VERSION.SDK_INT >= 24) {
                    imageUri = FileProvider.getUriForFile((Context)this, (String)this.fileProviderText, (File)this.mTempImageFile);
                    cameraIntent.addFlags(1);
                } else {
                    imageUri = Uri.fromFile((File)this.mTempImageFile);
                }
                cameraIntent.putExtra("output", (Parcelable)imageUri);
                this.startActivityForResult(cameraIntent, requestCode);
            } else {
                Toast.makeText((Context)this, (int)R.string.camera_temp_file_error_easy_photos, (int)0).show();
            }
        } else {
            Toast.makeText((Context)this, (int)R.string.msg_no_camera_easy_photos, (int)0).show();
        }
    }

    private void createCameraTempImageFile() {
        String cacheDirPath;
        File dir = new File(Environment.getExternalStorageDirectory(), File.separator + "DCIM" + File.separator + "Camera" + File.separator);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs() || null != (dir = this.getExternalFilesDir(null)) && dir.exists() || null != (dir = this.getFilesDir()) && dir.exists() || (dir = new File(cacheDirPath = File.separator + "data" + File.separator + "data" + File.separator + this.getPackageName() + File.separator + "cache" + File.separator)).exists())) {
            dir.mkdirs();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HH:mm:ss", Locale.getDefault());
        String imageName = "IMG_%s.jpg";
        String filename = String.format(imageName, dateFormat.format(new Date()));
        this.mTempImageFile = new File(dir, filename);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (resultCode) {
            case -1: {
                if (11 == requestCode) {
                    if (this.mTempImageFile == null || !this.mTempImageFile.exists()) {
                        throw new RuntimeException("EasyPhotos\u62cd\u7167\u4fdd\u5b58\u7684\u56fe\u7247\u4e0d\u5b58\u5728");
                    }
                    this.onCameraResult(this.mTempImageFile);
                    return;
                }
                if (13 != requestCode) break;
                if (data.getBooleanExtra("keyOfPreviewClickDone", false)) {
                    this.done();
                    return;
                }
                this.photosAdapter.change();
                this.processOriginalMenu();
                this.shouldShowMenuDone();
                return;
            }
            case 0: {
                if (11 == requestCode) {
                    while (this.mTempImageFile != null && this.mTempImageFile.exists()) {
                        boolean success = this.mTempImageFile.delete();
                        if (!success) continue;
                        this.mTempImageFile = null;
                    }
                    if (this.onlyStartCamera) {
                        this.finish();
                    }
                    return;
                }
                if (13 != requestCode) break;
                this.processOriginalMenu();
                return;
            }
        }
    }

    private void onCameraResult(File imageFile) {
        MediaScannerConnectionUtils.refresh((Context)this, imageFile);
        Intent data = new Intent();
        Bitmap bitmap = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath());
        Photo photo = new Photo(false, imageFile.getName(), imageFile.getAbsolutePath(), imageFile.lastModified(), bitmap.getWidth(), bitmap.getHeight(), imageFile.length(), "image/jpeg");
        this.resultList.add(photo);
        EasyPhotos.recycle(bitmap);
        data.putParcelableArrayListExtra("keyOfEasyPhotosResult", this.resultList);
        this.setResult(-1, data);
        this.finish();
    }

    @Override
    public void onAlbumWorkedCallBack() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EasyPhotosActivity.this.onAlbumWorkedDo();
            }
        });
    }

    private void onAlbumWorkedDo() {
        this.initView();
    }

    private void initView() {
        if (this.albumModel.getAlbumItems().isEmpty()) {
            Toast.makeText((Context)this, (int)R.string.no_photos_easy_photos, (int)0).show();
            if (this.isShowCamera) {
                this.launchCamera(11);
            } else {
                this.finish();
            }
            return;
        }
        EasyPhotos.setAdListener(this);
        if (Setting.hasPhotosAd()) {
            this.findViewById(R.id.m_tool_bar_bottom_line).setVisibility(8);
        }
        this.columns = this.getResources().getInteger(R.integer.photos_columns_easy_photos);
        this.tvAlbumItems = (PressedTextView)this.findViewById(R.id.tv_album_items);
        this.tvAlbumItems.setText(this.albumModel.getAlbumItems().get((int)0).name);
        PressedImageView ivAlbumItems = (PressedImageView)this.findViewById(R.id.iv_album_items);
        PressedImageView ivBack = (PressedImageView)this.findViewById(R.id.iv_back);
        this.tvDone = (PressedTextView)this.findViewById(R.id.tv_done);
        this.tvClear = (PressedTextView)this.findViewById(R.id.tv_clear);
        this.rvPhotos = (RecyclerView)this.findViewById(R.id.rv_photos);
        ((SimpleItemAnimator)this.rvPhotos.getItemAnimator()).setSupportsChangeAnimations(false);
        this.photoList.clear();
        this.photoList.addAll(this.albumModel.getCurrAlbumItemPhotos(0));
        if (Setting.hasPhotosAd()) {
            this.photoList.add(0, Setting.photosAdView);
        }
        this.photosAdapter = new PhotosAdapter((Context)this, this.photoList, this);
        this.gridLayoutManager = new GridLayoutManager((Context)this, this.columns);
        if (Setting.hasPhotosAd()) {
            this.gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (position == 0) {
                        return EasyPhotosActivity.this.gridLayoutManager.getSpanCount();
                    }
                    return 1;
                }
            });
        }
        this.rvPhotos.setLayoutManager((RecyclerView.LayoutManager)this.gridLayoutManager);
        this.rvPhotos.setAdapter((RecyclerView.Adapter)this.photosAdapter);
        this.tvOriginal = (TextView)this.findViewById(R.id.tv_original);
        if (Setting.showOriginalMenu) {
            this.processOriginalMenu();
        } else {
            this.tvOriginal.setVisibility(8);
        }
        this.tvOriginal.setOnClickListener((View.OnClickListener)this);
        this.tvClear.setOnClickListener(this);
        this.tvDone.setOnClickListener(this);
        ivBack.setOnClickListener(this);
        this.mBottomBar.setOnClickListener((View.OnClickListener)this);
        ivAlbumItems.setOnClickListener(this);
        this.tvAlbumItems.setOnClickListener(this);
        this.initAlbumItems();
        this.shouldShowMenuDone();
    }

    private void hideActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    private void initAlbumItems() {
        this.rootViewAlbumItems.setOnClickListener((View.OnClickListener)this);
        this.rvAlbumItems = (RecyclerView)this.findViewById(R.id.rv_album_items);
        this.albumItemList.clear();
        this.albumItemList.addAll(this.albumModel.getAlbumItems());
        if (Setting.hasAlbumItemsAd()) {
            this.albumItemsAdIndex = 2;
            if (this.albumItemList.size() < this.albumItemsAdIndex + 1) {
                this.albumItemsAdIndex = this.albumItemList.size() - 1;
            }
            this.albumItemList.add(this.albumItemsAdIndex, Setting.albumItemsAdView);
        }
        this.albumItemsAdapter = new AlbumItemsAdapter((Context)this, this.albumItemList, 0, this);
        this.rvAlbumItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.rvAlbumItems.setAdapter((RecyclerView.Adapter)this.albumItemsAdapter);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (R.id.tv_album_items == id2 || R.id.iv_album_items == id2) {
            this.showAlbumItems(8 == this.rootViewAlbumItems.getVisibility());
        } else if (R.id.root_view_album_items == id2) {
            this.showAlbumItems(false);
        } else if (R.id.iv_back == id2) {
            this.setResult(0);
            this.finish();
        } else if (R.id.tv_done == id2) {
            this.done();
        } else if (R.id.tv_clear == id2) {
            Result.removeAll();
            this.photosAdapter.change();
            this.shouldShowMenuDone();
        } else if (R.id.tv_original == id2) {
            if (!Setting.originalMenuUsable) {
                Toast.makeText((Context)this, (CharSequence)Setting.originalMenuUnusableHint, (int)0).show();
                return;
            }
            Setting.selectedOriginal = !Setting.selectedOriginal;
            this.processOriginalMenu();
        }
    }

    private void done() {
        Intent intent = new Intent();
        Result.processOriginal();
        this.resultList.addAll(Result.photos);
        intent.putParcelableArrayListExtra("keyOfEasyPhotosResult", this.resultList);
        ArrayList<String> resultPaths = new ArrayList<String>();
        for (Photo photo : this.resultList) {
            resultPaths.add(photo.path);
        }
        intent.putStringArrayListExtra("keyOfEasyPhotosResultPaths", resultPaths);
        intent.putExtra("keyOfEasyPhotosResultSelectedOriginal", Setting.selectedOriginal);
        this.setResult(-1, intent);
        this.finish();
    }

    private void processOriginalMenu() {
        if (Setting.selectedOriginal) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.menu_easy_photos));
        } else {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.text_easy_photos));
        }
    }

    private void showAlbumItems(boolean isShow) {
        if (null == this.setShow) {
            this.newAnimators();
        }
        if (isShow) {
            this.rootViewAlbumItems.setVisibility(0);
            this.setShow.start();
        } else {
            this.setHide.start();
        }
    }

    private void newAnimators() {
        this.newHideAnim();
        this.newShowAnim();
    }

    private void newShowAnim() {
        ObjectAnimator translationShow = ObjectAnimator.ofFloat((Object)this.rvAlbumItems, (String)"translationY", (float[])new float[]{(float)this.mBottomBar.getTop() - this.rvAlbumItems.getY(), this.rvAlbumItems.getY()});
        ObjectAnimator alphaShow = ObjectAnimator.ofFloat((Object)this.rootViewAlbumItems, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        translationShow.setDuration(300L);
        this.setShow = new AnimatorSet();
        this.setShow.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.setShow.play((Animator)translationShow).with((Animator)alphaShow);
    }

    private void newHideAnim() {
        ObjectAnimator translationHide = ObjectAnimator.ofFloat((Object)this.rvAlbumItems, (String)"translationY", (float[])new float[]{this.rvAlbumItems.getY(), (float)this.mBottomBar.getTop() - this.rvAlbumItems.getY()});
        ObjectAnimator alphaHide = ObjectAnimator.ofFloat((Object)this.rootViewAlbumItems, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        translationHide.setDuration(200L);
        this.setHide = new AnimatorSet();
        this.setHide.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                EasyPhotosActivity.this.rootViewAlbumItems.setVisibility(8);
            }
        });
        this.setHide.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.setHide.play((Animator)translationHide).with((Animator)alphaHide);
    }

    @Override
    public void onAlbumItemClick(int position, int realPosition) {
        this.updatePhotos(realPosition);
        this.showAlbumItems(false);
        this.tvAlbumItems.setText(this.albumModel.getAlbumItems().get((int)realPosition).name);
    }

    private void updatePhotos(int currAlbumItemIndex) {
        this.currAlbumItemIndex = currAlbumItemIndex;
        this.photoList.clear();
        this.photoList.addAll(this.albumModel.getCurrAlbumItemPhotos(currAlbumItemIndex));
        if (Setting.hasPhotosAd()) {
            this.photoList.add(0, Setting.photosAdView);
        }
        this.photosAdapter.change();
        this.rvPhotos.scrollToPosition(0);
    }

    private void shouldShowMenuDone() {
        if (Result.isEmpty()) {
            if (0 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleHide = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f);
                scaleHide.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleHide);
            }
            this.tvDone.setVisibility(8);
            this.tvClear.setVisibility(8);
        } else {
            if (8 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleShow = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f);
                scaleShow.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleShow);
            }
            this.tvDone.setVisibility(0);
            if (Setting.count > 1) {
                this.tvClear.setVisibility(0);
            }
        }
        this.tvDone.setText(this.getString(R.string.selector_action_done_easy_photos, new Object[]{Result.count(), Setting.count}));
    }

    @Override
    public void onPhotoClick(int position, int realPosition) {
        PreviewEasyPhotosActivity.start((Activity)this, this.currAlbumItemIndex, realPosition);
    }

    @Override
    public void onSelectorOutOfMax() {
        Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint_easy_photos, new Object[]{Setting.count}), (int)0).show();
    }

    @Override
    public void onSelectorChanged() {
        this.shouldShowMenuDone();
    }

    @Override
    public void onCameraClicked() {
        this.launchCamera(11);
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onBackPressed() {
        if (this.rootViewAlbumItems.getVisibility() == 0) {
            this.showAlbumItems(false);
            return;
        }
        super.onBackPressed();
    }

    @Override
    public void onPhotosAdLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EasyPhotosActivity.this.photosAdapter.change();
            }
        });
    }

    @Override
    public void onAlbumItemsAdLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EasyPhotosActivity.this.albumItemsAdapter.notifyDataSetChanged();
            }
        });
    }
}

