/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.PagerSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.AlbumModel;
import com.huantansheng.easyphotos.models.album.entity.PhotoItem;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.adapter.PreviewPhotosAdapter;
import com.huantansheng.easyphotos.ui.widget.PressedImageView;
import com.huantansheng.easyphotos.ui.widget.PressedTextView;
import java.util.ArrayList;

public class PreviewEasyPhotosActivity
extends AppCompatActivity
implements PreviewPhotosAdapter.OnClickListener,
View.OnClickListener {
    private static final int UI_ANIMATION_DELAY = 300;
    private final Handler mHideHandler = new Handler();
    private final Runnable mHidePart2Runnable = new Runnable(){

        @Override
        public void run() {
            if (Build.VERSION.SDK_INT >= 19) {
                PreviewEasyPhotosActivity.this.rvPhotos.setSystemUiVisibility(4871);
            } else if (Build.VERSION.SDK_INT >= 16) {
                PreviewEasyPhotosActivity.this.rvPhotos.setSystemUiVisibility(775);
            } else {
                PreviewEasyPhotosActivity.this.rvPhotos.setSystemUiVisibility(3);
            }
        }
    };
    private RelativeLayout mBottomBar;
    private final Runnable mShowPart2Runnable = new Runnable(){

        @Override
        public void run() {
            PreviewEasyPhotosActivity.this.mBottomBar.setVisibility(0);
        }
    };
    private boolean mVisible;
    private PressedImageView ivBack;
    private PressedTextView tvEdit;
    private TextView tvSelector;
    private ImageView ivSelector;
    private RecyclerView rvPhotos;
    private PreviewPhotosAdapter adapter;
    private PagerSnapHelper snapHelper;
    private LinearLayoutManager lm;
    private int index;
    private ArrayList<PhotoItem> photos = new ArrayList();
    private int resultCode = 0;
    private int lastPosition = 0;
    private boolean isSingle = Setting.count == 1;
    private boolean unable = Result.count() == Setting.count;

    public static void start(Activity act, int albumItemIndex, int currIndex) {
        Intent intent = new Intent((Context)act, PreviewEasyPhotosActivity.class);
        intent.putExtra("keyOfPreviewAlbumItemIndex", albumItemIndex);
        intent.putExtra("keyOfPreviewPhotoIndex", currIndex);
        act.startActivityForResult(intent, 13);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_preview_easy_photos);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
        this.initData();
        this.initView();
    }

    private void initData() {
        Intent intent = this.getIntent();
        int albumItemIndex = intent.getIntExtra("keyOfPreviewAlbumItemIndex", 0);
        this.photos.clear();
        this.photos.addAll(AlbumModel.instance.getCurrAlbumItemPhotos(albumItemIndex));
        this.index = intent.getIntExtra("keyOfPreviewPhotoIndex", 0);
        if (this.photos.get((int)0).isCamera) {
            this.photos.remove(0);
            --this.index;
        }
        this.lastPosition = this.index;
        this.mVisible = true;
    }

    private void toggle() {
        if (this.mVisible) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void hide() {
        AlphaAnimation hideAnimation = new AlphaAnimation(1.0f, 0.0f);
        hideAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PreviewEasyPhotosActivity.this.mBottomBar.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        hideAnimation.setDuration(300L);
        this.mBottomBar.startAnimation((Animation)hideAnimation);
        this.mVisible = false;
        this.mHideHandler.removeCallbacks(this.mShowPart2Runnable);
        this.mHideHandler.postDelayed(this.mHidePart2Runnable, 300L);
    }

    private void show() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.rvPhotos.setSystemUiVisibility(1536);
        }
        this.mVisible = true;
        this.mHideHandler.removeCallbacks(this.mHidePart2Runnable);
        this.mHideHandler.postDelayed(this.mShowPart2Runnable, 300L);
    }

    @Override
    public void onPhotoClick() {
        this.toggle();
    }

    @Override
    public void onPhotoScaleChanged() {
        if (this.mVisible) {
            this.hide();
        }
    }

    public void onBackPressed() {
        this.doBack();
    }

    private void doBack() {
        this.setResult(this.resultCode);
        this.finish();
    }

    private void initView() {
        this.tvEdit = (PressedTextView)this.findViewById(R.id.tv_edit);
        this.mBottomBar = (RelativeLayout)this.findViewById(R.id.m_bottom_bar);
        this.ivBack = (PressedImageView)this.findViewById(R.id.iv_back);
        this.tvSelector = (TextView)this.findViewById(R.id.tv_selector);
        this.ivSelector = (ImageView)this.findViewById(R.id.iv_selector);
        this.mBottomBar.setOnClickListener((View.OnClickListener)this);
        this.ivBack.setOnClickListener(this);
        this.tvSelector.setOnClickListener((View.OnClickListener)this);
        this.ivSelector.setOnClickListener((View.OnClickListener)this);
        this.tvEdit.setOnClickListener(this);
        this.initRecyclerView();
    }

    private void initRecyclerView() {
        this.rvPhotos = (RecyclerView)this.findViewById(R.id.rv_photos);
        this.rvPhotos.post(new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT >= 16) {
                    PreviewEasyPhotosActivity.this.rvPhotos.setSystemUiVisibility(512);
                }
            }
        });
        this.adapter = new PreviewPhotosAdapter((Context)this, this.photos, this);
        this.lm = new LinearLayoutManager((Context)this, 0, false);
        this.rvPhotos.setLayoutManager((RecyclerView.LayoutManager)this.lm);
        this.rvPhotos.setAdapter((RecyclerView.Adapter)this.adapter);
        this.rvPhotos.scrollToPosition(this.index);
        this.toggleSelector();
        this.snapHelper = new PagerSnapHelper();
        this.snapHelper.attachToRecyclerView(this.rvPhotos);
        this.rvPhotos.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                int rightViewPosition;
                super.onScrollStateChanged(recyclerView, newState);
                if (newState != 0) {
                    return;
                }
                int leftViewPosition = PreviewEasyPhotosActivity.this.snapHelper.findTargetSnapPosition((RecyclerView.LayoutManager)PreviewEasyPhotosActivity.this.lm, 1, PreviewEasyPhotosActivity.this.rvPhotos.getHeight() / 2);
                if (leftViewPosition == (rightViewPosition = PreviewEasyPhotosActivity.this.snapHelper.findTargetSnapPosition((RecyclerView.LayoutManager)PreviewEasyPhotosActivity.this.lm, PreviewEasyPhotosActivity.this.rvPhotos.getWidth() - 1, PreviewEasyPhotosActivity.this.rvPhotos.getHeight() / 2))) {
                    if (PreviewEasyPhotosActivity.this.lastPosition == leftViewPosition - 1) {
                        return;
                    }
                    PreviewEasyPhotosActivity.this.lastPosition = leftViewPosition - 1;
                    View view = PreviewEasyPhotosActivity.this.snapHelper.findSnapView((RecyclerView.LayoutManager)PreviewEasyPhotosActivity.this.lm);
                    PreviewEasyPhotosActivity.this.toggleSelector();
                    if (null == view) {
                        return;
                    }
                    PreviewPhotosAdapter.PreviewPhotosViewHolder viewHolder = (PreviewPhotosAdapter.PreviewPhotosViewHolder)PreviewEasyPhotosActivity.this.rvPhotos.getChildViewHolder(view);
                    if (viewHolder == null || viewHolder.ivPhoto == null) {
                        return;
                    }
                    if (viewHolder.ivPhoto.getScale() != 1.0f) {
                        viewHolder.ivPhoto.setScale(1.0f, true);
                    }
                }
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (R.id.iv_back == id2) {
            this.doBack();
        } else if (R.id.tv_selector == id2) {
            this.updateSelector();
        } else if (R.id.iv_selector == id2) {
            this.updateSelector();
        }
    }

    private void toggleSelector() {
        if (this.photos.get((int)this.lastPosition).selected) {
            this.ivSelector.setImageResource(R.drawable.ic_selector_true);
        } else {
            this.ivSelector.setImageResource(R.drawable.ic_selector);
        }
    }

    private void updateSelector() {
        this.resultCode = -1;
        PhotoItem item = this.photos.get(this.lastPosition);
        if (this.isSingle) {
            this.singleSelector(item);
            return;
        }
        if (this.unable) {
            if (item.selected) {
                Result.removePhoto(item);
                if (this.unable) {
                    this.unable = false;
                }
                return;
            }
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint_easy_photos, new Object[]{Setting.count}), (int)0).show();
            return;
        }
        boolean bl = item.selected = !item.selected;
        if (item.selected) {
            Result.addPhoto(item);
            if (Result.count() == Setting.count) {
                this.unable = true;
            }
        } else {
            Result.removePhoto(item);
            if (this.unable) {
                this.unable = false;
            }
        }
        this.toggleSelector();
    }

    private void singleSelector(PhotoItem photoItem) {
        if (!Result.isEmpty()) {
            if (Result.getPhotoPath(0).equals(photoItem.path)) {
                Result.removePhoto(photoItem);
                this.toggleSelector();
            } else {
                Result.removePhoto(0);
                Result.addPhoto(photoItem);
                this.toggleSelector();
            }
        } else {
            Result.addPhoto(photoItem);
            this.toggleSelector();
        }
    }
}

