/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.album;

import android.app.Activity;
import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.util.Log;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Album;
import com.huantansheng.easyphotos.models.album.entity.AlbumItem;
import com.huantansheng.easyphotos.models.album.entity.PhotoItem;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.utils.String.StringUtils;
import java.io.File;
import java.util.ArrayList;

public class AlbumModel {
    public static AlbumModel instance;
    private static final String TAG = "AlbumModel";
    private Album album = new Album();
    private CallBack callBack;

    private AlbumModel(Activity act, boolean isShowCamera, CallBack callBack) {
        this.callBack = callBack;
        this.init(act, isShowCamera);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlbumModel getInstance(Activity act, boolean isShowCamera, CallBack callBack) {
        if (null != instance) return instance;
        Class<AlbumModel> clazz = AlbumModel.class;
        synchronized (AlbumModel.class) {
            if (null != instance) return instance;
            instance = new AlbumModel(act, isShowCamera, callBack);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public static void clear() {
        instance = null;
    }

    private void init(final Activity act, final boolean isShowCamera) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AlbumModel.this.initAlbum(act, isShowCamera);
                AlbumModel.this.callBack.onAlbumWorkedCallBack();
            }
        }).start();
    }

    private void initAlbum(Activity act, boolean isShowCamera) {
        Uri contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        String sortOrder = "date_added DESC";
        ContentResolver contentResolver = act.getContentResolver();
        String[] projections = null;
        projections = Build.VERSION.SDK_INT >= 16 ? new String[]{"_data", "_display_name", "date_added", "mime_type", "width", "height"} : new String[]{"_data", "_display_name", "date_added", "mime_type"};
        Cursor cursor = contentResolver.query(contentUri, projections, null, null, sortOrder);
        if (cursor == null) {
            Log.d((String)TAG, (String)"call: Empty photos");
        } else if (cursor.moveToFirst()) {
            String albumItem_all_name = act.getString(R.string.selector_folder_all_easy_photos);
            int pathCol = cursor.getColumnIndex("_data");
            int nameCol = cursor.getColumnIndex("_display_name");
            int DateCol = cursor.getColumnIndex("date_added");
            int mimeType = cursor.getColumnIndex("mime_type");
            int WidthCol = 0;
            int HeightCol = 0;
            if (Build.VERSION.SDK_INT >= 16) {
                WidthCol = cursor.getColumnIndex("width");
                HeightCol = cursor.getColumnIndex("height");
            }
            do {
                String path = cursor.getString(pathCol);
                String name = cursor.getString(nameCol);
                long dateTime = cursor.getLong(DateCol);
                String type = cursor.getString(mimeType);
                int width = 0;
                int height = 0;
                if (Build.VERSION.SDK_INT >= 16) {
                    width = cursor.getInt(WidthCol);
                    height = cursor.getInt(HeightCol);
                    if (width < Setting.minWidth && height < Setting.minHeight) continue;
                }
                PhotoItem imageItem = new PhotoItem(false, name, path, dateTime, width, height, type);
                if (!Result.isEmpty()) {
                    for (String photoPath : Result.photos) {
                        if (!path.equals(photoPath)) continue;
                        imageItem.selected = true;
                        Result.map.put(path, imageItem);
                    }
                }
                if (this.album.isEmpty()) {
                    this.album.addAlbumItem(albumItem_all_name, "", path);
                    if (isShowCamera) {
                        PhotoItem cameraItem = new PhotoItem(true, "", "/CAMERA/CAMERA", 0L, 0, 0, "");
                        this.album.getAlbumItem(albumItem_all_name).addImageItem(cameraItem);
                    }
                }
                this.album.getAlbumItem(albumItem_all_name).addImageItem(imageItem);
                String folderPath = new File(path).getParentFile().getAbsolutePath();
                String albumName = StringUtils.getLastPathSegment(folderPath);
                this.album.addAlbumItem(albumName, folderPath, path);
                this.album.getAlbumItem(albumName).addImageItem(imageItem);
            } while (cursor.moveToNext());
            cursor.close();
        }
    }

    public ArrayList<PhotoItem> getCurrAlbumItemPhotos(int currAlbumItemIndex) {
        return this.album.getAlbumItem((int)currAlbumItemIndex).photos;
    }

    public ArrayList<AlbumItem> getAlbumItems() {
        return this.album.albumItems;
    }

    public static interface CallBack {
        public void onAlbumWorkedCallBack();
    }
}

