/*
 * Decompiled with CFR 0.152.
 */
package com.example.item.weight;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.example.item.R;
import com.example.item.util.ScreenUtils;

public class ItemView
extends RelativeLayout {
    public TextView mTvLeft;
    public TextView mTvRight;
    private ViewGroup mRootView;
    public View mTopLine;
    public View mBottomLine;

    public ItemView(Context context) {
        super(context);
    }

    public ItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
        this.initAttrs(attrs);
    }

    private void initView() {
        View viewInflate = View.inflate((Context)this.getContext(), (int)R.layout.view_item, (ViewGroup)this);
        this.mRootView = (ViewGroup)viewInflate.findViewById(R.id.root_view);
        this.mTvLeft = (TextView)viewInflate.findViewById(R.id.tv_left);
        this.mTvRight = (TextView)viewInflate.findViewById(R.id.tv_right);
        this.mTopLine = viewInflate.findViewById(R.id.top_line);
        this.mBottomLine = viewInflate.findViewById(R.id.bottom_line);
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ItemView);
        if (typedArray != null && typedArray.getIndexCount() > 0) {
            this.mTvLeft.setCompoundDrawablesWithIntrinsicBounds(typedArray.getDrawable(R.styleable.ItemView_title_left_icon), typedArray.getDrawable(R.styleable.ItemView_title_top_icon), typedArray.getDrawable(R.styleable.ItemView_title_right_icon), typedArray.getDrawable(R.styleable.ItemView_title_bottom_icon));
            this.mTvLeft.setText((CharSequence)typedArray.getString(R.styleable.ItemView_title_data));
            this.mTvLeft.setTextSize(0, (float)typedArray.getDimensionPixelSize(R.styleable.ItemView_title_text_size, (int)this.mTvLeft.getTextSize()));
            this.mTvLeft.setTextColor(typedArray.getColor(R.styleable.ItemView_title_text_color, this.mTvLeft.getPaint().getColor()));
            this.mTvLeft.setCompoundDrawablePadding(typedArray.getDimensionPixelSize(R.styleable.ItemView_title_drawable_padding, 0));
            this.mTopLine.setVisibility(typedArray.getBoolean(R.styleable.ItemView_show_top_line, false) ? 0 : 8);
            this.mTopLine.setBackgroundColor(typedArray.getColor(R.styleable.ItemView_top_line_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorFFEFEFEF)));
            this.setLineHeight(this.mTopLine, typedArray.getDimensionPixelSize(R.styleable.ItemView_top_line_height, ScreenUtils.dp2px(this.getContext(), 0.5f)));
            this.setMargin(this.mTopLine, typedArray.getDimensionPixelSize(R.styleable.ItemView_top_line_margin_left, 0), typedArray.getDimensionPixelSize(R.styleable.ItemView_top_line_margin_top, 0), typedArray.getDimensionPixelSize(R.styleable.ItemView_top_line_margin_right, 0), typedArray.getDimensionPixelSize(R.styleable.ItemView_top_line_margin_bottom, 0));
            this.mTvRight.setCompoundDrawablesWithIntrinsicBounds(typedArray.getDrawable(R.styleable.ItemView_content_left_icon), typedArray.getDrawable(R.styleable.ItemView_content_top_icon), typedArray.getDrawable(R.styleable.ItemView_content_right_icon), typedArray.getDrawable(R.styleable.ItemView_content_bottom_icon));
            this.mTvRight.setText((CharSequence)typedArray.getString(R.styleable.ItemView_content_data));
            this.mTvRight.setTextSize(0, (float)typedArray.getDimensionPixelSize(R.styleable.ItemView_content_text_size, (int)this.mTvRight.getTextSize()));
            this.mTvRight.setTextColor(typedArray.getColor(R.styleable.ItemView_content_text_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorFF333333)));
            this.mTvRight.setCompoundDrawablePadding(typedArray.getDimensionPixelSize(R.styleable.ItemView_content_drawable_padding, 0));
            if (typedArray.getDrawable(R.styleable.ItemView_selector_drawable) != null) {
                this.mRootView.setBackgroundDrawable(typedArray.getDrawable(R.styleable.ItemView_selector_drawable));
            }
            this.setMargin(this.mBottomLine, typedArray.getDimensionPixelSize(R.styleable.ItemView_bottom_line_margin_left, 0), typedArray.getDimensionPixelSize(R.styleable.ItemView_bottom_line_margin_top, 0), typedArray.getDimensionPixelSize(R.styleable.ItemView_bottom_line_margin_right, 0), typedArray.getDimensionPixelSize(R.styleable.ItemView_bottom_line_margin_bottom, 0));
            this.mBottomLine.setVisibility(typedArray.getBoolean(R.styleable.ItemView_show_bottom_line, false) ? 0 : 8);
            this.setLineHeight(this.mBottomLine, typedArray.getDimensionPixelSize(R.styleable.ItemView_bottom_line_height, ScreenUtils.dp2px(this.getContext(), 0.5f)));
            this.mBottomLine.setBackgroundColor(typedArray.getColor(R.styleable.ItemView_bottom_line_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorFFEFEFEF)));
            typedArray.recycle();
        }
    }

    private void setLineHeight(@NonNull View line, int lineHeight) {
        ViewGroup.LayoutParams lineParams = line.getLayoutParams();
        lineParams.width = -1;
        lineParams.height = lineHeight;
        line.setLayoutParams(lineParams);
    }

    private void setMargin(@NonNull View view, int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
        layoutParams.leftMargin = leftMargin;
        layoutParams.topMargin = topMargin;
        layoutParams.rightMargin = rightMargin;
        layoutParams.bottomMargin = bottomMargin;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setTitleText(@NonNull String text) {
        this.mTvLeft.setText((CharSequence)text);
    }

    public void setTitleText(@StringRes int resString) {
        this.mTvLeft.setText(resString);
    }

    public void setContentText(@NonNull String text) {
        this.mTvRight.setText((CharSequence)text);
    }

    public void setContentText(@StringRes int resString) {
        this.mTvRight.setText(resString);
    }

    public void setTitleIcon(@DrawableRes int leftDrawableRes, @DrawableRes int topDrawableRes, @DrawableRes int rightDrawableRes, @DrawableRes int bottomDrawableRes) {
        this.mTvLeft.setCompoundDrawablesWithIntrinsicBounds(leftDrawableRes, topDrawableRes, rightDrawableRes, bottomDrawableRes);
    }

    public void setTitleIcon(@Nullable Drawable leftDrawable, @Nullable Drawable topDrawable, @Nullable Drawable rightDrawable, @Nullable Drawable bottomDrawable) {
        this.mTvLeft.setCompoundDrawablesWithIntrinsicBounds(leftDrawable, topDrawable, rightDrawable, bottomDrawable);
    }

    public void setContentIcon(@DrawableRes int leftDrawableRes, @DrawableRes int topDrawableRes, @DrawableRes int rightDrawableRes, @DrawableRes int bottomDrawableRes) {
        this.mTvRight.setCompoundDrawablesWithIntrinsicBounds(leftDrawableRes, topDrawableRes, rightDrawableRes, bottomDrawableRes);
    }

    public void setContentIcon(@Nullable Drawable leftDrawable, @Nullable Drawable topDrawable, @Nullable Drawable rightDrawable, @Nullable Drawable bottomDrawable) {
        this.mTvRight.setCompoundDrawablesWithIntrinsicBounds(leftDrawable, topDrawable, rightDrawable, bottomDrawable);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measureHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int measureHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int resultHeight = ScreenUtils.dp2px(this.getContext(), 45.0f);
        switch (measureHeightMode) {
            case 0: {
                ScreenUtils.dp2px(this.getContext(), 45.0f);
                ScreenUtils.setDefaultRootViewSize(this.getContext(), this.mRootView);
                break;
            }
            case -2147483648: {
                ScreenUtils.dp2px(this.getContext(), 45.0f);
                ScreenUtils.setDefaultRootViewSize(this.getContext(), this.mRootView);
                break;
            }
            case 0x40000000: {
                resultHeight = measureHeightSize;
                break;
            }
        }
        this.setMeasuredDimension(ScreenUtils.screenWidth(this.getContext()), resultHeight);
    }
}

