/*
 * Decompiled with CFR 0.152.
 */
package utils.task;

import android.app.Activity;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import utils.CompressPicker;
import utils.FileUtils;
import utils.LogUtils;
import utils.bean.ImageConfig;

public class CompressImageTask {
    private boolean mIsCompressing;
    private ExecutorService mThreadService = Executors.newCachedThreadPool();
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private static final int BITMAP_WHAT = 100;
    private static final int IMAGE_WAHT = 200;
    private static final int IMAGES_WHAT = 300;
    private static CompressImageTask mTask = null;

    public boolean isCompressImage() {
        return this.mIsCompressing;
    }

    private CompressImageTask() {
        LogUtils.w("CompressImageTask--", "\u6211\u88ab\u521b\u5efa\u4e86------" + CompressImageTask.class.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CompressImageTask get() {
        Class<CompressImageTask> clazz = CompressImageTask.class;
        synchronized (CompressImageTask.class) {
            if (mTask != null) return mTask;
            Class<CompressImageTask> clazz2 = CompressImageTask.class;
            synchronized (CompressImageTask.class) {
                mTask = new CompressImageTask();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mTask;
            }
        }
    }

    public void compressBitmap(final Activity activity, final @NonNull ImageConfig imageConfig, final @NonNull OnBitmapResult onBitmapResult) {
        if (activity == null) {
            return;
        }
        this.mIsCompressing = true;
        onBitmapResult.startCompress();
        this.mThreadService.execute(new Runnable(){

            @Override
            public void run() {
                final Bitmap bitmap = CompressPicker.compressBitmap(imageConfig);
                CompressImageTask.this.mIsCompressing = false;
                if (!activity.isFinishing()) {
                    CompressImageTask.this.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (bitmap != null && bitmap.getHeight() > 0 && bitmap.getWidth() > 0) {
                                onBitmapResult.resultBitmapSucceed(bitmap);
                            } else {
                                onBitmapResult.resultBitmapError();
                            }
                        }
                    });
                }
            }
        });
    }

    public void compressImage(final Activity activity, final @NonNull ImageConfig imageConfig, final @NonNull OnImageResult onImageResult) {
        Log.w((String)"subscribe---", (String)(Thread.currentThread().getName() + "--" + this.mThreadService.isShutdown()));
        if (activity == null) {
            return;
        }
        this.mIsCompressing = true;
        onImageResult.startCompress();
        this.mThreadService.execute(new Runnable(){

            @Override
            public void run() {
                final File file = CompressPicker.bitmapToFile(CompressPicker.compressBitmap(imageConfig));
                CompressImageTask.this.mIsCompressing = false;
                if (!activity.isFinishing()) {
                    CompressImageTask.this.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (FileUtils.isImageFile(file)) {
                                onImageResult.resultFileSucceed(file);
                            } else {
                                onImageResult.resultFileError();
                            }
                        }
                    });
                }
            }
        });
    }

    public void compressImages(final Activity activity, final @NonNull List<ImageConfig> list, final @NonNull OnImagesResult onImageListResult) {
        if (list.size() == 0 || activity == null || activity.isFinishing()) {
            return;
        }
        Log.w((String)"subscribe--", (String)(Thread.currentThread().getName() + "--" + this.mThreadService.isTerminated() + "--" + this.mThreadService.isShutdown()));
        this.mIsCompressing = true;
        onImageListResult.startCompress();
        final ArrayList fileList = new ArrayList();
        this.mThreadService.execute(new Runnable(){

            @Override
            public void run() {
                for (ImageConfig imageConfig : list) {
                    File file = CompressPicker.bitmapToFile(CompressPicker.compressBitmap(imageConfig));
                    fileList.add(file);
                }
                CompressImageTask.this.mIsCompressing = false;
                if (!activity.isFinishing()) {
                    CompressImageTask.this.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (fileList.size() > 0) {
                                onImageListResult.resultFilesSucceed(fileList);
                            } else {
                                onImageListResult.resultFilesError();
                            }
                        }
                    });
                }
            }
        });
    }

    public void deathCompress() {
    }

    public static interface OnBitmapResult {
        public void startCompress();

        public void resultBitmapSucceed(Bitmap var1);

        public void resultBitmapError();
    }

    public static interface OnImageResult {
        public void startCompress();

        public void resultFileSucceed(File var1);

        public void resultFileError();
    }

    public static interface OnImagesResult {
        public void startCompress();

        public void resultFilesSucceed(List<File> var1);

        public void resultFilesError();
    }
}

