/*
 * Decompiled with CFR 0.152.
 */
package utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.List;
import utils.MediaScanner;
import utils.UiUtils;

public class FileUtils {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final double ONE_KB = 1024.0;
    public static final String FILE_DIRECTOR_NAME = "HuXiaobai/cache";
    private static final String FILE_DIRECTOR_HEAD_NAME = "HuXiaobai";

    public static File outFileDirectory() {
        String storageState = Environment.getExternalStorageState();
        File rootFile = storageState.equals("mounted") ? Environment.getExternalStorageDirectory() : UiUtils.getContext().getCacheDir();
        if (!(rootFile = new File(rootFile.getAbsolutePath(), FILE_DIRECTOR_NAME)).exists() || !rootFile.isDirectory()) {
            rootFile.mkdirs();
        }
        return rootFile;
    }

    public static File outFileDirectory(String directorName) {
        String storageState = Environment.getExternalStorageState();
        File rootFile = storageState.equals("mounted") ? Environment.getExternalStorageDirectory() : UiUtils.getContext().getCacheDir();
        if (!(rootFile = new File(rootFile.getAbsolutePath(), directorName)).exists() || !rootFile.isDirectory()) {
            rootFile.mkdirs();
        }
        return rootFile;
    }

    public static File resultImageFile() {
        return new File(FileUtils.outFileDirectory().getAbsolutePath(), "hxb" + System.currentTimeMillis() + ".jpg");
    }

    public static File getFileDirectorHead(Context context) {
        String storageState = Environment.getExternalStorageState();
        File rootFile = storageState.equals("mounted") ? Environment.getExternalStorageDirectory() : context.getCacheDir();
        return new File(rootFile, FILE_DIRECTOR_HEAD_NAME);
    }

    public static File from(Context context, Uri uri) throws IOException {
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        String fileName = FileUtils.getFileName(context, uri);
        String[] splitName = FileUtils.splitFileName(fileName);
        File tempFile = File.createTempFile(splitName[0], splitName[1]);
        tempFile = FileUtils.rename(tempFile, fileName);
        tempFile.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (inputStream != null) {
            FileUtils.copy(inputStream, out);
            inputStream.close();
        }
        if (out != null) {
            out.close();
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileName(Context context, Uri uri) {
        int cut;
        String result = null;
        if (uri.getScheme().equals("content")) {
            try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);){
                if (cursor != null && cursor.moveToFirst()) {
                    result = cursor.getString(cursor.getColumnIndex("_display_name"));
                }
            }
        }
        if (result == null && (cut = (result = uri.getPath()).lastIndexOf(File.separator)) != -1) {
            result = result.substring(cut + 1);
        }
        return result;
    }

    private static String[] splitFileName(String fileName) {
        String name = fileName;
        String extension = "";
        int i = fileName.lastIndexOf(".");
        if (i != -1) {
            name = fileName.substring(0, i);
            extension = fileName.substring(i);
        }
        return new String[]{name, extension};
    }

    private static File rename(File file, String newName) {
        File newFile = new File(file.getParent(), newName);
        if (!newFile.equals(file)) {
            if (newFile.exists() && newFile.delete()) {
                Log.d((String)"FileUtil", (String)("Delete old " + newName + " file"));
            }
            if (file.renameTo(newFile)) {
                Log.d((String)"FileUtil", (String)("Rename file to " + newName));
            }
        }
        return newFile;
    }

    private static long copy(InputStream input, OutputStream output) throws IOException {
        int n;
        long count = 0L;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static boolean isImageFile(File file) {
        String imagePath;
        return file != null && file.exists() && file.isFile() && ((imagePath = file.getAbsolutePath()).endsWith(".jpg") || imagePath.endsWith(".jpeg") || imagePath.endsWith(".png") || imagePath.endsWith(".bmp") || imagePath.endsWith(".webp"));
    }

    public static String imageSize(long fileSize) {
        DecimalFormat df = new DecimalFormat(".##");
        if ((double)fileSize * 1.0 / 1024.0 < 1.0) {
            return df.format(fileSize) + "B";
        }
        if ((double)fileSize * 1.0 / 1024.0 >= 1.0 && (double)fileSize * 1.0 / 1024.0 < 1024.0) {
            return df.format((double)fileSize * 1.0 / 1024.0) + "KB";
        }
        return df.format((double)fileSize * 1.0 / 1024.0 / 1024.0) + "M";
    }

    public static void deleteAllFile(@NonNull File file) {
        if (file.exists()) {
            File[] files;
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
                for (File childFile : files) {
                    FileUtils.deleteAllFile(childFile);
                }
            }
        }
    }

    public static Uri fileToUri(@NonNull Context context, @NonNull File file, @NonNull Intent intent) {
        Uri uri;
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = context.getPackageName() + ".provider";
            uri = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
            List resolveInfos = context.getPackageManager().queryIntentActivities(intent, 65536);
            if (resolveInfos != null && resolveInfos.size() > 0) {
                for (ResolveInfo resolveInfo : resolveInfos) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    context.grantUriPermission(packageName, uri, 3);
                }
            }
        } else {
            uri = Uri.fromFile((File)file);
        }
        return uri;
    }

    public static void scanImage(@NonNull Context context, @NonNull File file) {
        if (Build.VERSION.SDK_INT >= 21) {
            MediaScanner ms = new MediaScanner(context, file);
            ms.refresh();
        } else {
            Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            intent.setData(Uri.fromFile((File)file));
            context.sendBroadcast(intent);
        }
    }
}

