/*
 * Decompiled with CFR 0.152.
 */
package utils.task;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.trello.rxlifecycle2.components.support.RxAppCompatActivity;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.List;
import utils.CompressPicker;
import utils.LogUtils;
import utils.UiUtils;
import utils.bean.ImageConfig;

public class CompressImageTask {
    private boolean mIsCompressing;
    @SuppressLint(value={"StaticFieldLeak"})
    private static CompressImageTask mTask = null;

    public boolean isCompressImage() {
        return this.mIsCompressing;
    }

    public void onRecycle() {
    }

    private CompressImageTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CompressImageTask getInstance() {
        Class<CompressImageTask> clazz = CompressImageTask.class;
        synchronized (CompressImageTask.class) {
            if (mTask != null) return mTask;
            Class<CompressImageTask> clazz2 = CompressImageTask.class;
            synchronized (CompressImageTask.class) {
                mTask = new CompressImageTask();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mTask;
            }
        }
    }

    public void compressBitmap(@NonNull RxAppCompatActivity activity, final @NonNull ImageConfig imageConfig, final @NonNull OnBitmapResult onBitmapResult) {
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ImageConfig>(){

            public void subscribe(ObservableEmitter<ImageConfig> e) throws Exception {
                e.onNext((Object)imageConfig);
            }
        }).compose((ObservableTransformer)activity.bindToLifecycle()).map((Function)new Function<ImageConfig, Bitmap>(){

            public Bitmap apply(ImageConfig imageConfig) throws Exception {
                return CompressPicker.compressBitmap(imageConfig);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribeOn(Schedulers.io()).subscribe((Observer)new Observer<Bitmap>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Bitmap bitmap) {
                if (bitmap != null && bitmap.getHeight() > 0 && bitmap.getWidth() > 0) {
                    onBitmapResult.resultBitmapSucceed(bitmap);
                } else {
                    onBitmapResult.resultBitmapError();
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    public void compressImage(@NonNull RxAppCompatActivity activity, final @NonNull ImageConfig imageConfig, final @NonNull OnImageResult onImageResult) {
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ImageConfig>(){

            public void subscribe(ObservableEmitter<ImageConfig> e) throws Exception {
                e.onNext((Object)imageConfig);
                CompressImageTask.this.mIsCompressing = true;
            }
        }).compose((ObservableTransformer)activity.bindToLifecycle()).map((Function)new Function<ImageConfig, File>(){

            public File apply(ImageConfig imageConfig) throws Exception {
                Bitmap bitmap = CompressPicker.compressBitmap(imageConfig);
                return CompressPicker.bitmapToFile(UiUtils.getContext(), bitmap);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<File>(){

            public void onSubscribe(Disposable d) {
                LogUtils.w("compressImage--", "onSubscribe");
            }

            public void onNext(File file) {
                LogUtils.w("compressImage--", "onNext");
                CompressImageTask.this.mIsCompressing = false;
                if (file != null) {
                    onImageResult.resultFileSucceed(file);
                } else {
                    onImageResult.resultFileError();
                }
            }

            public void onError(Throwable e) {
                LogUtils.w("compressImage--", "onError");
            }

            public void onComplete() {
                CompressImageTask.this.mIsCompressing = false;
                LogUtils.w("compressImage--", "onComplete");
            }
        });
    }

    public void compressImages(@NonNull RxAppCompatActivity activity, @NonNull List<ImageConfig> list, final @NonNull OnImagesResult onImageListResult) {
        if (list.size() == 0) {
            return;
        }
        Observable.fromIterable(list).compose((ObservableTransformer)activity.bindToLifecycle()).map((Function)new Function<ImageConfig, File>(){

            public File apply(ImageConfig imageConfig) throws Exception {
                CompressImageTask.this.mIsCompressing = true;
                return CompressPicker.bitmapToFile(UiUtils.getContext(), CompressPicker.compressBitmap(imageConfig));
            }
        }).toList().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((SingleObserver)new SingleObserver<List<File>>(){

            public void onSubscribe(Disposable d) {
            }

            public void onSuccess(List<File> files) {
                CompressImageTask.this.mIsCompressing = false;
                if (files.size() > 0) {
                    onImageListResult.resultFilesSucceed(files);
                } else {
                    onImageListResult.resultFilesError();
                }
            }

            public void onError(Throwable e) {
            }
        });
    }

    public static interface OnBitmapResult {
        public void resultBitmapSucceed(Bitmap var1);

        public void resultBitmapError();
    }

    public static interface OnImageResult {
        public void resultFileSucceed(File var1);

        public void resultFileError();
    }

    public static interface OnImagesResult {
        public void resultFilesSucceed(List<File> var1);

        public void resultFilesError();
    }
}

