/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.hitomi.tilibrary.loader.ImageProcessor;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.utils.ImageUtils;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import pl.droidsonroids.gif.GifDrawable;

abstract class TransferState {
    static final int TYPE_PLACEHOLDER_MISS = 1;
    static final int TYPE_PLACEHOLDER_ERROR = 2;
    protected TransferLayout transfer;

    TransferState(TransferLayout transfer) {
        this.transfer = transfer;
    }

    private int[] getViewLocation(View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        location[1] = location[1] - this.transfer.getPaddingTop();
        return location;
    }

    @NonNull
    TransferImage createTransferImage(ImageView originImage, boolean bindListener) {
        TransferConfig config = this.transfer.getTransConfig();
        int[] location = this.getViewLocation((View)originImage);
        TransferImage transImage = new TransferImage(this.transfer.getContext());
        transImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        transImage.setOriginalInfo(location[0], location[1], originImage.getWidth(), originImage.getHeight());
        transImage.setDuration(config.getDuration());
        transImage.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (bindListener) {
            transImage.setOnTransferListener(this.transfer.transListener);
        }
        return transImage;
    }

    void startPreview(final TransferImage targetImage, File source, String imgUrl, final StartPreviewCallback callback) {
        targetImage.enableGesture();
        File cacheDir = this.transfer.getTransConfig().getImageLoader().getCacheDir();
        ImageProcessor.getInstance().process(this.transfer.getContext(), imgUrl, source, cacheDir, this.getDisplaySize(), new ImageProcessor.ImageProcessCallback(){

            @Override
            public void onSuccess(File file) {
                if (ImageUtils.getImageType(file) == 1) {
                    try {
                        targetImage.setImageDrawable((Drawable)new GifDrawable(file.getPath()));
                    }
                    catch (IOException iOException) {}
                } else {
                    targetImage.setImageBitmap(BitmapFactory.decodeFile((String)file.getAbsolutePath()));
                }
                callback.invoke();
            }

            @Override
            public void onFailure() {
                callback.invoke();
            }
        });
    }

    void clipTargetImage(TransferImage targetImage, Drawable originDrawable, int[] clipSize) {
        Point screenSize = this.getDisplaySize();
        int width = screenSize.x;
        int height = screenSize.y;
        targetImage.setOriginalInfo(originDrawable, clipSize[0], clipSize[1], width, height);
        targetImage.transClip();
    }

    void loadFailedDrawable(TransferImage targetImage, int pos) {
        Drawable errorDrawable = this.transfer.getTransConfig().getErrorDrawable(this.transfer.getContext());
        this.clipTargetImage(targetImage, errorDrawable, this.getPlaceholderClipSize(pos, 2));
        targetImage.setImageDrawable(errorDrawable);
    }

    int[] getPlaceholderClipSize(int position, int placeholderType) {
        ImageView originImage;
        int[] clipSize = new int[2];
        TransferConfig transConfig = this.transfer.getTransConfig();
        List<ImageView> originImageList = transConfig.getOriginImageList();
        ImageView imageView = originImage = originImageList.isEmpty() ? null : originImageList.get(position);
        if (originImage == null) {
            for (ImageView imageView2 : originImageList) {
                if (imageView2 == null) continue;
                originImage = imageView2;
                break;
            }
        }
        if (originImage == null) {
            Drawable defaultDrawable = placeholderType == 1 ? transConfig.getMissDrawable(this.transfer.getContext()) : transConfig.getErrorDrawable(this.transfer.getContext());
            clipSize[0] = defaultDrawable.getIntrinsicWidth();
            clipSize[1] = defaultDrawable.getIntrinsicHeight();
        } else {
            clipSize[0] = originImage.getWidth();
            clipSize[1] = originImage.getHeight();
        }
        return clipSize;
    }

    private Point getDisplaySize() {
        WindowManager wm = (WindowManager)this.transfer.getContext().getSystemService("window");
        if (wm == null) {
            return new Point();
        }
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            wm.getDefaultDisplay().getRealSize(point);
        } else {
            wm.getDefaultDisplay().getSize(point);
        }
        point.y = point.y - this.transfer.getPaddingTop() - this.transfer.getPaddingBottom();
        return point;
    }

    private Bitmap getRightOrientationBitmap(File source) {
        String sourcePath = source.getAbsolutePath();
        Bitmap bitmap = BitmapFactory.decodeFile((String)sourcePath);
        try {
            ExifInterface exifInfo = new ExifInterface(sourcePath);
            int orientation = exifInfo.getAttributeInt("Orientation", 0);
            Matrix matrix = new Matrix();
            switch (orientation) {
                case 2: {
                    matrix.setScale(-1.0f, 1.0f);
                    break;
                }
                case 3: {
                    matrix.setRotate(180.0f);
                    break;
                }
                case 4: {
                    matrix.setRotate(180.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 5: {
                    matrix.setRotate(90.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 6: {
                    matrix.setRotate(90.0f);
                    break;
                }
                case 7: {
                    matrix.setRotate(-90.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 8: {
                    matrix.setRotate(-90.0f);
                    break;
                }
                default: {
                    return bitmap;
                }
            }
            Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            bitmap.recycle();
            return rotatedBitmap;
        }
        catch (Exception ignored) {
            return bitmap;
        }
    }

    public abstract void prepareTransfer(TransferImage var1, int var2);

    public abstract TransferImage transferIn(int var1);

    public abstract void transferLoad(int var1);

    public abstract TransferImage transferOut(int var1);

    public static interface StartPreviewCallback {
        public void invoke();
    }
}

