/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;

public class NoneThumbState
extends TransferState {
    NoneThumbState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(TransferImage transImage, int position) {
    }

    @Override
    public TransferImage transferIn(int position) {
        this.transfer.displayTransfer();
        return null;
    }

    @Override
    public void transferLoad(int position) {
        TransferAdapter adapter = this.transfer.transAdapter;
        TransferConfig transConfig = this.transfer.getTransConfig();
        String imgUrl = transConfig.getSourceUrlList().get(position);
        TransferImage targetImage = adapter.getImageItem(position);
        File cache = transConfig.getImageLoader().getCache(imgUrl);
        if (cache == null) {
            Drawable placeholder = transConfig.getMissDrawable(this.transfer.getContext());
            int[] clipSize = new int[]{placeholder.getIntrinsicWidth(), placeholder.getIntrinsicHeight()};
            this.clipTargetImage(targetImage, placeholder, clipSize);
            IProgressIndicator progressIndicator = transConfig.getProgressIndicator();
            progressIndicator.attach(position, adapter.getParentItem(position));
            targetImage.setImageDrawable(placeholder);
            this.loadSourceImage(targetImage, progressIndicator, imgUrl, position);
        } else {
            Bitmap bitmap = BitmapFactory.decodeFile((String)cache.getAbsolutePath());
            if (bitmap == null) {
                targetImage.setImageDrawable(transConfig.getMissDrawable(this.transfer.getContext()));
            } else {
                targetImage.setImageBitmap(bitmap);
            }
            this.loadSourceImage(targetImage, null, imgUrl, position);
        }
    }

    private void loadSourceImage(final TransferImage targetImage, final IProgressIndicator progressIndicator, final String imgUrl, final int position) {
        TransferConfig transConfig = this.transfer.getTransConfig();
        transConfig.getImageLoader().loadSource(imgUrl, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
                if (progressIndicator != null) {
                    progressIndicator.onStart(position);
                }
            }

            @Override
            public void onProgress(int progress) {
                if (progressIndicator != null) {
                    progressIndicator.onProgress(position, progress);
                }
            }

            @Override
            public void onDelivered(int status, File source) {
                switch (status) {
                    case 1: {
                        NoneThumbState.this.startPreview(targetImage, source, imgUrl, new TransferState.StartPreviewCallback(){

                            @Override
                            public void invoke() {
                                if (progressIndicator != null) {
                                    progressIndicator.onFinish(position);
                                }
                                if (progressIndicator != null) {
                                    targetImage.transformIn();
                                }
                            }
                        });
                        break;
                    }
                    case 0: {
                        NoneThumbState.this.loadFailedDrawable(targetImage, position);
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        return null;
    }
}

