/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.loader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.media.ExifInterface;
import android.os.Handler;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.hitomi.tilibrary.utils.FileUtils;
import com.hitomi.tilibrary.utils.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import top.zibin.luban.Luban;

public class ImageProcessor {
    private static final int THREAD_COUNT = 32;
    private ExecutorService execService;
    private ImageHandler handler;
    private static Map<String, ImageProcessCallback> callbackMap;

    private ImageProcessor() {
        this.init();
    }

    public static ImageProcessor getInstance() {
        return SingletonHolder.instance;
    }

    private void init() {
        this.execService = Executors.newFixedThreadPool(32);
        this.handler = new ImageHandler();
        callbackMap = new HashMap<String, ImageProcessCallback>();
    }

    public void process(Context context, final String key, final File sourceFile, File savedDir, Point displaySize, @NonNull ImageProcessCallback callback) {
        final File targetFile = new File(savedDir, this.getFileName(key));
        if (!this.isNeedProcess(sourceFile, displaySize.x, displaySize.y) || ImageUtils.getImageType(sourceFile) == 1) {
            callbackMap.put(key, callback);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    FileUtils.copyFile(sourceFile, targetFile);
                    ImageProcessor.this.handler.sendMessage(ImageProcessor.this.handler.obtainMessage(200, new Pair((Object)key, (Object)targetFile)));
                }
            }).start();
        } else if (FileUtils.isFileExists(targetFile)) {
            callback.onSuccess(targetFile);
        } else {
            callbackMap.put(key, callback);
            this.execService.execute(new ImageTask(context, key, sourceFile, savedDir));
        }
    }

    private boolean isNeedProcess(File source, int maxWidth, int maxHeight) {
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)source.getAbsolutePath(), (BitmapFactory.Options)newOpts);
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        int orientation = this.getImageOrientation(source.getAbsolutePath());
        boolean needAdjustOrientation = orientation != 0 && orientation != 1;
        return needAdjustOrientation || w > maxWidth || h > maxHeight;
    }

    private String getFileName(String imageUrl) {
        String[] nameArray = imageUrl.split("/");
        return nameArray[nameArray.length - 1];
    }

    private int getImageOrientation(String sourcePath) {
        try {
            ExifInterface exifInfo = new ExifInterface(sourcePath);
            return exifInfo.getAttributeInt("Orientation", 0);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private void adjustOrientation(File source, File target) {
        String sourcePath = source.getAbsolutePath();
        int orientation = this.getImageOrientation(sourcePath);
        Matrix matrix = new Matrix();
        switch (orientation) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                matrix.setRotate(90.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 8: {
                matrix.setRotate(-90.0f);
                break;
            }
            default: {
                FileUtils.copyFile(source, target);
                return;
            }
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)sourcePath);
        Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        bitmap.recycle();
        FileUtils.save(rotatedBitmap, target);
    }

    public static interface ImageProcessCallback {
        public void onSuccess(File var1);

        public void onFailure();
    }

    private class ImageTask
    implements Runnable {
        private Context context;
        private String key;
        private File originFile;
        private File savedDir;

        public ImageTask(Context context, String key, File originFile, File savedDir) {
            this.context = context;
            this.key = key;
            this.originFile = originFile;
            this.savedDir = savedDir;
        }

        @Override
        public void run() {
            try {
                List files = Luban.with((Context)this.context).load(this.originFile).ignoreBy(150).setTargetDir(this.savedDir.getAbsolutePath()).get();
                File targetFile = new File(this.savedDir, ImageProcessor.this.getFileName(this.key));
                File compressFile = files != null && !files.isEmpty() ? (File)files.get(0) : this.originFile;
                ImageProcessor.this.adjustOrientation(compressFile, targetFile);
                if (!compressFile.getAbsolutePath().equals(this.originFile.getAbsolutePath())) {
                    FileUtils.delete(compressFile);
                }
                ImageProcessor.this.handler.sendMessage(ImageProcessor.this.handler.obtainMessage(200, new Pair((Object)this.key, (Object)targetFile)));
            }
            catch (IOException ignored) {
                ImageProcessor.this.handler.sendMessage(ImageProcessor.this.handler.obtainMessage(0, this.key));
            }
        }
    }

    private static class ImageHandler
    extends Handler {
        private ImageHandler() {
        }

        public void handleMessage(Message msg) {
            if (msg.what == 200) {
                Pair data = (Pair)msg.obj;
                ImageProcessCallback callback = (ImageProcessCallback)callbackMap.get(data.first);
                if (callback != null) {
                    callback.onSuccess((File)data.second);
                }
                callbackMap.remove(data.first);
            } else {
                ImageProcessCallback callback = (ImageProcessCallback)callbackMap.get(msg.obj.toString());
                if (callback != null) {
                    callback.onFailure();
                }
                callbackMap.remove(msg.obj.toString());
            }
            super.handleMessage(msg);
        }
    }

    private static class SingletonHolder {
        private static final ImageProcessor instance = new ImageProcessor();

        private SingletonHolder() {
        }
    }
}

