/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.BitmapFactory;
import android.view.View;
import android.widget.ImageView;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.utils.EncryptUtils;
import com.hitomi.tilibrary.utils.FileUtils;
import com.hitomi.tilibrary.view.image.TransferImage;
import com.hitomi.tilibrary.view.video.ExoVideoView;
import java.io.File;
import java.util.List;

public class VideoThumbState
extends TransferState {
    static final String FRAME_DIR = "frame";

    VideoThumbState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(TransferImage transImage, int position) {
    }

    @Override
    public TransferImage transferIn(int position) {
        TransferImage transInImage = null;
        TransferConfig transConfig = this.transfer.getTransConfig();
        ImageView originImage = transConfig.getOriginImageList().get(position);
        String videoSourceUrl = transConfig.getSourceUrlList().get(position);
        if (originImage.getDrawable() == null) {
            this.transfer.displayTransfer();
        } else {
            transInImage = this.createTransferImage(originImage, true);
            transInImage.setImageDrawable(originImage.getDrawable());
            transInImage.setAlpha(1.0f);
            transInImage.animate().alpha(0.0f).setDuration(transConfig.getDuration());
            transInImage.transformIn();
            this.transfer.addView((View)transInImage, 1);
            File firstFrameFile = this.getFirstFrameFile(videoSourceUrl);
            if (firstFrameFile.exists()) {
                TransferImage alphaOneImage = this.createTransferImage(originImage, false);
                alphaOneImage.setImageBitmap(BitmapFactory.decodeFile((String)firstFrameFile.getAbsolutePath()));
                alphaOneImage.setAlpha(0.0f);
                alphaOneImage.animate().alpha(1.0f).setDuration(transConfig.getDuration());
                alphaOneImage.transformIn();
                this.transfer.addView((View)alphaOneImage, 2);
            }
        }
        return transInImage;
    }

    @Override
    public void transferLoad(final int position) {
        TransferAdapter transAdapter = this.transfer.transAdapter;
        final TransferConfig transConfig = this.transfer.getTransConfig();
        final String videoSourceUrl = transConfig.getSourceUrlList().get(position);
        final ExoVideoView exoVideo = transAdapter.getVideoItem(position);
        exoVideo.setVideoStateChangeListener(new ExoVideoView.VideoStateChangeListener(){
            private IProgressIndicator progressIndicator;
            private boolean isAttachProgress;
            {
                this.progressIndicator = transConfig.getProgressIndicator();
                this.isAttachProgress = false;
            }

            @Override
            public void onVideoBuffering() {
                if (this.isAttachProgress) {
                    return;
                }
                this.isAttachProgress = true;
                this.progressIndicator.attach(position, VideoThumbState.this.transfer.transAdapter.getParentItem(position));
                this.progressIndicator.onStart(position);
            }

            @Override
            public void onVideoReady() {
                this.progressIndicator.onFinish(position);
            }

            @Override
            public void onVideoRendered() {
                File firstFrameFile = VideoThumbState.this.getFirstFrameFile(videoSourceUrl);
                if (firstFrameFile.exists()) {
                    View alphaOneImage = VideoThumbState.this.transfer.getChildAt(2);
                    if (alphaOneImage instanceof TransferImage) {
                        VideoThumbState.this.transfer.removeFromParent(alphaOneImage);
                    }
                } else {
                    FileUtils.save(exoVideo.getBitmap(), firstFrameFile);
                }
                View alphaZeroImage = VideoThumbState.this.transfer.getChildAt(1);
                if (alphaZeroImage instanceof TransferImage) {
                    VideoThumbState.this.transfer.removeFromParent(alphaZeroImage);
                }
            }
        });
        exoVideo.setSource(transConfig.getSourceUrlList().get(position), false);
    }

    private File getFirstFrameFile(String videoSourceUrl) {
        File cacheDir = new File(this.transfer.getContext().getCacheDir(), "TransExo");
        String frameName = EncryptUtils.encryptMD5ToString(videoSourceUrl);
        return new File(cacheDir, String.format("/%s/%s.jpg", FRAME_DIR, frameName.toLowerCase()));
    }

    @Override
    public TransferImage transferOut(int position) {
        TransferImage transOutImage = null;
        TransferConfig config = this.transfer.getTransConfig();
        List<ImageView> originImageList = config.getOriginImageList();
        if (position <= originImageList.size() - 1 && originImageList.get(position) != null) {
            ImageView originImage = originImageList.get(position);
            int[] location = new int[2];
            originImage.getLocationInWindow(location);
            TransferImage alphaOneImage = this.createTransferImage(originImage, true);
            alphaOneImage.setImageDrawable(originImage.getDrawable());
            alphaOneImage.setAlpha(0.0f);
            alphaOneImage.animate().alpha(1.0f).setDuration(config.getDuration());
            alphaOneImage.transformOut();
            TransferImage alphaZeroImage = this.createTransferImage(originImage, false);
            alphaZeroImage.setImageBitmap(this.transfer.getCurrentVideo().getBitmap());
            alphaZeroImage.setAlpha(1.0f);
            alphaZeroImage.animate().alpha(0.0f).setDuration(config.getDuration());
            alphaZeroImage.transformOut();
            this.transfer.addView((View)alphaOneImage, 1);
            this.transfer.addView((View)alphaZeroImage, 2);
            transOutImage = alphaOneImage;
        }
        this.transfer.transAdapter.getVideoItem(position).pause();
        return transOutImage;
    }
}

