/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.viewpager.widget.ViewPager;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.view.image.TransferImage;
import com.hitomi.tilibrary.view.video.ExoVideoView;

class DragCloseGesture {
    private static int SOURCE_IMAGE = 1;
    private static int SOURCE_VIDEO = 2;
    private TransferLayout transferLayout;
    private VelocityTracker velocityTracker;
    private float preX;
    private float preY;
    private float scale;
    private int touchSlop;
    private int sourceType;
    private DragCloseListener dragListener;

    DragCloseGesture(TransferLayout transferLayout, DragCloseListener listener) {
        this.transferLayout = transferLayout;
        this.touchSlop = ViewConfiguration.get((Context)transferLayout.getContext()).getScaledEdgeSlop();
        this.dragListener = listener;
    }

    boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() == 1) {
            switch (ev.getAction()) {
                case 0: {
                    this.preX = ev.getRawX();
                    this.preY = ev.getRawY();
                    if (null == this.velocityTracker) {
                        this.velocityTracker = VelocityTracker.obtain();
                    } else {
                        this.velocityTracker.clear();
                    }
                    this.velocityTracker.addMovement(ev);
                    this.sourceType = this.transferLayout.getTransConfig().isVideoSource(-1) ? SOURCE_VIDEO : SOURCE_IMAGE;
                    break;
                }
                case 2: {
                    float diffY = ev.getRawY() - this.preY;
                    float diffX = Math.abs(ev.getRawX() - this.preX);
                    if (!(diffX < (float)this.touchSlop) || !(diffY > (float)this.touchSlop)) break;
                    if (this.sourceType == SOURCE_IMAGE && this.transferLayout.getCurrentImage().isScrollTop()) {
                        if (this.dragListener != null) {
                            this.dragListener.onDragStar();
                        }
                        return true;
                    }
                    if (this.sourceType != SOURCE_VIDEO) break;
                    if (this.dragListener != null) {
                        this.dragListener.onDragStar();
                    }
                    return true;
                }
                case 1: {
                    this.preY = 0.0f;
                }
            }
        }
        return false;
    }

    void onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.preX = event.getRawX();
                this.preY = event.getRawY();
                break;
            }
            case 2: {
                this.velocityTracker.addMovement(event);
                float diffX = event.getRawX() - this.preX;
                float diffY = event.getRawY() - this.preY;
                float absDiffY = Math.abs(diffY);
                this.scale = 1.0f - absDiffY / (float)this.transferLayout.getHeight() * 0.75f;
                float scaleOffsetY = (1.0f - this.scale) * (1.0f - this.scale) * (float)this.transferLayout.getHeight() * 0.5f;
                this.transferLayout.alpha = absDiffY < 350.0f ? 255.0f - absDiffY / 350.0f * 25.0f : 230.0f - (absDiffY - 350.0f) * 1.35f / (float)this.transferLayout.getHeight() * 255.0f;
                this.transferLayout.alpha = this.transferLayout.alpha < 0.0f ? 0.0f : this.transferLayout.alpha;
                ViewPager transViewPager = this.transferLayout.transViewPager;
                if (transViewPager.getTranslationY() >= 0.0f) {
                    this.transferLayout.setBackgroundColor(this.transferLayout.getBackgroundColorByAlpha(this.transferLayout.alpha));
                    transViewPager.setTranslationX(diffX);
                    transViewPager.setTranslationY(diffY - scaleOffsetY);
                    transViewPager.setScaleX(this.scale);
                    transViewPager.setScaleY(this.scale);
                    break;
                }
                this.transferLayout.setBackgroundColor(this.transferLayout.getTransConfig().getBackgroundColor());
                transViewPager.setTranslationX(diffX);
                transViewPager.setTranslationY(diffY);
                break;
            }
            case 1: {
                this.velocityTracker.addMovement(event);
                this.velocityTracker.computeCurrentVelocity(1000);
                float velocityY = this.velocityTracker.getYVelocity();
                if (velocityY > 100.0f) {
                    int pos = this.transferLayout.getTransConfig().getNowThumbnailIndex();
                    ImageView originImage = null;
                    if (!this.transferLayout.getTransConfig().getOriginImageList().isEmpty()) {
                        originImage = this.transferLayout.getTransConfig().getOriginImageList().get(pos);
                    }
                    if (originImage == null) {
                        this.transferLayout.diffusionTransfer(pos);
                    } else if (this.sourceType == SOURCE_IMAGE) {
                        this.startTransformImageAnimate(originImage);
                    } else {
                        this.startTransformVideoAnimate(originImage);
                    }
                } else {
                    this.startFlingAndRollbackAnimation();
                }
                this.preX = 0.0f;
                this.preY = 0.0f;
                break;
            }
            case 3: {
                if (null == this.velocityTracker) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
        }
    }

    private void startTransformImageAnimate(ImageView originImage) {
        float currTransHeight;
        float currTransWidth;
        ViewPager transViewPagerUp = this.transferLayout.transViewPager;
        transViewPagerUp.setVisibility(4);
        TransferImage currTransImage = this.transferLayout.getCurrentImage();
        int[] location = new int[2];
        originImage.getLocationInWindow(location);
        int x = location[0];
        int y = location[1];
        int width = originImage.getWidth();
        int height = originImage.getHeight();
        TransferImage transImage = new TransferImage(this.transferLayout.getContext());
        transImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        transImage.setOriginalInfo(x, y, width, height);
        transImage.setDuration(this.transferLayout.getTransConfig().getDuration());
        transImage.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        transImage.setOnTransferListener(this.transferLayout.transListener);
        transImage.setImageDrawable(currTransImage.getDrawable());
        if (currTransImage.isEnableGesture()) {
            float[] afterSize = currTransImage.getAfterTransferSize();
            currTransWidth = afterSize[0];
            currTransHeight = afterSize[1];
        } else {
            float[] beforeSize = currTransImage.getBeforeTransferSize(width, height);
            currTransWidth = beforeSize[0];
            currTransHeight = beforeSize[1];
        }
        float realWidth = currTransWidth * this.scale;
        float realHeight = currTransHeight * this.scale;
        float left = transViewPagerUp.getTranslationX() + ((float)this.transferLayout.getWidth() - realWidth) * 0.5f;
        float top = transViewPagerUp.getTranslationY() + ((float)this.transferLayout.getHeight() - realHeight) * 0.5f;
        RectF rectF = new RectF(left, top, left + realWidth, top + realHeight);
        transImage.transformSpecOut(rectF, this.scale);
        this.transferLayout.addView((View)transImage, 1);
    }

    private void startTransformVideoAnimate(ImageView originImage) {
        ViewPager transViewPagerUp = this.transferLayout.transViewPager;
        transViewPagerUp.setVisibility(4);
        ExoVideoView currVideo = this.transferLayout.getCurrentVideo();
        long duration = this.transferLayout.getTransConfig().getDuration();
        int[] location = new int[2];
        originImage.getLocationInWindow(location);
        int x = location[0];
        int y = location[1];
        int width = originImage.getWidth();
        int height = originImage.getHeight();
        TransferImage alphaOneImage = new TransferImage(this.transferLayout.getContext());
        alphaOneImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        alphaOneImage.setOriginalInfo(x, y, width, height);
        alphaOneImage.setDuration(duration);
        alphaOneImage.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        alphaOneImage.setImageDrawable(originImage.getDrawable());
        alphaOneImage.setAlpha(0.0f);
        alphaOneImage.animate().alpha(1.0f).setDuration(duration);
        TransferImage alphaZeroImage = new TransferImage(this.transferLayout.getContext());
        alphaZeroImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        alphaZeroImage.setOriginalInfo(x, y, width, height);
        alphaZeroImage.setDuration(duration);
        alphaZeroImage.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        alphaZeroImage.setOnTransferListener(this.transferLayout.transListener);
        alphaZeroImage.setImageBitmap(currVideo.getBitmap());
        alphaZeroImage.setAlpha(1.0f);
        alphaZeroImage.animate().alpha(0.0f).setDuration(duration);
        float realWidth = (float)currVideo.getMeasuredWidth() * this.scale;
        float realHeight = (float)currVideo.getMeasuredHeight() * this.scale;
        float left = transViewPagerUp.getTranslationX() + ((float)this.transferLayout.getWidth() - realWidth) * 0.5f;
        float top = transViewPagerUp.getTranslationY() + ((float)this.transferLayout.getHeight() - realHeight) * 0.5f;
        RectF rectF = new RectF(left, top, left + realWidth, top + realHeight);
        alphaOneImage.transformSpecOut(rectF, this.scale);
        alphaZeroImage.transformSpecOut(rectF, this.scale);
        this.transferLayout.addView((View)alphaOneImage, 1);
        this.transferLayout.addView((View)alphaZeroImage, 2);
    }

    private void startFlingAndRollbackAnimation() {
        ViewPager transViewPager = this.transferLayout.transViewPager;
        ObjectAnimator bgColor = ObjectAnimator.ofFloat(null, (String)"alpha", (float[])new float[]{this.transferLayout.alpha, 255.0f});
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)transViewPager, (String)"scaleX", (float[])new float[]{transViewPager.getScaleX(), 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)transViewPager, (String)"scaleY", (float[])new float[]{transViewPager.getScaleX(), 1.0f});
        ObjectAnimator transX = ObjectAnimator.ofFloat((Object)transViewPager, (String)"translationX", (float[])new float[]{transViewPager.getTranslationX(), 0.0f});
        ObjectAnimator transY = ObjectAnimator.ofFloat((Object)transViewPager, (String)"translationY", (float[])new float[]{transViewPager.getTranslationY(), 0.0f});
        bgColor.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = Float.parseFloat(animation.getAnimatedValue().toString());
                DragCloseGesture.this.transferLayout.setBackgroundColor(DragCloseGesture.this.transferLayout.getBackgroundColorByAlpha(value));
            }
        });
        bgColor.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (DragCloseGesture.this.dragListener != null) {
                    DragCloseGesture.this.dragListener.onDragRollback();
                }
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{bgColor, scaleX, scaleY, transX, transY});
        animatorSet.start();
    }

    public static interface DragCloseListener {
        public void onDragStar();

        public void onDragRollback();
    }
}

