/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;
import java.util.List;

class LocalThumbState
extends TransferState {
    LocalThumbState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(TransferImage transImage, int position) {
        TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        String imgUrl = config.getSourceImageList().get(position);
        imageLoader.showImage(imgUrl, (ImageView)transImage, config.getMissDrawable(this.transfer.getContext()), null);
    }

    @Override
    public TransferImage createTransferIn(int position) {
        TransferConfig config = this.transfer.getTransConfig();
        TransferImage transImage = this.createTransferImage(config.getOriginImageList().get(position));
        this.transformThumbnail(config.getSourceImageList().get(position), transImage, true);
        this.transfer.addView((View)transImage, 1);
        return transImage;
    }

    @Override
    public void transferLoad(final int position) {
        final TransferConfig config = this.transfer.getTransConfig();
        final String imgUrl = config.getSourceImageList().get(position);
        final TransferImage targetImage = this.transfer.transAdapter.getImageItem(position);
        if (config.isJustLoadHitImage()) {
            this.loadSourceImage(imgUrl, targetImage, targetImage.getDrawable(), position);
        } else {
            config.getImageLoader().loadImageAsync(imgUrl, new ImageLoader.ThumbnailCallback(){

                @Override
                public void onFinish(Bitmap bitmap) {
                    Object placeholder = null;
                    placeholder = bitmap == null ? config.getMissDrawable(LocalThumbState.this.transfer.getContext()) : new BitmapDrawable(LocalThumbState.this.transfer.getContext().getResources(), bitmap);
                    LocalThumbState.this.loadSourceImage(imgUrl, targetImage, placeholder, position);
                }
            });
        }
    }

    private void loadSourceImage(final String imgUrl, final TransferImage targetImage, Drawable drawable2, final int position) {
        final TransferConfig config = this.transfer.getTransConfig();
        config.getImageLoader().showImage(imgUrl, (ImageView)targetImage, drawable2, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
            }

            @Override
            public void onProgress(int progress) {
            }

            @Override
            public void onDelivered(int status, File source) {
                switch (status) {
                    case 1: {
                        if (4 == targetImage.getState()) {
                            targetImage.transformIn(202);
                        }
                        LocalThumbState.this.startPreview(targetImage, source, imgUrl, config, position);
                        break;
                    }
                    case -1: {
                        if (targetImage.getDrawable() == null) break;
                        LocalThumbState.this.startPreview(targetImage, source, imgUrl, config, position);
                        break;
                    }
                    case 0: {
                        targetImage.setImageDrawable(config.getErrorDrawable(LocalThumbState.this.transfer.getContext()));
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        TransferImage transImage = null;
        TransferConfig config = this.transfer.getTransConfig();
        List<ImageView> originImageList = config.getOriginImageList();
        if (position <= originImageList.size() - 1 && originImageList.get(position) != null) {
            transImage = this.createTransferImage(originImageList.get(position));
            this.transformThumbnail(config.getSourceImageList().get(position), transImage, false);
            this.transfer.addView((View)transImage, 1);
        }
        return transImage;
    }
}

