/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ImageView;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hitomi.tilibrary.style.index.CircleIndexIndicator;
import com.hitomi.tilibrary.style.progress.ProgressBarIndicator;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Transferee
implements DialogInterface.OnShowListener,
DialogInterface.OnKeyListener,
TransferLayout.OnLayoutResetListener {
    private Context context;
    private Dialog transDialog;
    private TransferLayout transLayout;
    private TransferConfig transConfig;
    private OnTransfereeStateChangeListener transListener;
    private boolean shown;

    private Transferee(Context context) {
        this.context = context;
        this.createLayout();
        this.createDialog();
    }

    public static Transferee getDefault(Context context) {
        return new Transferee(context);
    }

    private void createLayout() {
        this.transLayout = new TransferLayout(this.context);
        this.transLayout.setOnLayoutResetListener(this);
    }

    private void createDialog() {
        this.transDialog = new AlertDialog.Builder(this.context, this.getDialogStyle()).setView((View)this.transLayout).create();
        this.transDialog.setOnShowListener((DialogInterface.OnShowListener)this);
        this.transDialog.setOnKeyListener((DialogInterface.OnKeyListener)this);
    }

    private int getDialogStyle() {
        int dialogStyle = Build.VERSION.SDK_INT > 19 ? 0x1030011 : 0x1030010;
        return dialogStyle;
    }

    private void checkConfig() {
        if (this.transConfig.isSourceEmpty()) {
            throw new IllegalArgumentException("The parameter sourceImageList can't be empty");
        }
        if (this.transConfig.getImageLoader() == null) {
            throw new IllegalArgumentException("Need to specify an ImageLoader");
        }
        this.transConfig.setNowThumbnailIndex(this.transConfig.getNowThumbnailIndex() < 0 ? 0 : this.transConfig.getNowThumbnailIndex());
        this.transConfig.setOffscreenPageLimit(this.transConfig.getOffscreenPageLimit() <= 0 ? 1 : this.transConfig.getOffscreenPageLimit());
        this.transConfig.setDuration(this.transConfig.getDuration() <= 0L ? 300L : this.transConfig.getDuration());
        this.transConfig.setProgressIndicator(this.transConfig.getProgressIndicator() == null ? new ProgressBarIndicator() : this.transConfig.getProgressIndicator());
        this.transConfig.setIndexIndicator(this.transConfig.getIndexIndicator() == null ? new CircleIndexIndicator() : this.transConfig.getIndexIndicator());
    }

    private void fillOriginImages() {
        ArrayList<ImageView> originImageList = new ArrayList<ImageView>();
        if (this.transConfig.getRecyclerView() != null) {
            this.fillByRecyclerView(originImageList);
        } else if (this.transConfig.getListView() != null) {
            this.fillByListView(originImageList);
        } else if (this.transConfig.getImageView() != null) {
            originImageList.add(this.transConfig.getImageView());
        }
        this.transConfig.setOriginImageList(originImageList);
    }

    private void fillByRecyclerView(List<ImageView> originImageList) {
        RecyclerView recyclerView = this.transConfig.getRecyclerView();
        int childCount = recyclerView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ImageView originImage = (ImageView)recyclerView.getChildAt(i).findViewById(this.transConfig.getImageId());
            if (originImage == null) continue;
            originImageList.add(originImage);
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        int firstPos = 0;
        int lastPos = 0;
        int totalCount = layoutManager.getItemCount();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayMan = (GridLayoutManager)layoutManager;
            firstPos = gridLayMan.findFirstVisibleItemPosition();
            lastPos = gridLayMan.findLastVisibleItemPosition();
        } else if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linLayMan = (LinearLayoutManager)layoutManager;
            firstPos = linLayMan.findFirstVisibleItemPosition();
            lastPos = linLayMan.findLastVisibleItemPosition();
        }
        this.fillPlaceHolder(originImageList, totalCount, firstPos, lastPos);
    }

    private void fillByListView(List<ImageView> originImageList) {
        AbsListView absListView = this.transConfig.getListView();
        int childCount = absListView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ImageView originImage = (ImageView)absListView.getChildAt(i).findViewById(this.transConfig.getImageId());
            originImageList.add(originImage);
        }
        int firstPos = absListView.getFirstVisiblePosition();
        int lastPos = absListView.getLastVisiblePosition();
        int totalCount = absListView.getCount();
        this.fillPlaceHolder(originImageList, totalCount, firstPos, lastPos);
    }

    private void fillPlaceHolder(List<ImageView> originImageList, int totalCount, int firstPos, int lastPos) {
        if (firstPos > 0) {
            for (int pos = firstPos; pos > 0; --pos) {
                originImageList.add(0, null);
            }
        }
        if (lastPos < totalCount) {
            for (int i = totalCount - 1 - lastPos; i > 0; --i) {
                originImageList.add(null);
            }
        }
    }

    public Transferee apply(TransferConfig config) {
        if (!this.shown) {
            this.transConfig = config;
            this.fillOriginImages();
            this.checkConfig();
            this.transLayout.apply(config);
        }
        return this;
    }

    public boolean isShown() {
        return this.shown;
    }

    public void show() {
        if (this.shown) {
            return;
        }
        this.transDialog.show();
        if (this.transListener != null) {
            this.transListener.onShow();
        }
        this.shown = true;
    }

    public void show(OnTransfereeStateChangeListener listener) {
        if (this.shown) {
            return;
        }
        this.transDialog.show();
        this.transListener = listener;
        this.transListener.onShow();
        this.shown = true;
    }

    public void dismiss() {
        if (!this.shown) {
            return;
        }
        this.transLayout.dismiss(this.transConfig.getNowThumbnailIndex());
        this.shown = false;
    }

    public File getImageFile(String imageUri) {
        return this.transConfig.getImageLoader().getCache(imageUri);
    }

    public void clear() {
        if (this.transConfig != null && this.transConfig.getImageLoader() != null) {
            this.transConfig.getImageLoader().clearCache();
        }
    }

    public void onShow(DialogInterface dialog) {
        this.transLayout.show();
    }

    @Override
    public void onReset() {
        this.transDialog.dismiss();
        if (this.transListener != null) {
            this.transListener.onDismiss();
        }
        this.shown = false;
    }

    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1 && !event.isCanceled()) {
            this.dismiss();
        }
        return true;
    }

    public void setOnTransfereeStateChangeListener(OnTransfereeStateChangeListener listener) {
        this.transListener = listener;
    }

    public static interface OnTransfereeLongClickListener {
        public void onLongClick(ImageView var1, String var2, int var3);
    }

    public static interface OnTransfereeStateChangeListener {
        public void onShow();

        public void onDismiss();
    }
}

