/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;
import java.util.List;

class EmptyThumbState
extends TransferState {
    EmptyThumbState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(TransferImage transImage, int position) {
        transImage.setImageDrawable(this.clipAndGetPlachHolder(transImage, position));
    }

    @Override
    public TransferImage createTransferIn(int position) {
        ImageView originImage = this.transfer.getTransConfig().getOriginImageList().get(position);
        TransferImage transImage = this.createTransferImage(originImage);
        transImage.setImageDrawable(originImage.getDrawable());
        transImage.transformIn(201);
        this.transfer.addView((View)transImage, 1);
        return transImage;
    }

    @Override
    public void transferLoad(final int position) {
        TransferAdapter adapter = this.transfer.transAdapter;
        final TransferConfig config = this.transfer.getTransConfig();
        final String imgUrl = config.getSourceImageList().get(position);
        final TransferImage targetImage = adapter.getImageItem(position);
        Drawable placeHolder = config.isJustLoadHitImage() ? this.getPlaceHolder(position) : this.clipAndGetPlachHolder(targetImage, position);
        final IProgressIndicator progressIndicator = config.getProgressIndicator();
        progressIndicator.attach(position, adapter.getParentItem(position));
        config.getImageLoader().showImage(imgUrl, (ImageView)targetImage, placeHolder, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
                progressIndicator.onStart(position);
            }

            @Override
            public void onProgress(int progress) {
                progressIndicator.onProgress(position, progress);
            }

            @Override
            public void onDelivered(int status, File source) {
                progressIndicator.onFinish(position);
                switch (status) {
                    case 1: {
                        targetImage.transformIn(202);
                        EmptyThumbState.this.startPreview(targetImage, source, imgUrl, config, position);
                        break;
                    }
                    case -1: {
                        if (targetImage.getDrawable() == null) break;
                        EmptyThumbState.this.startPreview(targetImage, source, imgUrl, config, position);
                        break;
                    }
                    case 0: {
                        targetImage.setImageDrawable(config.getErrorDrawable(EmptyThumbState.this.transfer.getContext()));
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        TransferImage transImage = null;
        TransferConfig config = this.transfer.getTransConfig();
        List<ImageView> originImageList = config.getOriginImageList();
        if (position <= originImageList.size() - 1 && originImageList.get(position) != null) {
            transImage = this.createTransferImage(originImageList.get(position));
            Drawable thumbnailDrawable = this.transfer.transAdapter.getImageItem(config.getNowThumbnailIndex()).getDrawable();
            transImage.setImageDrawable(thumbnailDrawable);
            transImage.transformOut(201);
            this.transfer.addView((View)transImage, 1);
        }
        return transImage;
    }

    private Drawable getPlaceHolder(int position) {
        TransferConfig config = this.transfer.getTransConfig();
        ImageView originImage = config.getOriginImageList().get(position);
        Drawable placeHolder = originImage != null ? originImage.getDrawable() : config.getMissDrawable(this.transfer.getContext());
        return placeHolder;
    }

    private Drawable clipAndGetPlachHolder(TransferImage targetImage, int position) {
        TransferConfig config = this.transfer.getTransConfig();
        Drawable placeHolder = this.getPlaceHolder(position);
        int[] clipSize = new int[2];
        ImageView originImage = config.getOriginImageList().get(position);
        if (originImage != null) {
            clipSize[0] = originImage.getWidth();
            clipSize[1] = originImage.getHeight();
        }
        this.clipTargetImage(targetImage, placeHolder, clipSize);
        return placeHolder;
    }

    private void clipTargetImage(TransferImage targetImage, Drawable originDrawable, int[] clipSize) {
        DisplayMetrics displayMetrics = this.transfer.getContext().getResources().getDisplayMetrics();
        int width = displayMetrics.widthPixels;
        int height = this.getTransImageLocalY(displayMetrics.heightPixels);
        targetImage.setOriginalInfo(originDrawable, clipSize[0], clipSize[1], width, height);
        targetImage.transClip();
    }
}

