/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.RectF;
import android.os.Build;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.viewpager.widget.ViewPager;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.lang.reflect.Field;

class DragCloseGesture {
    private TransferLayout transferLayout;
    private VelocityTracker velocityTracker;
    private float preX;
    private float preY;
    private float scale;
    private int touchSlop;

    DragCloseGesture(TransferLayout transferLayout) {
        this.transferLayout = transferLayout;
        this.touchSlop = ViewConfiguration.get((Context)transferLayout.getContext()).getScaledEdgeSlop();
    }

    boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() == 1) {
            switch (ev.getAction()) {
                case 0: {
                    this.preX = ev.getRawX();
                    this.preY = ev.getRawY();
                    if (null == this.velocityTracker) {
                        this.velocityTracker = VelocityTracker.obtain();
                    } else {
                        this.velocityTracker.clear();
                    }
                    this.velocityTracker.addMovement(ev);
                    break;
                }
                case 2: {
                    float diffY = ev.getRawY() - this.preY;
                    float diffX = Math.abs(ev.getRawX() - this.preX);
                    TransferImage currentImage = this.transferLayout.getCurrentImage();
                    if (!(diffX < (float)this.touchSlop) || !(diffY > (float)this.touchSlop) || !currentImage.isScrollTop()) break;
                    return true;
                }
                case 1: {
                    this.preY = 0.0f;
                }
            }
        }
        return false;
    }

    void onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.preX = event.getRawX();
                this.preY = event.getRawY();
                break;
            }
            case 2: {
                this.velocityTracker.addMovement(event);
                float diffX = event.getRawX() - this.preX;
                float diffY = event.getRawY() - this.preY;
                float absDiffY = Math.abs(diffY);
                this.scale = 1.0f - absDiffY / (float)this.transferLayout.getHeight() * 0.75f;
                this.transferLayout.alpha = absDiffY < 350.0f ? 255.0f - absDiffY / 350.0f * 25.0f : 230.0f - (absDiffY - 350.0f) * 1.35f / (float)this.transferLayout.getHeight() * 255.0f;
                this.transferLayout.alpha = this.transferLayout.alpha < 0.0f ? 0.0f : this.transferLayout.alpha;
                ViewPager transViewPager = this.transferLayout.transViewPager;
                if (transViewPager.getTranslationY() >= 0.0f) {
                    this.transferLayout.setBackgroundColor(this.transferLayout.getBackgroundColorByAlpha(this.transferLayout.alpha));
                    transViewPager.setTranslationX(diffX);
                    transViewPager.setTranslationY(diffY);
                    transViewPager.setScaleX(this.scale);
                    transViewPager.setScaleY(this.scale);
                    break;
                }
                this.transferLayout.setBackgroundColor(this.transferLayout.getTransConfig().getBackgroundColor());
                transViewPager.setTranslationX(diffX);
                transViewPager.setTranslationY(diffY);
                break;
            }
            case 1: {
                this.velocityTracker.addMovement(event);
                this.velocityTracker.computeCurrentVelocity(1000);
                float velocityY = this.velocityTracker.getYVelocity();
                if (velocityY > 100.0f) {
                    int pos = this.transferLayout.getTransConfig().getNowThumbnailIndex();
                    ImageView originImage = this.transferLayout.getTransConfig().getOriginImageList().get(pos);
                    if (originImage == null) {
                        this.transferLayout.diffusionTransfer(pos);
                    } else {
                        this.startTransformAnima(pos, originImage);
                    }
                } else {
                    this.startFlingAndRollbackAnimation();
                }
                this.preX = 0.0f;
                this.preY = 0.0f;
                break;
            }
            case 3: {
                if (null == this.velocityTracker) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
        }
    }

    private void startTransformAnima(int pos, ImageView originImage) {
        ViewPager transViewPagerUp = this.transferLayout.transViewPager;
        transViewPagerUp.setVisibility(4);
        int[] location = new int[2];
        originImage.getLocationInWindow(location);
        int x = location[0];
        int y = Build.VERSION.SDK_INT > 19 ? location[1] : location[1] - this.getStatusBarHeight();
        int width = originImage.getWidth();
        int height = originImage.getHeight();
        TransferImage transImage = new TransferImage(this.transferLayout.getContext());
        transImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        transImage.setOriginalInfo(x, y, width, height);
        transImage.setDuration(300L);
        transImage.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        transImage.setOnTransferListener(this.transferLayout.transListener);
        transImage.setImageDrawable(this.transferLayout.transAdapter.getImageItem(pos).getDrawable());
        TransferImage currTransImage = this.transferLayout.getCurrentImage();
        float realWidth = currTransImage.getDeformedWidth() * this.scale;
        float realHeight = currTransImage.getDeformedHeight() * this.scale;
        float left = transViewPagerUp.getTranslationX() + ((float)this.transferLayout.getWidth() - realWidth) * 0.5f;
        float top = transViewPagerUp.getTranslationY() + ((float)this.transferLayout.getHeight() - realHeight) * 0.5f;
        RectF rectF = new RectF(left, top, realWidth, realHeight);
        transImage.transformSpecOut(rectF, this.scale);
        this.transferLayout.addView((View)transImage, 1);
    }

    private int getStatusBarHeight() {
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object object = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = (Integer)field.get(object);
            return this.transferLayout.getContext().getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void startFlingAndRollbackAnimation() {
        ViewPager transViewPager = this.transferLayout.transViewPager;
        ObjectAnimator bgColor = ObjectAnimator.ofFloat(null, (String)"alpha", (float[])new float[]{this.transferLayout.alpha, 255.0f});
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)transViewPager, (String)"scaleX", (float[])new float[]{transViewPager.getScaleX(), 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)transViewPager, (String)"scaleY", (float[])new float[]{transViewPager.getScaleX(), 1.0f});
        ObjectAnimator transX = ObjectAnimator.ofFloat((Object)transViewPager, (String)"translationX", (float[])new float[]{transViewPager.getTranslationX(), 0.0f});
        ObjectAnimator transY = ObjectAnimator.ofFloat((Object)transViewPager, (String)"translationY", (float[])new float[]{transViewPager.getTranslationY(), 0.0f});
        bgColor.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = Float.parseFloat(animation.getAnimatedValue().toString());
                DragCloseGesture.this.transferLayout.setBackgroundColor(DragCloseGesture.this.transferLayout.getBackgroundColorByAlpha(value));
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{bgColor, scaleX, scaleY, transX, transY});
        animatorSet.start();
    }
}

