/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ImageView;
import androidx.annotation.IdRes;
import androidx.recyclerview.widget.RecyclerView;
import com.hitomi.tilibrary.R;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.style.IIndexIndicator;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.Transferee;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class TransferConfig {
    private static final Pattern VIDEO_PATTERN = Pattern.compile(".+(://).+\\.(mp4|wmv|avi|mpeg|rm|rmvb|flv|3gp|mov|mkv|mod|)");
    private int nowThumbnailIndex;
    private int offscreenPageLimit;
    private int missPlaceHolder;
    private int errorPlaceHolder;
    private int backgroundColor;
    private long duration;
    private boolean justLoadHitPage;
    private boolean enableDragClose;
    private boolean enableDragHide;
    private boolean enableDragPause;
    private boolean enableHideThumb;
    private boolean enableScrollingWithPageChange;
    private Drawable missDrawable;
    private Drawable errorDrawable;
    private List<ImageView> originImageList;
    private List<String> sourceUrlList;
    private List<Uri> sourceUriList;
    private IProgressIndicator progressIndicator;
    private IIndexIndicator indexIndicator;
    private ImageLoader imageLoader;
    @IdRes
    private int imageId;
    private ImageView imageView;
    private AbsListView listView;
    private RecyclerView recyclerView;
    private View customView;
    private int headerSize;
    private int footerSize;
    private Transferee.OnTransfereeLongClickListener longClickListener;

    public static Builder build() {
        return new Builder();
    }

    public int getNowThumbnailIndex() {
        return this.nowThumbnailIndex;
    }

    public void setNowThumbnailIndex(int nowThumbnailIndex) {
        this.nowThumbnailIndex = nowThumbnailIndex;
    }

    public int getOffscreenPageLimit() {
        return this.offscreenPageLimit;
    }

    public void setOffscreenPageLimit(int offscreenPageLimit) {
        this.offscreenPageLimit = offscreenPageLimit;
    }

    public int getMissPlaceHolder() {
        return this.missPlaceHolder;
    }

    public void setMissPlaceHolder(int missPlaceHolder) {
        this.missPlaceHolder = missPlaceHolder;
    }

    public int getErrorPlaceHolder() {
        return this.errorPlaceHolder;
    }

    public void setErrorPlaceHolder(int errorPlaceHolder) {
        this.errorPlaceHolder = errorPlaceHolder;
    }

    public int getBackgroundColor() {
        return this.backgroundColor == 0 ? -16777216 : this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean isJustLoadHitPage() {
        return this.justLoadHitPage;
    }

    public void enableJustLoadHitPage(boolean justLoadHitPage) {
        this.justLoadHitPage = justLoadHitPage;
    }

    public boolean isEnableDragClose() {
        return this.enableDragClose;
    }

    public void enableDragClose(boolean enableDragClose) {
        this.enableDragClose = enableDragClose;
    }

    public void enableDragHide(boolean enableDragHide) {
        this.enableDragHide = enableDragHide;
    }

    public boolean isEnableDragHide() {
        return this.enableDragHide;
    }

    public boolean isEnableDragPause() {
        return this.enableDragPause;
    }

    public void enableDragPause(boolean enableDragPause) {
        this.enableDragPause = enableDragPause;
    }

    public boolean isEnableHideThumb() {
        return this.enableHideThumb;
    }

    public void enableHideThumb(boolean enableHideThumb) {
        this.enableHideThumb = enableHideThumb;
    }

    public boolean isEnableScrollingWithPageChange() {
        return this.enableScrollingWithPageChange;
    }

    public void enableScrollingWithPageChange(boolean enableScrollingWithPageChange) {
        this.enableScrollingWithPageChange = enableScrollingWithPageChange;
    }

    public Drawable getMissDrawable(Context context) {
        if (this.missDrawable != null) {
            return this.missDrawable;
        }
        if (this.missPlaceHolder != 0) {
            return context.getResources().getDrawable(this.missPlaceHolder);
        }
        return context.getResources().getDrawable(R.drawable.ic_empty_photo);
    }

    public void setMissDrawable(Drawable missDrawable) {
        this.missDrawable = missDrawable;
    }

    public Drawable getErrorDrawable(Context context) {
        if (this.errorDrawable != null) {
            return this.errorDrawable;
        }
        if (this.errorPlaceHolder != 0) {
            return context.getResources().getDrawable(this.errorPlaceHolder);
        }
        return context.getResources().getDrawable(R.drawable.ic_empty_photo);
    }

    public void setErrorDrawable(Drawable errorDrawable) {
        this.errorDrawable = errorDrawable;
    }

    List<ImageView> getOriginImageList() {
        return this.originImageList == null ? new ArrayList() : this.originImageList;
    }

    public void setOriginImageList(List<ImageView> originImageList) {
        this.originImageList = originImageList;
    }

    public List<String> getSourceUrlList() {
        if (this.sourceUrlList == null || this.sourceUrlList.isEmpty()) {
            this.sourceUrlList = new ArrayList<String>();
            if (this.sourceUriList != null && !this.sourceUriList.isEmpty()) {
                for (Uri uri : this.sourceUriList) {
                    this.sourceUrlList.add(uri.toString());
                }
            }
        }
        return this.sourceUrlList;
    }

    public void setSourceUrlList(List<String> sourceUrlList) {
        this.sourceUrlList = sourceUrlList;
    }

    public void setSourceUriList(List<Uri> sourceUriList) {
        this.sourceUriList = sourceUriList;
    }

    public IProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public void setProgressIndicator(IProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    public IIndexIndicator getIndexIndicator() {
        return this.indexIndicator;
    }

    public void setIndexIndicator(IIndexIndicator indexIndicator) {
        this.indexIndicator = indexIndicator;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public Transferee.OnTransfereeLongClickListener getLongClickListener() {
        return this.longClickListener;
    }

    public void setLongClickListener(Transferee.OnTransfereeLongClickListener longClickListener) {
        this.longClickListener = longClickListener;
    }

    public boolean isSourceEmpty() {
        return !(this.sourceUrlList != null && !this.sourceUrlList.isEmpty() || this.sourceUriList != null && !this.sourceUriList.isEmpty());
    }

    public boolean isVideoSource(int position) {
        String sourceUrl = this.sourceUrlList.get(position == -1 ? this.nowThumbnailIndex : position);
        return VIDEO_PATTERN.matcher(sourceUrl).matches();
    }

    public int getImageId() {
        return this.imageId;
    }

    public void setImageId(int imageId) {
        this.imageId = imageId;
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public void setImageView(ImageView imageView) {
        this.imageView = imageView;
    }

    public AbsListView getListView() {
        return this.listView;
    }

    public void setListView(AbsListView listView) {
        this.listView = listView;
    }

    public RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    public View getCustomView() {
        return this.customView;
    }

    public void setCustomView(View customView) {
        this.customView = customView;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public int getFooterSize() {
        return this.footerSize;
    }

    public void setFooterSize(int footerSize) {
        this.footerSize = footerSize;
    }

    public void destroy() {
        this.setImageView(null);
        this.setCustomView(null);
        this.setListView(null);
        this.setRecyclerView(null);
        this.setProgressIndicator(null);
        this.setIndexIndicator(null);
        this.setImageLoader(null);
        this.setOriginImageList(null);
        this.setSourceUrlList(null);
        this.setSourceUriList(null);
        this.setMissDrawable(null);
        this.setErrorDrawable(null);
    }

    public static class Builder {
        private int nowThumbnailIndex;
        private int offscreenPageLimit;
        private int missPlaceHolder;
        private int errorPlaceHolder;
        private int backgroundColor;
        private long duration;
        private boolean justLoadHitPage = false;
        private boolean enableDragClose = true;
        private boolean enableDragHide = true;
        private boolean enableDragPause = false;
        private boolean enableHideThumb = true;
        private boolean enableScrollingWithPageChange = false;
        private boolean autoAdjustDirection = true;
        private Drawable missDrawable;
        private Drawable errorDrawable;
        private List<String> sourceUrlList;
        private List<Uri> sourceUriList;
        private List<ImageView> originImageList;
        private IProgressIndicator progressIndicator;
        private IIndexIndicator indexIndicator;
        private ImageLoader imageLoader;
        private View customView;
        @IdRes
        private int imageId;
        private ImageView imageView;
        private AbsListView listView;
        private RecyclerView recyclerView;
        private int headerSize;
        private int footerSize;
        private Transferee.OnTransfereeLongClickListener longClickListener;

        public Builder setNowThumbnailIndex(int nowThumbnailIndex) {
            this.nowThumbnailIndex = nowThumbnailIndex;
            return this;
        }

        public Builder setOffscreenPageLimit(int offscreenPageLimit) {
            this.offscreenPageLimit = offscreenPageLimit;
            return this;
        }

        public Builder setMissPlaceHolder(int missPlaceHolder) {
            this.missPlaceHolder = missPlaceHolder;
            return this;
        }

        public Builder setErrorPlaceHolder(int errorPlaceHolder) {
            this.errorPlaceHolder = errorPlaceHolder;
            return this;
        }

        public Builder setBackgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder enableJustLoadHitPage(boolean justLoadHitPage) {
            this.justLoadHitPage = justLoadHitPage;
            return this;
        }

        public Builder enableDragClose(boolean enableDragClose) {
            this.enableDragClose = enableDragClose;
            return this;
        }

        public Builder enableDragHide(boolean enableDragHide) {
            this.enableDragHide = enableDragHide;
            return this;
        }

        public Builder enableDragPause(boolean enableDragPause) {
            this.enableDragPause = enableDragPause;
            return this;
        }

        public Builder enableHideThumb(boolean enableHideThumb) {
            this.enableHideThumb = enableHideThumb;
            return this;
        }

        public Builder enableScrollingWithPageChange(boolean enableScrollingWithPageChange) {
            this.enableScrollingWithPageChange = enableScrollingWithPageChange;
            return this;
        }

        public Builder autoAdjustDirection(boolean autoAdjustDirection) {
            this.autoAdjustDirection = autoAdjustDirection;
            return this;
        }

        public Builder setMissDrawable(Drawable missDrawable) {
            this.missDrawable = missDrawable;
            return this;
        }

        public Builder setErrorDrawable(Drawable errorDrawable) {
            this.errorDrawable = errorDrawable;
            return this;
        }

        public Builder setSourceUrlList(List<String> sourceUrlList) {
            this.sourceUrlList = sourceUrlList;
            return this;
        }

        public Builder setSourceUriList(List<Uri> sourceUriList) {
            this.sourceUriList = sourceUriList;
            return this;
        }

        public Builder setOriginImageList(List<ImageView> originImageList) {
            this.originImageList = originImageList;
            return this;
        }

        public Builder setProgressIndicator(IProgressIndicator progressIndicator) {
            this.progressIndicator = progressIndicator;
            return this;
        }

        public Builder setIndexIndicator(IIndexIndicator indexIndicator) {
            this.indexIndicator = indexIndicator;
            return this;
        }

        public Builder setImageLoader(ImageLoader imageLoader) {
            this.imageLoader = imageLoader;
            return this;
        }

        public Builder setOnLongClickListener(Transferee.OnTransfereeLongClickListener listener) {
            this.longClickListener = listener;
            return this;
        }

        public Builder setCustomView(View customView) {
            this.customView = customView;
            return this;
        }

        public TransferConfig bindListView(AbsListView listView, int imageId) {
            this.listView = listView;
            this.imageId = imageId;
            return this.create();
        }

        public TransferConfig bindListView(AbsListView listView, int headerSize, int footerSize, int imageId) {
            this.listView = listView;
            this.headerSize = headerSize;
            this.footerSize = footerSize;
            this.imageId = imageId;
            return this.create();
        }

        public TransferConfig bindRecyclerView(RecyclerView recyclerView, int imageId) {
            this.recyclerView = recyclerView;
            this.imageId = imageId;
            return this.create();
        }

        public TransferConfig bindRecyclerView(RecyclerView recyclerView, int headerSize, int footerSize, int imageId) {
            this.recyclerView = recyclerView;
            this.headerSize = headerSize;
            this.footerSize = footerSize;
            this.imageId = imageId;
            return this.create();
        }

        public TransferConfig bindImageView(ImageView imageView) {
            this.imageView = imageView;
            return this.create();
        }

        public TransferConfig bindImageView(ImageView imageView, String sourceUrl) {
            this.imageView = imageView;
            this.sourceUrlList = new ArrayList<String>();
            this.sourceUrlList.add(sourceUrl);
            return this.create();
        }

        public TransferConfig create() {
            TransferConfig config = new TransferConfig();
            config.setNowThumbnailIndex(this.nowThumbnailIndex);
            config.setOffscreenPageLimit(this.offscreenPageLimit);
            config.setMissPlaceHolder(this.missPlaceHolder);
            config.setErrorPlaceHolder(this.errorPlaceHolder);
            config.setBackgroundColor(this.backgroundColor);
            config.setDuration(this.duration);
            config.enableJustLoadHitPage(this.justLoadHitPage);
            config.enableDragClose(this.enableDragClose);
            config.enableDragHide(this.enableDragHide);
            config.enableDragPause(this.enableDragPause);
            config.enableHideThumb(this.enableHideThumb);
            config.enableScrollingWithPageChange(this.enableScrollingWithPageChange);
            config.setMissDrawable(this.missDrawable);
            config.setErrorDrawable(this.errorDrawable);
            config.setSourceUrlList(this.sourceUrlList);
            config.setSourceUriList(this.sourceUriList);
            config.setOriginImageList(this.originImageList);
            config.setProgressIndicator(this.progressIndicator);
            config.setIndexIndicator(this.indexIndicator);
            config.setImageLoader(this.imageLoader);
            config.setCustomView(this.customView);
            config.setImageId(this.imageId);
            config.setImageView(this.imageView);
            config.setListView(this.listView);
            config.setRecyclerView(this.recyclerView);
            config.setHeaderSize(this.headerSize);
            config.setFooterSize(this.footerSize);
            config.setLongClickListener(this.longClickListener);
            return config;
        }
    }
}

