/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import com.hitomi.tilibrary.transfer.OriginalViewHelper;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.view.image.TransferImage;
import com.hitomi.tilibrary.view.video.ExoVideoView;
import java.util.List;

public class TransferChangeListener
extends ViewPager.SimpleOnPageChangeListener {
    private static final String TAG = "TransferChangeListener";
    private TransferLayout transfer;
    private TransferConfig transConfig;
    private int selectedPos;

    TransferChangeListener(TransferLayout transfer, TransferConfig transConfig) {
        this.transfer = transfer;
        this.transConfig = transConfig;
    }

    void updateConfig(TransferConfig config) {
        this.transConfig = config;
    }

    public void onPageSelected(final int position) {
        this.selectedPos = position;
        this.transConfig.setNowThumbnailIndex(position);
        if (this.transConfig.isJustLoadHitPage()) {
            this.transfer.loadSourceViewOffset(position, 0);
        } else {
            for (int i = 1; i <= this.transConfig.getOffscreenPageLimit(); ++i) {
                this.transfer.loadSourceViewOffset(position, i);
            }
        }
        this.bindOperationListener(position);
        this.controlThumbHide(position);
        if (this.controlScrollingWithPageChange(position)) {
            this.transfer.post(new Runnable(){

                @Override
                public void run() {
                    TransferChangeListener.this.controlThumbHide(position);
                }
            });
        }
    }

    public void onPageScrollStateChanged(int state) {
        super.onPageScrollStateChanged(state);
        if (0 == state) {
            this.controlViewState(this.selectedPos);
        }
    }

    private int[] calcFirstAndLastVisiblePos(int originFirstPos, int originLastPos, int itemSize) {
        int headerSize = this.transConfig.getHeaderSize();
        int footerSize = this.transConfig.getFooterSize();
        int contentSize = itemSize - headerSize - footerSize;
        int firstVisiblePos = originFirstPos;
        firstVisiblePos = firstVisiblePos < headerSize ? 0 : firstVisiblePos - headerSize;
        int lastVisiblePos = originLastPos;
        lastVisiblePos = lastVisiblePos > contentSize ? contentSize - 1 : lastVisiblePos - headerSize;
        return new int[]{firstVisiblePos, lastVisiblePos};
    }

    private boolean controlScrollingWithPageChange(int position) {
        if (!this.transConfig.isEnableScrollingWithPageChange()) {
            return false;
        }
        RecyclerView recyclerView = this.transConfig.getRecyclerView();
        AbsListView absListView = this.transConfig.getListView();
        if (recyclerView == null && absListView == null) {
            return false;
        }
        AbsListView scrollView = recyclerView == null ? absListView : recyclerView;
        int firstVisiblePos = -1;
        int lastVisiblePos = -1;
        if (recyclerView != null) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager) {
                LinearLayoutManager linearLayManager = (LinearLayoutManager)layoutManager;
                int[] posArray = this.calcFirstAndLastVisiblePos(linearLayManager.findFirstVisibleItemPosition(), linearLayManager.findLastVisibleItemPosition(), linearLayManager.getItemCount());
                firstVisiblePos = posArray[0];
                lastVisiblePos = posArray[1];
            }
        } else {
            int[] posArray = this.calcFirstAndLastVisiblePos(absListView.getFirstVisiblePosition(), absListView.getLastVisiblePosition(), absListView.getCount());
            firstVisiblePos = posArray[0];
            lastVisiblePos = posArray[1];
        }
        Log.e((String)TAG, (String)String.format("position = %s, firstVisiblePos = %s, lastVisiblePos = %s", position, firstVisiblePos, lastVisiblePos));
        if (position >= firstVisiblePos && position <= lastVisiblePos) {
            return false;
        }
        int realPos = position + this.transConfig.getHeaderSize();
        if (position < firstVisiblePos) {
            if (recyclerView != null) {
                recyclerView.scrollToPosition(realPos);
            } else {
                absListView.setSelection(realPos);
            }
        } else if (recyclerView != null) {
            recyclerView.scrollToPosition(realPos);
        } else {
            absListView.setSelection(realPos);
        }
        scrollView.post(new Runnable(){

            @Override
            public void run() {
                OriginalViewHelper.getInstance().fillOriginImages(TransferChangeListener.this.transConfig);
            }
        });
        return true;
    }

    private void controlThumbHide(int position) {
        if (!this.transConfig.isEnableHideThumb()) {
            return;
        }
        List<ImageView> originImageList = this.transConfig.getOriginImageList();
        for (int i = 0; i < originImageList.size(); ++i) {
            ImageView currOriginImage = originImageList.get(i);
            if (currOriginImage == null) continue;
            currOriginImage.setVisibility(i == position ? 4 : 0);
        }
    }

    private void controlViewState(int position) {
        SparseArray<FrameLayout> cacheItems = this.transfer.transAdapter.getCacheItems();
        for (int i = 0; i < cacheItems.size(); ++i) {
            TransferImage imageView;
            int key = cacheItems.keyAt(i);
            View view = ((FrameLayout)cacheItems.get(key)).getChildAt(0);
            if (view instanceof ExoVideoView) {
                ExoVideoView videoView = (ExoVideoView)view;
                if (key == position) {
                    videoView.play();
                    continue;
                }
                videoView.reset();
                continue;
            }
            if (!(view instanceof TransferImage) || (imageView = (TransferImage)view).isPhotoNotChanged()) continue;
            imageView.reset();
        }
    }

    void bindOperationListener(final int position) {
        FrameLayout parent = this.transfer.transAdapter.getParentItem(position);
        if (parent == null || parent.getChildAt(0) == null) {
            return;
        }
        final View contentView = parent.getChildAt(0);
        Object bindClickView = contentView instanceof TransferImage ? contentView : parent;
        if (!bindClickView.hasOnClickListeners()) {
            bindClickView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TransferChangeListener.this.transfer.dismiss(position);
                }
            });
        }
        if (contentView instanceof TransferImage && this.transConfig.getLongClickListener() != null) {
            contentView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    TransferImage targetImage = (TransferImage)contentView;
                    String sourceUrl = TransferChangeListener.this.transConfig.getSourceUrlList().get(position);
                    TransferChangeListener.this.transConfig.getLongClickListener().onLongClick((ImageView)targetImage, sourceUrl, position);
                    return false;
                }
            });
        }
    }
}

