/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.utils;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import java.util.HashSet;
import java.util.Set;

public class AppManager
implements Application.ActivityLifecycleCallbacks {
    private int foregroundCount;
    private final Set<OnAppStateChangeListener> listenerSet = new HashSet<OnAppStateChangeListener>();

    public static AppManager getInstance() {
        return SingletonHolder.instance;
    }

    public void init(Application app) {
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void register(OnAppStateChangeListener listener) {
        this.listenerSet.add(listener);
    }

    public void unregister(OnAppStateChangeListener listener) {
        this.listenerSet.remove(listener);
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(@NonNull Activity activity) {
        ++this.foregroundCount;
        if (this.foregroundCount == 1) {
            for (OnAppStateChangeListener listener : this.listenerSet) {
                listener.onForeground();
            }
        }
    }

    public void onActivityResumed(@NonNull Activity activity) {
    }

    public void onActivityPaused(@NonNull Activity activity) {
    }

    public void onActivityStopped(@NonNull Activity activity) {
        --this.foregroundCount;
        if (this.foregroundCount == 0) {
            for (OnAppStateChangeListener listener : this.listenerSet) {
                listener.onBackground();
            }
        }
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
    }

    public void clear() {
        this.listenerSet.clear();
    }

    public static interface OnAppStateChangeListener {
        public void onForeground();

        public void onBackground();
    }

    private static class SingletonHolder {
        static final AppManager instance = new AppManager();

        private SingletonHolder() {
        }
    }
}

