/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.gyf.immersionbar.ImmersionBar;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.transfer.RemoteThumbState;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import pl.droidsonroids.gif.GifDrawable;

abstract class TransferState {
    static final int TYPE_PLACEHOLDER_MISS = 1;
    static final int TYPE_PLACEHOLDER_ERROR = 2;
    protected TransferLayout transfer;

    TransferState(TransferLayout transfer) {
        this.transfer = transfer;
    }

    private int[] getViewLocation(View view) {
        int[] location = new int[2];
        view.getLocationInWindow(location);
        return location;
    }

    @NonNull
    TransferImage createTransferImage(ImageView originImage, boolean bindListener) {
        TransferConfig config = this.transfer.getTransConfig();
        int[] location = this.getViewLocation((View)originImage);
        TransferImage transImage = new TransferImage(this.transfer.getContext());
        transImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        transImage.setOriginalInfo(location[0], location[1], originImage.getWidth(), originImage.getHeight());
        transImage.setDuration(config.getDuration());
        transImage.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (bindListener) {
            transImage.setOnTransferListener(this.transfer.transListener);
        }
        return transImage;
    }

    void transformThumbnail(String imageUrl, TransferImage transImage, boolean in) {
        TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        if (this instanceof RemoteThumbState) {
            if (imageLoader.getCache(imageUrl) != null) {
                this.loadThumbnail(imageUrl, transImage, in);
            } else {
                transImage.setImageDrawable(config.getMissDrawable(this.transfer.getContext()));
                if (in) {
                    transImage.transformIn();
                } else {
                    transImage.transformOut();
                }
            }
        } else {
            this.loadThumbnail(imageUrl, transImage, in);
        }
    }

    void startPreview(TransferImage targetImage, File source, String imgUrl, int pos) {
        targetImage.enableGesture();
        if (imgUrl.endsWith("gif")) {
            File cache;
            File file = cache = source == null ? this.transfer.getTransConfig().getImageLoader().getCache(imgUrl) : source;
            if (cache != null) {
                try {
                    targetImage.setImageDrawable((Drawable)new GifDrawable(cache.getPath()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    void clipTargetImage(TransferImage targetImage, Drawable originDrawable, int[] clipSize) {
        if (!(this.transfer.getContext() instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)this.transfer.getContext();
        DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels + ImmersionBar.getNotchHeight((Activity)activity);
        targetImage.setOriginalInfo(originDrawable, clipSize[0], clipSize[1], width, height);
        targetImage.transClip();
    }

    void loadFailedDrawable(TransferImage targetImage, int pos) {
        Drawable errorDrawable = this.transfer.getTransConfig().getErrorDrawable(this.transfer.getContext());
        this.clipTargetImage(targetImage, errorDrawable, this.getPlaceholderClipSize(pos, 2));
        targetImage.setImageDrawable(errorDrawable);
    }

    int[] getPlaceholderClipSize(int position, int placeholderType) {
        ImageView originImage;
        int[] clipSize = new int[2];
        TransferConfig transConfig = this.transfer.getTransConfig();
        List<ImageView> originImageList = transConfig.getOriginImageList();
        ImageView imageView = originImage = originImageList.isEmpty() ? null : originImageList.get(position);
        if (originImage == null) {
            for (ImageView imageView2 : originImageList) {
                if (imageView2 == null) continue;
                originImage = imageView2;
                break;
            }
        }
        if (originImage == null) {
            Drawable defaultDrawable = placeholderType == 1 ? transConfig.getMissDrawable(this.transfer.getContext()) : transConfig.getErrorDrawable(this.transfer.getContext());
            clipSize[0] = defaultDrawable.getIntrinsicWidth();
            clipSize[1] = defaultDrawable.getIntrinsicHeight();
        } else {
            clipSize[0] = originImage.getWidth();
            clipSize[1] = originImage.getHeight();
        }
        return clipSize;
    }

    private void loadThumbnail(String imageUrl, TransferImage transImage, boolean in) {
        Bitmap thumbBitmap;
        TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        File thumbFile = imageLoader.getCache(imageUrl);
        Bitmap bitmap = thumbBitmap = thumbFile != null ? BitmapFactory.decodeFile((String)thumbFile.getAbsolutePath()) : null;
        if (thumbBitmap == null) {
            transImage.setImageDrawable(config.getMissDrawable(this.transfer.getContext()));
        } else {
            transImage.setImageBitmap(thumbBitmap);
        }
        if (in) {
            transImage.transformIn();
        } else {
            transImage.transformOut();
        }
    }

    public abstract void prepareTransfer(TransferImage var1, int var2);

    public abstract TransferImage transferIn(int var1);

    public abstract void transferLoad(int var1);

    public abstract TransferImage transferOut(int var1);
}

