/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ImageView;
import androidx.annotation.IdRes;
import androidx.recyclerview.widget.RecyclerView;
import com.hitomi.tilibrary.R;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.style.IIndexIndicator;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.Transferee;
import java.util.ArrayList;
import java.util.List;

public final class TransferConfig {
    private int nowThumbnailIndex;
    private int offscreenPageLimit;
    private int missPlaceHolder;
    private int errorPlaceHolder;
    private int backgroundColor;
    private long duration;
    private boolean justLoadHitImage;
    private boolean enableDragClose;
    private boolean enableDragHide;
    private Drawable missDrawable;
    private Drawable errorDrawable;
    private List<ImageView> originImageList;
    private List<String> sourceImageList;
    private List<Uri> sourceUriList;
    private List<String> thumbnailImageList;
    private IProgressIndicator progressIndicator;
    private IIndexIndicator indexIndicator;
    private ImageLoader imageLoader;
    @IdRes
    private int imageId;
    private ImageView imageView;
    private AbsListView listView;
    private RecyclerView recyclerView;
    private View customView;
    private int headerSize;
    private int footerSize;
    private Transferee.OnTransfereeLongClickListener longClickListener;

    public static Builder build() {
        return new Builder();
    }

    public int getNowThumbnailIndex() {
        return this.nowThumbnailIndex;
    }

    public void setNowThumbnailIndex(int nowThumbnailIndex) {
        this.nowThumbnailIndex = nowThumbnailIndex;
    }

    public int getOffscreenPageLimit() {
        return this.offscreenPageLimit;
    }

    public void setOffscreenPageLimit(int offscreenPageLimit) {
        this.offscreenPageLimit = offscreenPageLimit;
    }

    public int getMissPlaceHolder() {
        return this.missPlaceHolder;
    }

    public void setMissPlaceHolder(int missPlaceHolder) {
        this.missPlaceHolder = missPlaceHolder;
    }

    public int getErrorPlaceHolder() {
        return this.errorPlaceHolder;
    }

    public void setErrorPlaceHolder(int errorPlaceHolder) {
        this.errorPlaceHolder = errorPlaceHolder;
    }

    public int getBackgroundColor() {
        return this.backgroundColor == 0 ? -16777216 : this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean isJustLoadHitImage() {
        return this.justLoadHitImage;
    }

    public void setJustLoadHitImage(boolean justLoadHitImage) {
        this.justLoadHitImage = justLoadHitImage;
    }

    public boolean isEnableDragClose() {
        return this.enableDragClose;
    }

    public void enableDragClose(boolean enableDragClose) {
        this.enableDragClose = enableDragClose;
    }

    public void enableDragHide(boolean enableDragHide) {
        this.enableDragHide = enableDragHide;
    }

    public boolean isEnableDragHide() {
        return this.enableDragHide;
    }

    public Drawable getMissDrawable(Context context) {
        if (this.missDrawable != null) {
            return this.missDrawable;
        }
        if (this.missPlaceHolder != 0) {
            return context.getResources().getDrawable(this.missPlaceHolder);
        }
        return context.getResources().getDrawable(R.drawable.ic_empty_photo);
    }

    public void setMissDrawable(Drawable missDrawable) {
        this.missDrawable = missDrawable;
    }

    public Drawable getErrorDrawable(Context context) {
        if (this.errorDrawable != null) {
            return this.errorDrawable;
        }
        if (this.errorPlaceHolder != 0) {
            return context.getResources().getDrawable(this.errorPlaceHolder);
        }
        return context.getResources().getDrawable(R.drawable.ic_empty_photo);
    }

    public void setErrorDrawable(Drawable errorDrawable) {
        this.errorDrawable = errorDrawable;
    }

    List<ImageView> getOriginImageList() {
        return this.originImageList == null ? new ArrayList() : this.originImageList;
    }

    void setOriginImageList(List<ImageView> originImageList) {
        this.originImageList = originImageList;
    }

    public List<String> getSourceImageList() {
        if (this.sourceImageList == null || this.sourceImageList.isEmpty()) {
            this.sourceImageList = new ArrayList<String>();
            for (Uri uri : this.sourceUriList) {
                this.sourceImageList.add(uri.toString());
            }
        }
        return this.sourceImageList;
    }

    public void setSourceImageList(List<String> sourceImageList) {
        this.sourceImageList = sourceImageList;
    }

    public List<Uri> getSourceUriList() {
        return this.sourceUriList;
    }

    public void setSourceUriList(List<Uri> sourceUriList) {
        this.sourceUriList = sourceUriList;
    }

    public List<String> getThumbnailImageList() {
        return this.thumbnailImageList;
    }

    public void setThumbnailImageList(List<String> thumbnailImageList) {
        this.thumbnailImageList = thumbnailImageList;
    }

    public IProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public void setProgressIndicator(IProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    public IIndexIndicator getIndexIndicator() {
        return this.indexIndicator;
    }

    public void setIndexIndicator(IIndexIndicator indexIndicator) {
        this.indexIndicator = indexIndicator;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public Transferee.OnTransfereeLongClickListener getLongClickListener() {
        return this.longClickListener;
    }

    public void setLongClickListener(Transferee.OnTransfereeLongClickListener longClickListener) {
        this.longClickListener = longClickListener;
    }

    public boolean isSourceEmpty() {
        return !(this.sourceImageList != null && !this.sourceImageList.isEmpty() || this.sourceUriList != null && !this.sourceUriList.isEmpty());
    }

    public boolean isThumbnailEmpty() {
        return this.thumbnailImageList == null || this.thumbnailImageList.isEmpty();
    }

    public int getImageId() {
        return this.imageId;
    }

    public void setImageId(int imageId) {
        this.imageId = imageId;
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public void setImageView(ImageView imageView) {
        this.imageView = imageView;
    }

    public AbsListView getListView() {
        return this.listView;
    }

    public void setListView(AbsListView listView) {
        this.listView = listView;
    }

    public RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    public View getCustomView() {
        return this.customView;
    }

    public void setCustomView(View customView) {
        this.customView = customView;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public int getFooterSize() {
        return this.footerSize;
    }

    public void setFooterSize(int footerSize) {
        this.footerSize = footerSize;
    }

    public static class Builder {
        private int nowThumbnailIndex;
        private int offscreenPageLimit;
        private int missPlaceHolder;
        private int errorPlaceHolder;
        private int backgroundColor;
        private long duration;
        private boolean justLoadHitImage;
        private boolean enableDragClose = true;
        private boolean enableDragHide = true;
        private Drawable missDrawable;
        private Drawable errorDrawable;
        private List<String> sourceImageList;
        private List<Uri> sourceUriList;
        private List<String> thumbnailImageList;
        private IProgressIndicator progressIndicator;
        private IIndexIndicator indexIndicator;
        private ImageLoader imageLoader;
        private View customView;
        @IdRes
        private int imageId;
        private ImageView imageView;
        private AbsListView listView;
        private RecyclerView recyclerView;
        private int headerSize;
        private int footerSize;
        private Transferee.OnTransfereeLongClickListener longClickListener;

        public Builder setNowThumbnailIndex(int nowThumbnailIndex) {
            this.nowThumbnailIndex = nowThumbnailIndex;
            return this;
        }

        public Builder setOffscreenPageLimit(int offscreenPageLimit) {
            this.offscreenPageLimit = offscreenPageLimit;
            return this;
        }

        public Builder setMissPlaceHolder(int missPlaceHolder) {
            this.missPlaceHolder = missPlaceHolder;
            return this;
        }

        public Builder setErrorPlaceHolder(int errorPlaceHolder) {
            this.errorPlaceHolder = errorPlaceHolder;
            return this;
        }

        public Builder setBackgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setJustLoadHitImage(boolean justLoadHitImage) {
            this.justLoadHitImage = justLoadHitImage;
            return this;
        }

        public Builder enableDragClose(boolean enableDragClose) {
            this.enableDragClose = enableDragClose;
            return this;
        }

        public Builder enableDragHide(boolean enableDragHide) {
            this.enableDragHide = enableDragHide;
            return this;
        }

        public Builder setMissDrawable(Drawable missDrawable) {
            this.missDrawable = missDrawable;
            return this;
        }

        public Builder setErrorDrawable(Drawable errorDrawable) {
            this.errorDrawable = errorDrawable;
            return this;
        }

        public Builder setSourceImageList(List<String> sourceImageList) {
            this.sourceImageList = sourceImageList;
            return this;
        }

        public Builder setSourceUriList(List<Uri> sourceUriList) {
            this.sourceUriList = sourceUriList;
            return this;
        }

        public Builder setProgressIndicator(IProgressIndicator progressIndicator) {
            this.progressIndicator = progressIndicator;
            return this;
        }

        public Builder setIndexIndicator(IIndexIndicator indexIndicator) {
            this.indexIndicator = indexIndicator;
            return this;
        }

        public Builder setImageLoader(ImageLoader imageLoader) {
            this.imageLoader = imageLoader;
            return this;
        }

        public Builder setOnLongClickListener(Transferee.OnTransfereeLongClickListener listener) {
            this.longClickListener = listener;
            return this;
        }

        public Builder setCustomView(View customView) {
            this.customView = customView;
            return this;
        }

        public TransferConfig bindListView(AbsListView listView, int imageId) {
            this.listView = listView;
            this.imageId = imageId;
            return this.create();
        }

        public TransferConfig bindListView(AbsListView listView, int headerSize, int footerSize, int imageId) {
            this.listView = listView;
            this.headerSize = headerSize;
            this.footerSize = footerSize;
            this.imageId = imageId;
            return this.create();
        }

        public TransferConfig bindRecyclerView(RecyclerView recyclerView, int imageId) {
            this.recyclerView = recyclerView;
            this.imageId = imageId;
            return this.create();
        }

        public TransferConfig bindRecyclerView(RecyclerView recyclerView, int headerSize, int footerSize, int imageId) {
            this.recyclerView = recyclerView;
            this.headerSize = headerSize;
            this.footerSize = footerSize;
            this.imageId = imageId;
            return this.create();
        }

        public TransferConfig bindImageView(ImageView imageView, List<String> sourceImageList) {
            this.imageView = imageView;
            this.sourceImageList = sourceImageList;
            return this.create();
        }

        public TransferConfig bindImageView(ImageView imageView, String sourceUrl) {
            this.imageView = imageView;
            this.sourceImageList = new ArrayList<String>();
            this.sourceImageList.add(sourceUrl);
            return this.create();
        }

        public TransferConfig create() {
            TransferConfig config = new TransferConfig();
            config.setNowThumbnailIndex(this.nowThumbnailIndex);
            config.setOffscreenPageLimit(this.offscreenPageLimit);
            config.setMissPlaceHolder(this.missPlaceHolder);
            config.setErrorPlaceHolder(this.errorPlaceHolder);
            config.setBackgroundColor(this.backgroundColor);
            config.setDuration(this.duration);
            config.setJustLoadHitImage(this.justLoadHitImage);
            config.enableDragClose(this.enableDragClose);
            config.enableDragHide(this.enableDragHide);
            config.setMissDrawable(this.missDrawable);
            config.setErrorDrawable(this.errorDrawable);
            config.setSourceImageList(this.sourceImageList);
            config.setSourceUriList(this.sourceUriList);
            config.setProgressIndicator(this.progressIndicator);
            config.setIndexIndicator(this.indexIndicator);
            config.setImageLoader(this.imageLoader);
            config.setCustomView(this.customView);
            config.setImageId(this.imageId);
            config.setImageView(this.imageView);
            config.setListView(this.listView);
            config.setRecyclerView(this.recyclerView);
            config.setHeaderSize(this.headerSize);
            config.setFooterSize(this.footerSize);
            config.setLongClickListener(this.longClickListener);
            return config;
        }
    }
}

