/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;
import java.util.List;

@Deprecated
class RemoteThumbState
extends TransferState {
    RemoteThumbState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(TransferImage transImage, int position) {
        String imgUrl;
        TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        if (imageLoader.getCache(imgUrl = config.getThumbnailImageList().get(position)) != null) {
            imageLoader.showImage(imgUrl, (ImageView)transImage, config.getMissDrawable(this.transfer.getContext()), null);
        } else {
            transImage.setImageDrawable(config.getMissDrawable(this.transfer.getContext()));
        }
    }

    @Override
    public TransferImage createTransferIn(int position) {
        TransferConfig config = this.transfer.getTransConfig();
        TransferImage transImage = this.createTransferImage(config.getOriginImageList().get(position));
        this.transformThumbnail(config.getThumbnailImageList().get(position), transImage, true);
        this.transfer.addView((View)transImage, 1);
        return transImage;
    }

    @Override
    public void transferLoad(final int position) {
        final TransferConfig config = this.transfer.getTransConfig();
        final TransferImage targetImage = this.transfer.transAdapter.getImageItem(position);
        ImageLoader imageLoader = config.getImageLoader();
        if (config.isJustLoadHitImage()) {
            this.loadSourceImage(targetImage.getDrawable(), position, targetImage);
        } else {
            String thumbUrl = config.getThumbnailImageList().get(position);
            if (imageLoader.getCache(thumbUrl) != null) {
                imageLoader.loadImageAsync(thumbUrl, new ImageLoader.ThumbnailCallback(){

                    @Override
                    public void onFinish(Bitmap bitmap) {
                        Object placeholder = null;
                        placeholder = bitmap == null ? config.getMissDrawable(RemoteThumbState.this.transfer.getContext()) : new BitmapDrawable(RemoteThumbState.this.transfer.getContext().getResources(), bitmap);
                        RemoteThumbState.this.loadSourceImage(placeholder, position, targetImage);
                    }
                });
            } else {
                this.loadSourceImage(config.getMissDrawable(this.transfer.getContext()), position, targetImage);
            }
        }
    }

    private void loadSourceImage(Drawable drawable2, final int position, final TransferImage targetImage) {
        final TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        final String sourceUrl = config.getSourceImageList().get(position);
        final IProgressIndicator progressIndicator = config.getProgressIndicator();
        progressIndicator.attach(position, this.transfer.transAdapter.getParentItem(position));
        imageLoader.showImage(sourceUrl, (ImageView)targetImage, drawable2, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
                progressIndicator.onStart(position);
            }

            @Override
            public void onProgress(int progress) {
                progressIndicator.onProgress(position, progress);
            }

            @Override
            public void onDelivered(int status, File source) {
                progressIndicator.onFinish(position);
                switch (status) {
                    case 1: {
                        targetImage.enable();
                        RemoteThumbState.this.transfer.bindOnOperationListener((ImageView)targetImage, sourceUrl, position);
                        break;
                    }
                    case 0: {
                        targetImage.setImageDrawable(config.getErrorDrawable(RemoteThumbState.this.transfer.getContext()));
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        TransferImage transImage = null;
        TransferConfig config = this.transfer.getTransConfig();
        List<ImageView> originImageList = config.getOriginImageList();
        if (position <= originImageList.size() - 1 && originImageList.get(position) != null) {
            transImage = this.createTransferImage(originImageList.get(position));
            this.transformThumbnail(config.getThumbnailImageList().get(position), transImage, false);
            this.transfer.addView((View)transImage, 1);
        }
        return transImage;
    }
}

