/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.style.progress;

import android.content.Context;
import android.graphics.Color;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.filippudak.ProgressPieView.ProgressPieView;
import com.hitomi.tilibrary.style.IProgressIndicator;
import java.util.Locale;

public class ProgressPieIndicator
implements IProgressIndicator {
    private SparseArray<ProgressPieView> progressPieArray = new SparseArray();

    private int dip2Px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @Override
    public void attach(int position, FrameLayout parent) {
        Context context = parent.getContext();
        int progressSize = this.dip2Px(context, 50.0f);
        FrameLayout.LayoutParams progressLp = new FrameLayout.LayoutParams(progressSize, progressSize);
        progressLp.gravity = 17;
        ProgressPieView progressPieView = new ProgressPieView(context);
        progressPieView.setTextSize(13);
        progressPieView.setStrokeWidth(1);
        progressPieView.setTextColor(-1);
        progressPieView.setProgressFillType(0);
        progressPieView.setBackgroundColor(0);
        progressPieView.setProgressColor(Color.parseColor((String)"#BBFFFFFF"));
        progressPieView.setStrokeColor(-1);
        progressPieView.setLayoutParams((ViewGroup.LayoutParams)progressLp);
        parent.addView((View)progressPieView, parent.getChildCount());
        this.progressPieArray.put(position, (Object)progressPieView);
    }

    @Override
    public void hideView(int position) {
        ProgressPieView progressPieView = (ProgressPieView)this.progressPieArray.get(position);
        if (progressPieView != null) {
            progressPieView.setVisibility(8);
        }
    }

    @Override
    public void onStart(int position) {
        ProgressPieView progressPieView = (ProgressPieView)this.progressPieArray.get(position);
        progressPieView.setProgress(0);
        progressPieView.setText(String.format(Locale.getDefault(), "%d%%", 0));
    }

    @Override
    public void onProgress(int position, int progress) {
        if (progress < 0 || progress > 100) {
            return;
        }
        ProgressPieView progressPieView = (ProgressPieView)this.progressPieArray.get(position);
        progressPieView.setProgress(progress);
        progressPieView.setText(String.format(Locale.getDefault(), "%d%%", progress));
    }

    @Override
    public void onFinish(int position) {
        ProgressPieView progressPieView = (ProgressPieView)this.progressPieArray.get(position);
        if (progressPieView == null) {
            return;
        }
        ViewGroup vg = (ViewGroup)progressPieView.getParent();
        if (vg != null) {
            vg.removeView((View)progressPieView);
        }
    }
}

