/*
 * Decompiled with CFR 0.152.
 */
package com.hendrix.pdfmyxml.viewRenderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.LayoutInflater;
import android.view.View;
import com.hendrix.pdfmyxml.utils.MeasureUtils;
import com.hendrix.pdfmyxml.viewRenderer.IViewRenderer;

public abstract class AbstractViewRenderer
implements IViewRenderer {
    protected View _view = null;
    protected Context _ctx = null;
    private Bitmap _bmp = null;
    private boolean _flagReuseBitmap = false;
    private Object _data = null;

    public AbstractViewRenderer(Context ctx, int layoutResId) {
        this(ctx, LayoutInflater.from((Context)ctx).inflate(layoutResId, null));
    }

    public AbstractViewRenderer(Context ctx, View view) {
        this.attachContext(ctx);
        this._view = view;
    }

    protected AbstractViewRenderer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attachContext(Context ctx) {
        this._ctx = ctx;
    }

    @Override
    public final Bitmap render(Bitmap bitmap, int width, int height) {
        this.validate();
        this.initView(this.getView());
        View view = this.getView();
        int specWidth = View.MeasureSpec.makeMeasureSpec((int)width, (int)(width == 0 ? 0 : 0x40000000));
        int specHeight = View.MeasureSpec.makeMeasureSpec((int)height, (int)(height == 0 ? 0 : 0x40000000));
        view.measure(specWidth, specHeight);
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        Bitmap b = bitmap;
        Canvas c = new Canvas(b);
        c.translate((float)(-view.getScrollX()), (float)(-view.getScrollY()));
        view.draw(c);
        this._bmp = b;
        return this._bmp;
    }

    @Override
    public final Bitmap render(int width, int height) {
        Bitmap b;
        this.validate();
        this.initView(this.getView());
        View view = this.getView();
        int specWidth = View.MeasureSpec.makeMeasureSpec((int)(width == 0 ? -2 : width), (int)(width == 0 ? 0 : 0x40000000));
        int specHeight = View.MeasureSpec.makeMeasureSpec((int)(height == 0 ? -2 : height), (int)(height == 0 ? 0 : 0x40000000));
        int a = -1;
        System.out.println("a");
        try {
            view.measure(specWidth, specHeight);
        }
        catch (NullPointerException exc) {
            exc.printStackTrace();
        }
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        if (!this._flagReuseBitmap) {
            this.disposeBitmap();
            b = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            b = this._bmp == null || this._bmp.isRecycled() ? Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : this._bmp;
            b.eraseColor(0);
        }
        Canvas c = new Canvas(b);
        c.translate((float)(-view.getScrollX()), (float)(-view.getScrollY()));
        view.draw(c);
        this._bmp = b;
        return this._bmp;
    }

    public final Bitmap render2(int width, int height) {
        Bitmap b;
        this.validate();
        this.initView(this.getView());
        View view = this.getView();
        int specWidth = View.MeasureSpec.makeMeasureSpec((int)MeasureUtils.DIPToPixels(this._ctx, width), (int)(width == 0 ? 0 : 0x40000000));
        int specHeight = View.MeasureSpec.makeMeasureSpec((int)MeasureUtils.DIPToPixels(this._ctx, height), (int)(height == 0 ? 0 : 0x40000000));
        try {
            view.measure(specWidth, specHeight);
        }
        catch (NullPointerException exc) {
            exc.printStackTrace();
        }
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        if (!this._flagReuseBitmap) {
            this.disposeBitmap();
            b = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            b = this._bmp == null || this._bmp.isRecycled() ? Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : this._bmp;
            b.eraseColor(0);
        }
        Canvas c = new Canvas(b);
        c.translate((float)(-view.getScrollX()), (float)(-view.getScrollY()));
        view.draw(c);
        this._bmp = b;
        return this._bmp;
    }

    @Override
    public Bitmap getBitmap() {
        return this._bmp;
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public int getWidth() {
        return this.getView().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getView().getHeight();
    }

    protected abstract void initView(View var1);

    private void validate() {
        if (this._ctx == null) {
            throw new IllegalArgumentException("ViewRenderer:: context was not set!!");
        }
        if (this._view == null) {
            throw new IllegalArgumentException("ViewRenderer:: view or layout resource was not set!!");
        }
    }

    public boolean isReuseBitmap() {
        return this._flagReuseBitmap;
    }

    public void setReuseBitmap(boolean flagReuseBitmap) {
        this._flagReuseBitmap = flagReuseBitmap;
    }

    @Override
    public void dispose() {
        this._bmp.recycle();
        this._view = null;
        this._ctx = null;
    }

    public void disposeBitmap() {
        if (this._bmp != null) {
            this._bmp.recycle();
        }
        this._bmp = null;
    }

    @Override
    public void setData(Object data) {
        this._data = data;
    }

    @Override
    public Object getData() {
        return this._data;
    }
}

