/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Decompressor;
import com.pdfjet.Destination;
import com.pdfjet.Font;
import com.pdfjet.ICCBlackScaled;
import com.pdfjet.Image;
import com.pdfjet.OptionalContentGroup;
import com.pdfjet.PDFobj;
import com.pdfjet.Page;
import com.pdfjet.Salsa20;
import com.pdfjet.StructElem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDF {
    private boolean eval = true;
    protected int objNumber = 0;
    protected int metadataObjNumber = 0;
    protected int outputIntentObjNumber = 0;
    protected List<Font> fonts = new ArrayList<Font>();
    protected List<Image> images = new ArrayList<Image>();
    protected List<Page> pages = new ArrayList<Page>();
    protected HashMap<String, Destination> destinations = new HashMap();
    protected List<OptionalContentGroup> groups = new ArrayList<OptionalContentGroup>();
    protected static final DecimalFormat df = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    protected int compliance = 0;
    private static final int CR_LF = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private OutputStream os = null;
    private List<Integer> objOffset = new ArrayList<Integer>();
    private String producer = "PDFjet v5.28 (http://pdfjet.com)";
    private String creationDate;
    private String createDate;
    private String title = "";
    private String subject = "";
    private String author = "";
    private int byte_count = 0;
    private int endOfLine = 0;
    private int pagesObjNumber = -1;
    private String pageLayout = null;
    private String pageMode = null;
    private String language = "en-US";

    public PDF() throws Exception {
    }

    public PDF(OutputStream outputStream) throws Exception {
        this(outputStream, 0);
    }

    public PDF(OutputStream outputStream, int n) throws Exception {
        this.os = outputStream;
        this.compliance = n;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.creationDate = simpleDateFormat.format(date);
        this.createDate = simpleDateFormat2.format(date);
        this.append("%PDF-1.5\n");
        this.append('%');
        this.append((byte)-14);
        this.append((byte)-13);
        this.append((byte)-12);
        this.append((byte)-11);
        this.append((byte)-10);
        this.append('\n');
        if (n == 1 || n == 2) {
            this.metadataObjNumber = this.addMetadataObject("", false);
            this.outputIntentObjNumber = this.addOutputIntentObject();
        }
    }

    protected void newobj() throws IOException {
        this.objOffset.add(this.byte_count);
        this.append(++this.objNumber);
        this.append(" 0 obj\n");
    }

    protected void endobj() throws IOException {
        this.append("endobj\n");
    }

    protected int addMetadataObject(String string, boolean bl) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xpacket begin='\ufeff' id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n");
        stringBuilder.append("<x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n");
        stringBuilder.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        if (bl) {
            stringBuilder.append("<rdf:Description rdf:about=\"\" xmlns:xmpRights=\"http://ns.adobe.com/xap/1.0/rights/\">\n");
            stringBuilder.append("<xmpRights:UsageTerms>\n");
            stringBuilder.append("<rdf:Alt>\n");
            stringBuilder.append("<rdf:li xml:lang=\"x-default\">\n");
            stringBuilder.append(string);
            stringBuilder.append("</rdf:li>\n");
            stringBuilder.append("</rdf:Alt>\n");
            stringBuilder.append("</xmpRights:UsageTerms>\n");
            stringBuilder.append("</rdf:Description>\n");
        } else {
            stringBuilder.append("<rdf:Description rdf:about=\"\" xmlns:pdf=\"http://ns.adobe.com/pdf/1.3/\" pdf:Producer=\"");
            stringBuilder.append(this.producer);
            stringBuilder.append("\">\n</rdf:Description>\n");
            stringBuilder.append("<rdf:Description rdf:about=\"\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n");
            stringBuilder.append("  <dc:format>application/pdf</dc:format>\n");
            stringBuilder.append("  <dc:title><rdf:Alt><rdf:li xml:lang=\"x-default\">");
            stringBuilder.append(this.title);
            stringBuilder.append("</rdf:li></rdf:Alt></dc:title>\n");
            stringBuilder.append("  <dc:creator><rdf:Seq><rdf:li>");
            stringBuilder.append(this.author);
            stringBuilder.append("</rdf:li></rdf:Seq></dc:creator>\n");
            stringBuilder.append("  <dc:description><rdf:Alt><rdf:li xml:lang=\"x-default\">");
            stringBuilder.append(this.subject);
            stringBuilder.append("</rdf:li></rdf:Alt></dc:description>\n");
            stringBuilder.append("</rdf:Description>\n");
            stringBuilder.append("<rdf:Description rdf:about=\"\" xmlns:pdfaid=\"http://www.aiim.org/pdfa/ns/id/\">\n");
            stringBuilder.append("  <pdfaid:part>1</pdfaid:part>\n");
            stringBuilder.append("  <pdfaid:conformance>B</pdfaid:conformance>\n");
            stringBuilder.append("</rdf:Description>\n");
            if (this.compliance == 2) {
                stringBuilder.append("<rdf:Description rdf:about=\"\" xmlns:pdfuaid=\"http://www.aiim.org/pdfua/ns/id/\">\n");
                stringBuilder.append("  <pdfuaid:part>1</pdfuaid:part>\n");
                stringBuilder.append("</rdf:Description>\n");
            }
            stringBuilder.append("<rdf:Description rdf:about=\"\" xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n");
            stringBuilder.append("<xmp:CreateDate>");
            stringBuilder.append(this.createDate + "Z");
            stringBuilder.append("</xmp:CreateDate>\n");
            stringBuilder.append("</rdf:Description>\n");
        }
        stringBuilder.append("</rdf:RDF>\n");
        stringBuilder.append("</x:xmpmeta>\n");
        if (!bl) {
            for (int i = 0; i < 20; ++i) {
                for (int j = 0; j < 10; ++j) {
                    stringBuilder.append("          ");
                }
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append("<?xpacket end=\"w\"?>");
        byte[] byArray = stringBuilder.toString().getBytes("UTF-8");
        this.newobj();
        this.append("<<\n");
        this.append("/Type /Metadata\n");
        this.append("/Subtype /XML\n");
        this.append("/Length ");
        this.append(byArray.length);
        this.append("\n");
        this.append(">>\n");
        this.append("stream\n");
        this.append(byArray, 0, byArray.length);
        this.append("\nendstream\n");
        this.endobj();
        return this.objNumber;
    }

    protected int addOutputIntentObject() throws Exception {
        this.newobj();
        this.append("<<\n");
        this.append("/N 3\n");
        this.append("/Length ");
        this.append(ICCBlackScaled.profile.length);
        this.append("\n");
        this.append("/Filter /FlateDecode\n");
        this.append(">>\n");
        this.append("stream\n");
        this.append(ICCBlackScaled.profile, 0, ICCBlackScaled.profile.length);
        this.append("\nendstream\n");
        this.endobj();
        this.newobj();
        this.append("<<\n");
        this.append("/Type /OutputIntent\n");
        this.append("/S /GTS_PDFA1\n");
        this.append("/OutputCondition (sRGB IEC61966-2.1)\n");
        this.append("/OutputConditionIdentifier (sRGB IEC61966-2.1)\n");
        this.append("/Info (sRGB IEC61966-2.1)\n");
        this.append("/DestOutputProfile ");
        this.append(this.objNumber - 1);
        this.append(" 0 R\n");
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    private int addResourcesObject() throws Exception {
        Object object;
        int n;
        this.newobj();
        this.append("<<\n");
        if (!this.fonts.isEmpty()) {
            this.append("/Font\n");
            this.append("<<\n");
            for (n = 0; n < this.fonts.size(); ++n) {
                object = this.fonts.get(n);
                this.append("/F");
                this.append(((Font)object).objNumber);
                this.append(' ');
                this.append(((Font)object).objNumber);
                this.append(" 0 R\n");
            }
            this.append(">>\n");
        }
        if (!this.images.isEmpty()) {
            this.append("/XObject\n");
            this.append("<<\n");
            for (n = 0; n < this.images.size(); ++n) {
                object = this.images.get(n);
                this.append("/Im");
                this.append(((Image)object).objNumber);
                this.append(' ');
                this.append(((Image)object).objNumber);
                this.append(" 0 R\n");
            }
            this.append(">>\n");
        }
        if (!this.groups.isEmpty()) {
            this.append("/Properties\n");
            this.append("<<\n");
            for (n = 0; n < this.groups.size(); ++n) {
                object = this.groups.get(n);
                this.append("/OC");
                this.append(n + 1);
                this.append(' ');
                this.append(((OptionalContentGroup)object).objNumber);
                this.append(" 0 R\n");
            }
            this.append(">>\n");
        }
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    private int addPagesObject() throws Exception {
        this.newobj();
        this.append("<<\n");
        this.append("/Type /Pages\n");
        this.append("/Kids [\n");
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = this.pages.get(i);
            if (this.compliance == 2) {
                page.setStructElementsPageObjNumber(page.objNumber);
            }
            this.append(page.objNumber);
            this.append(" 0 R\n");
        }
        this.append("]\n");
        this.append("/Count ");
        this.append(this.pages.size());
        this.append('\n');
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    private int addInfoObject() throws Exception {
        this.newobj();
        this.append("<<\n");
        this.append("/Title (");
        this.append(this.title);
        this.append(")\n");
        this.append("/Subject (");
        this.append(this.subject);
        this.append(")\n");
        this.append("/Author (");
        this.append(this.author);
        this.append(")\n");
        this.append("/Producer (");
        this.append(this.producer);
        this.append(")\n");
        this.append("/CreationDate (D:");
        this.append(this.creationDate);
        this.append("Z)\n");
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    private int addStructTreeRootObject() throws Exception {
        this.newobj();
        this.append("<<\n");
        this.append("/Type /StructTreeRoot\n");
        this.append("/K [\n");
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = this.pages.get(i);
            for (int j = 0; j < page.structures.size(); ++j) {
                this.append(page.structures.get((int)j).objNumber);
                this.append(" 0 R\n");
            }
        }
        this.append("]\n");
        this.append("/ParentTree ");
        this.append(this.objNumber + 1);
        this.append(" 0 R\n");
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    private void addStructElementObjects() throws Exception {
        Page page;
        int n;
        int n2 = this.objNumber + 1;
        for (n = 0; n < this.pages.size(); ++n) {
            page = this.pages.get(n);
            n2 += page.structures.size();
        }
        for (n = 0; n < this.pages.size(); ++n) {
            page = this.pages.get(n);
            for (int i = 0; i < page.structures.size(); ++i) {
                this.newobj();
                StructElem structElem = page.structures.get(i);
                structElem.objNumber = this.objNumber;
                this.append("<<\n");
                this.append("/Type /StructElem\n");
                this.append("/S /");
                this.append(structElem.structure);
                this.append("\n");
                this.append("/P ");
                this.append(n2);
                this.append(" 0 R\n");
                this.append("/Pg ");
                this.append(structElem.pageObjNumber);
                this.append(" 0 R\n");
                if (structElem.annotation == null) {
                    this.append("/K ");
                    this.append(structElem.mcid);
                    this.append("\n");
                } else {
                    this.append("/K <<\n");
                    this.append("/Type /OBJR\n");
                    this.append("/Obj ");
                    this.append(structElem.annotation.objNumber);
                    this.append(" 0 R\n");
                    this.append(">>\n");
                }
                if (structElem.language != null) {
                    this.append("/Lang (");
                    this.append(structElem.language);
                    this.append(")\n");
                }
                this.append("/Alt (");
                this.append(this.escapeSpecialCharacters(structElem.altDescription));
                this.append(")\n");
                this.append("/ActualText (");
                this.append(this.escapeSpecialCharacters(structElem.actualText));
                this.append(")\n");
                this.append(">>\n");
                this.endobj();
            }
        }
    }

    private String escapeSpecialCharacters(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(' || c == ')' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void addNumsParentTree() throws Exception {
        int n;
        this.newobj();
        this.append("<<\n");
        this.append("/Nums [\n");
        for (n = 0; n < this.pages.size(); ++n) {
            Page page = this.pages.get(n);
            this.append(n);
            this.append(" [\n");
            for (int i = 0; i < page.structures.size(); ++i) {
                StructElem structElem = page.structures.get(i);
                if (structElem.annotation != null) continue;
                this.append(structElem.objNumber);
                this.append(" 0 R\n");
            }
            this.append("]\n");
        }
        n = this.pages.size();
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = this.pages.get(i);
            for (int j = 0; j < page.structures.size(); ++j) {
                StructElem structElem = page.structures.get(j);
                if (structElem.annotation == null) continue;
                this.append(n);
                this.append(" ");
                this.append(structElem.objNumber);
                this.append(" 0 R\n");
                ++n;
            }
        }
        this.append("]\n");
        this.append(">>\n");
        this.endobj();
    }

    private int addRootObject(int n) throws Exception {
        this.newobj();
        this.append("<<\n");
        this.append("/Type /Catalog\n");
        if (this.compliance == 2) {
            this.append("/Lang (");
            this.append(this.language);
            this.append(")\n");
            this.append("/StructTreeRoot ");
            this.append(n);
            this.append(" 0 R\n");
            this.append("/MarkInfo <</Marked true>>\n");
            this.append("/ViewerPreferences <</DisplayDocTitle true>>\n");
        }
        if (this.pageLayout != null) {
            this.append("/PageLayout /");
            this.append(this.pageLayout);
            this.append("\n");
        }
        if (this.pageMode != null) {
            this.append("/PageMode /");
            this.append(this.pageMode);
            this.append("\n");
        }
        this.addOCProperties();
        this.append("/Pages ");
        this.append(this.pagesObjNumber);
        this.append(" 0 R\n");
        if (this.compliance == 1 || this.compliance == 2) {
            this.append("/Metadata ");
            this.append(this.metadataObjNumber);
            this.append(" 0 R\n");
            this.append("/OutputIntents [");
            this.append(this.outputIntentObjNumber);
            this.append(" 0 R]\n");
        }
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    private void addPageBox(String string, Page page, float[] fArray) throws Exception {
        this.append("/");
        this.append(string);
        this.append(" [");
        this.append(fArray[0]);
        this.append(' ');
        this.append(page.height - fArray[3]);
        this.append(' ');
        this.append(fArray[2]);
        this.append(' ');
        this.append(page.height - fArray[1]);
        this.append("]\n");
    }

    private void setDestinationObjNumbers() {
        Page page;
        int n;
        int n2 = 0;
        for (n = 0; n < this.pages.size(); ++n) {
            page = this.pages.get(n);
            n2 += page.annots.size();
        }
        for (n = 0; n < this.pages.size(); ++n) {
            page = this.pages.get(n);
            for (Destination destination : page.destinations) {
                destination.pageObjNumber = this.objNumber + n2 + n + 1;
                this.destinations.put(destination.name, destination);
            }
        }
    }

    private void addAllPages(int n) throws Exception {
        this.setDestinationObjNumbers();
        this.addAnnotDictionaries();
        this.pagesObjNumber = this.objNumber + this.pages.size() + 1;
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = this.pages.get(i);
            this.newobj();
            page.objNumber = this.objNumber;
            this.append("<<\n");
            this.append("/Type /Page\n");
            this.append("/Parent ");
            this.append(this.pagesObjNumber);
            this.append(" 0 R\n");
            this.append("/MediaBox [0.0 0.0 ");
            this.append(page.width);
            this.append(' ');
            this.append(page.height);
            this.append("]\n");
            if (page.cropBox != null) {
                this.addPageBox("CropBox", page, page.cropBox);
            }
            if (page.bleedBox != null) {
                this.addPageBox("BleedBox", page, page.bleedBox);
            }
            if (page.trimBox != null) {
                this.addPageBox("TrimBox", page, page.trimBox);
            }
            if (page.artBox != null) {
                this.addPageBox("ArtBox", page, page.artBox);
            }
            this.append("/Resources ");
            this.append(n);
            this.append(" 0 R\n");
            this.append("/Contents [ ");
            for (Integer n2 : page.contents) {
                this.append(n2);
                this.append(" 0 R ");
            }
            this.append("]\n");
            if (page.annots.size() > 0) {
                this.append("/Annots [ ");
                for (Annotation annotation : page.annots) {
                    this.append(annotation.objNumber);
                    this.append(" 0 R ");
                }
                this.append("]\n");
            }
            if (this.compliance == 2) {
                this.append("/Tabs /S\n");
                this.append("/StructParents ");
                this.append(i);
                this.append("\n");
            }
            this.append(">>\n");
            this.endobj();
        }
    }

    private void addPageContent(Page page) throws Exception {
        Object[] objectArray;
        Object object;
        if (this.eval && this.fonts.size() > 0) {
            object = this.fonts.get(0);
            float f = ((Font)object).getSize();
            ((Font)object).setSize(8.0f);
            objectArray = page.tm;
            float[] fArray = page.getBrushColor();
            page.setTextDirection(0);
            page.setBrushColor(255);
            String string = "This document was created with the evaluation version of PDFjet";
            String string2 = "To acquire a license please visit http://pdfjet.com";
            page.drawString((Font)object, string, (page.width - ((Font)object).stringWidth(string)) / 2.0f, 10.0f);
            page.drawString((Font)object, string2, (page.width - ((Font)object).stringWidth(string2)) / 2.0f, 20.0f);
            ((Font)object).setSize(f);
            page.tm = objectArray;
            page.setBrushColor(fArray);
        }
        object = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)object, new Deflater());
        objectArray = page.buf.toByteArray();
        deflaterOutputStream.write((byte[])objectArray, 0, objectArray.length);
        deflaterOutputStream.finish();
        page.buf = null;
        this.newobj();
        this.append("<<\n");
        this.append("/Filter /FlateDecode\n");
        this.append("/Length ");
        this.append(((ByteArrayOutputStream)object).size());
        this.append("\n");
        this.append(">>\n");
        this.append("stream\n");
        this.append((ByteArrayOutputStream)object);
        this.append("\nendstream\n");
        this.endobj();
        page.contents.add(this.objNumber);
    }

    private int addAnnotationObject(Annotation annotation, int n) throws Exception {
        Destination destination;
        this.newobj();
        annotation.objNumber = this.objNumber;
        this.append("<<\n");
        this.append("/Type /Annot\n");
        this.append("/Subtype /Link\n");
        this.append("/Rect [");
        this.append(annotation.x1);
        this.append(' ');
        this.append(annotation.y1);
        this.append(' ');
        this.append(annotation.x2);
        this.append(' ');
        this.append(annotation.y2);
        this.append("]\n");
        this.append("/Border [0 0 0]\n");
        if (annotation.uri != null) {
            this.append("/F 4\n");
            this.append("/A <<\n");
            this.append("/S /URI\n");
            this.append("/URI (");
            this.append(annotation.uri);
            this.append(")\n");
            this.append(">>\n");
        } else if (annotation.key != null && (destination = this.destinations.get(annotation.key)) != null) {
            this.append("/F 4\n");
            this.append("/Dest [");
            this.append(destination.pageObjNumber);
            this.append(" 0 R /XYZ 0 ");
            this.append(destination.yPosition);
            this.append(" 0]\n");
        }
        if (n != -1) {
            this.append("/StructParent ");
            this.append(n++);
            this.append("\n");
        }
        this.append(">>\n");
        this.endobj();
        return n;
    }

    private void addAnnotDictionaries() throws Exception {
        int n = this.pages.size();
        for (int i = 0; i < this.pages.size(); ++i) {
            Object object;
            int n2;
            Page page = this.pages.get(i);
            if (page.structures.size() > 0) {
                for (n2 = 0; n2 < page.structures.size(); ++n2) {
                    object = page.structures.get(n2);
                    if (((StructElem)object).annotation == null) continue;
                    n = this.addAnnotationObject(((StructElem)object).annotation, n);
                }
                continue;
            }
            if (page.annots.size() <= 0) continue;
            for (n2 = 0; n2 < page.annots.size(); ++n2) {
                object = page.annots.get(n2);
                if (object == null) continue;
                this.addAnnotationObject((Annotation)object, -1);
            }
        }
    }

    private void addOCProperties() throws Exception {
        if (!this.groups.isEmpty()) {
            this.append("/OCProperties\n");
            this.append("<<\n");
            this.append("/OCGs [");
            for (OptionalContentGroup optionalContentGroup : this.groups) {
                this.append(' ');
                this.append(optionalContentGroup.objNumber);
                this.append(" 0 R");
            }
            this.append(" ]\n");
            this.append("/D <<\n");
            this.append("/BaseState /OFF\n");
            this.append("/ON [");
            for (OptionalContentGroup optionalContentGroup : this.groups) {
                if (!optionalContentGroup.visible) continue;
                this.append(' ');
                this.append(optionalContentGroup.objNumber);
                this.append(" 0 R");
            }
            this.append(" ]\n");
            this.append("/AS [\n");
            this.append("<< /Event /Print /Category [/Print] /OCGs [");
            for (OptionalContentGroup optionalContentGroup : this.groups) {
                if (!optionalContentGroup.printable) continue;
                this.append(' ');
                this.append(optionalContentGroup.objNumber);
                this.append(" 0 R");
            }
            this.append(" ] >>\n");
            this.append("<< /Event /Export /Category [/Export] /OCGs [");
            for (OptionalContentGroup optionalContentGroup : this.groups) {
                if (!optionalContentGroup.exportable) continue;
                this.append(' ');
                this.append(optionalContentGroup.objNumber);
                this.append(" 0 R");
            }
            this.append(" ] >>\n");
            this.append("]\n");
            this.append("/Order [[ ()");
            for (OptionalContentGroup optionalContentGroup : this.groups) {
                this.append(' ');
                this.append(optionalContentGroup.objNumber);
                this.append(" 0 R");
            }
            this.append(" ]]\n");
            this.append(">>\n");
            this.append(">>\n");
        }
    }

    public void addPage(Page page) throws Exception {
        int n = this.pages.size();
        if (n > 0) {
            this.addPageContent(this.pages.get(n - 1));
        }
        this.pages.add(page);
    }

    public void flush() throws Exception {
        this.flush(false);
    }

    public void close() throws Exception {
        this.flush(true);
    }

    private void flush(boolean bl) throws Exception {
        if (this.pagesObjNumber == -1) {
            this.addPageContent(this.pages.get(this.pages.size() - 1));
            this.addAllPages(this.addResourcesObject());
            this.addPagesObject();
        }
        int n = 0;
        if (this.compliance == 2) {
            this.addStructElementObjects();
            n = this.addStructTreeRootObject();
            this.addNumsParentTree();
        }
        int n2 = this.addInfoObject();
        int n3 = this.addRootObject(n);
        int n4 = this.byte_count;
        this.append("xref\n");
        this.append("0 ");
        this.append(n3 + 1);
        this.append('\n');
        this.append("0000000000 65535 f \n");
        for (int i = 0; i < this.objOffset.size(); ++i) {
            int n5 = this.objOffset.get(i);
            String string = Integer.toString(n5);
            for (int j = 0; j < 10 - string.length(); ++j) {
                this.append('0');
            }
            this.append(string);
            this.append(" 00000 n \n");
        }
        this.append("trailer\n");
        this.append("<<\n");
        this.append("/Size ");
        this.append(n3 + 1);
        this.append('\n');
        String string = new Salsa20().getID();
        this.append("/ID[<");
        this.append(string);
        this.append("><");
        this.append(string);
        this.append(">]\n");
        this.append("/Info ");
        this.append(n2);
        this.append(" 0 R\n");
        this.append("/Root ");
        this.append(n3);
        this.append(" 0 R\n");
        this.append(">>\n");
        this.append("startxref\n");
        this.append(n4);
        this.append('\n');
        this.append("%%EOF\n");
        this.os.flush();
        if (bl) {
            this.os.close();
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void setPageLayout(String string) {
        this.pageLayout = string;
    }

    public void setPageMode(String string) {
        this.pageMode = string;
    }

    protected void append(int n) throws IOException {
        this.append(Integer.toString(n));
    }

    protected void append(float f) throws IOException {
        this.append(df.format(f));
    }

    protected void append(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.os.write((byte)string.charAt(i));
        }
        this.byte_count += n;
    }

    protected void append(char c) throws IOException {
        this.append((byte)c);
    }

    protected void append(byte by) throws IOException {
        this.os.write(by);
        ++this.byte_count;
    }

    protected void append(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        this.byte_count += n2;
    }

    protected void append(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byteArrayOutputStream.writeTo(this.os);
        this.byte_count += byteArrayOutputStream.size();
    }

    public Map<Integer, PDFobj> read(InputStream inputStream) throws Exception {
        int n;
        ArrayList<PDFobj> arrayList = new ArrayList<PDFobj>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n2 = this.getStartXRef(byArray);
        PDFobj pDFobj = this.getObject(byArray, n2);
        if (pDFobj.dict.get(0).equals("xref")) {
            this.getObjects1(byArray, pDFobj, arrayList);
        } else {
            this.getObjects2(byArray, pDFobj, arrayList);
        }
        TreeMap<Integer, PDFobj> treeMap = new TreeMap<Integer, PDFobj>();
        for (PDFobj pDFobj2 : arrayList) {
            if (pDFobj2.dict.contains("stream")) {
                pDFobj2.setStream(byArray, pDFobj2.getLength(arrayList));
                if (pDFobj2.getValue("/Filter").equals("/FlateDecode")) {
                    Decompressor decompressor = new Decompressor(pDFobj2.stream);
                    pDFobj2.data = decompressor.getDecompressedData();
                } else {
                    pDFobj2.data = pDFobj2.stream;
                }
            }
            if (pDFobj2.getValue("/Type").equals("/ObjStm")) {
                int n3 = Integer.valueOf(pDFobj2.getValue("/N"));
                int n4 = Integer.valueOf(pDFobj2.getValue("/First"));
                PDFobj pDFobj3 = this.getObject(pDFobj2.data, 0, n4);
                for (int i = 0; i < pDFobj3.dict.size(); i += 2) {
                    int n5 = Integer.valueOf(pDFobj3.dict.get(i));
                    int n6 = Integer.valueOf(pDFobj3.dict.get(i + 1));
                    int n7 = pDFobj2.data.length;
                    if (i <= pDFobj3.dict.size() - 4) {
                        n7 = n4 + Integer.valueOf(pDFobj3.dict.get(i + 3));
                    }
                    PDFobj pDFobj4 = this.getObject(pDFobj2.data, n4 + n6, n7);
                    pDFobj4.dict.add(0, "obj");
                    pDFobj4.dict.add(0, "0");
                    pDFobj4.dict.add(0, Integer.toString(n5));
                    treeMap.put(n5, pDFobj4);
                }
                continue;
            }
            treeMap.put(pDFobj2.number, pDFobj2);
        }
        return treeMap;
    }

    private boolean process(PDFobj pDFobj, StringBuilder stringBuilder, int n) {
        String string = stringBuilder.toString().trim();
        if (!string.equals("")) {
            pDFobj.dict.add(string);
        }
        stringBuilder.setLength(0);
        if (string.equals("stream") || string.equals("endobj") || string.equals("startxref")) {
            if (string.equals("stream")) {
                if (this.endOfLine == 0) {
                    pDFobj.stream_offset = n + 1;
                } else if (this.endOfLine == 1 || this.endOfLine == 2) {
                    pDFobj.stream_offset = n;
                }
            }
            return true;
        }
        return false;
    }

    private PDFobj getObject(byte[] byArray, int n) {
        return this.getObject(byArray, n, byArray.length);
    }

    private PDFobj getObject(byte[] byArray, int n, int n2) {
        PDFobj pDFobj = new PDFobj(n);
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        int n4 = 32;
        boolean bl = false;
        while (!bl && n < n2) {
            int n5;
            if ((n5 = (int)byArray[n++]) == 40) {
                if (n3 == 0) {
                    bl = this.process(pDFobj, stringBuilder, n);
                }
                if (bl) continue;
                stringBuilder.append((char)n5);
                ++n3;
                continue;
            }
            if (n5 == 41) {
                stringBuilder.append((char)n5);
                if (--n3 != 0) continue;
                bl = this.process(pDFobj, stringBuilder, n);
                continue;
            }
            if (n5 == 0 || n5 == 9 || n5 == 10 || n5 == 12 || n5 == 13 || n5 == 32) {
                bl = this.process(pDFobj, stringBuilder, n);
                if (bl) continue;
                n4 = 32;
                continue;
            }
            if (n5 == 47) {
                bl = this.process(pDFobj, stringBuilder, n);
                if (bl) continue;
                stringBuilder.append((char)n5);
                n4 = n5;
                continue;
            }
            if (n5 == 60 || n5 == 62 || n5 == 37) {
                if (n5 != n4) {
                    bl = this.process(pDFobj, stringBuilder, n);
                    if (bl) continue;
                    stringBuilder.append((char)n5);
                    n4 = n5;
                    continue;
                }
                stringBuilder.append((char)n5);
                bl = this.process(pDFobj, stringBuilder, n);
                if (bl) continue;
                n4 = 32;
                continue;
            }
            if (n5 == 91 || n5 == 93 || n5 == 123 || n5 == 125) {
                bl = this.process(pDFobj, stringBuilder, n);
                if (bl) continue;
                pDFobj.dict.add(String.valueOf((char)n5));
                n4 = n5;
                continue;
            }
            stringBuilder.append((char)n5);
            if (n3 != 0) continue;
            n4 = n5;
        }
        return pDFobj;
    }

    private int toInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 |= byArray[n + i] & 0xFF;
            if (i >= n2 - 1) continue;
            n3 <<= 8;
        }
        return n3;
    }

    private void getObjects1(byte[] byArray, PDFobj pDFobj, List<PDFobj> list) throws Exception {
        String string;
        String string2 = pDFobj.getValue("/Prev");
        if (!string2.equals("")) {
            this.getObjects1(byArray, this.getObject(byArray, Integer.valueOf(string2)), list);
        }
        int n = 1;
        while (!(string = pDFobj.dict.get(n++)).equals("trailer")) {
            int n2 = Integer.valueOf(pDFobj.dict.get(n++));
            for (int i = 0; i < n2; ++i) {
                String string3;
                String string4 = pDFobj.dict.get(n++);
                String string5 = pDFobj.dict.get(n++);
                if ((string3 = pDFobj.dict.get(n++)).equals("f")) continue;
                PDFobj pDFobj2 = this.getObject(byArray, Integer.valueOf(string4));
                pDFobj2.number = Integer.valueOf(pDFobj2.dict.get(0));
                list.add(pDFobj2);
            }
        }
    }

    private void getObjects2(byte[] byArray, PDFobj pDFobj, List<PDFobj> list) throws Exception {
        Object object;
        int n;
        String string = pDFobj.getValue("/Prev");
        if (!string.equals("")) {
            this.getObjects2(byArray, this.getObject(byArray, Integer.valueOf(string)), list);
        }
        pDFobj.setStream(byArray, pDFobj.getLength(list));
        if (pDFobj.getValue("/Filter").equals("/FlateDecode")) {
            Decompressor decompressor = new Decompressor(pDFobj.stream);
            pDFobj.data = decompressor.getDecompressedData();
        } else {
            pDFobj.data = pDFobj.stream;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < pDFobj.dict.size(); ++n) {
            object = pDFobj.dict.get(n);
            if (((String)object).equals("/Predictor") && pDFobj.dict.get(n + 1).equals("12")) {
                n2 = 1;
            }
            if (!((String)object).equals("/W")) continue;
            n3 = Integer.valueOf(pDFobj.dict.get(n + 2));
            n4 = Integer.valueOf(pDFobj.dict.get(n + 3));
            n5 = Integer.valueOf(pDFobj.dict.get(n + 4));
        }
        n = n2 + n3 + n4 + n5;
        object = new byte[n];
        for (int i = 0; i < pDFobj.data.length; i += n) {
            for (int j = 0; j < n; ++j) {
                Object object2 = object;
                int n6 = j;
                object2[n6] = (byte)(object2[n6] + pDFobj.data[i + j]);
            }
            if (object[n2] != true) continue;
            PDFobj pDFobj2 = this.getObject(byArray, this.toInt((byte[])object, n2 + n3, n4));
            pDFobj2.number = Integer.valueOf(pDFobj2.dict.get(0));
            list.add(pDFobj2);
        }
    }

    private int getStartXRef(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = byArray.length - 10; i > 10; --i) {
            if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 97 || byArray[i + 3] != 114 || byArray[i + 4] != 116 || byArray[i + 5] != 120 || byArray[i + 6] != 114 || byArray[i + 7] != 101 || byArray[i + 8] != 102) continue;
            if (byArray[i + 9] == 13) {
                this.endOfLine = byArray[i + 10] == 10 ? 0 : 1;
            } else if (byArray[i + 9] == 10) {
                this.endOfLine = 2;
            }
            int n = this.endOfLine == 0 ? i + 11 : i + 10;
            char c = (char)byArray[n];
            while (c == ' ' || Character.isDigit(c)) {
                stringBuilder.append(c);
                c = (char)byArray[++n];
            }
            break;
        }
        return Integer.valueOf(stringBuilder.toString().trim());
    }

    public void addObjects(Map<Integer, PDFobj> map) throws Exception {
        for (PDFobj pDFobj : map.values()) {
            if (!pDFobj.getValue("/Type").equals("/Pages") || !pDFobj.getValue("/Parent").equals("")) continue;
            this.pagesObjNumber = Integer.valueOf(pDFobj.dict.get(0));
        }
        int n = Collections.max(map.keySet());
        for (int i = 1; i < n; ++i) {
            if (map.get(i) != null) continue;
            PDFobj pDFobj = new PDFobj();
            pDFobj.number = i;
            map.put(pDFobj.number, pDFobj);
        }
        for (PDFobj pDFobj : map.values()) {
            int n2;
            int n3;
            this.objNumber = pDFobj.number;
            this.objOffset.add(this.byte_count);
            if (pDFobj.offset == 0) {
                this.append(pDFobj.number);
                this.append(" 0 obj\n");
                if (pDFobj.dict != null) {
                    for (n3 = 0; n3 < pDFobj.dict.size(); ++n3) {
                        this.append(pDFobj.dict.get(n3));
                        this.append(' ');
                    }
                }
                if (pDFobj.stream != null) {
                    this.append("<< /Length ");
                    this.append(pDFobj.stream.length);
                    this.append(" >>");
                    this.append("\nstream\n");
                    for (n3 = 0; n3 < pDFobj.stream.length; ++n3) {
                        this.append(pDFobj.stream[n3]);
                    }
                    this.append("\nendstream\n");
                }
                this.append("endobj\n");
                continue;
            }
            n3 = pDFobj.dict.size();
            String string = null;
            for (n2 = 0; n2 < n3; ++n2) {
                string = pDFobj.dict.get(n2);
                this.append(string);
                if (n2 < n3 - 1) {
                    this.append(' ');
                    continue;
                }
                this.append('\n');
            }
            if (pDFobj.stream != null) {
                for (n2 = 0; n2 < pDFobj.stream.length; ++n2) {
                    this.append(pDFobj.stream[n2]);
                }
                this.append("\nendstream\n");
            }
            if (string.equals("endobj")) continue;
            this.append("endobj\n");
        }
    }

    public List<PDFobj> getPageObjects(Map<Integer, PDFobj> map) throws Exception {
        ArrayList<PDFobj> arrayList = new ArrayList<PDFobj>();
        for (PDFobj pDFobj : map.values()) {
            if (!pDFobj.getValue("/Type").equals("/Pages") || !pDFobj.getValue("/Parent").equals("")) continue;
            this.getPageObjects(pDFobj, map, arrayList);
        }
        return arrayList;
    }

    private void getPageObjects(PDFobj pDFobj, Map<Integer, PDFobj> map, List<PDFobj> list) throws Exception {
        List<Integer> list2 = pDFobj.getObjectNumbers("/Kids");
        for (Integer n : list2) {
            PDFobj pDFobj2 = map.get(n);
            if (this.isPageObject(pDFobj2)) {
                list.add(pDFobj2);
                continue;
            }
            this.getPageObjects(pDFobj2, map, list);
        }
    }

    private boolean isPageObject(PDFobj pDFobj) {
        boolean bl = false;
        for (int i = 0; i < pDFobj.dict.size(); ++i) {
            if (!pDFobj.dict.get(i).equals("/Type") || !pDFobj.dict.get(i + 1).equals("/Page")) continue;
            bl = true;
        }
        return bl;
    }
}

