/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Drawable;
import com.pdfjet.ECC_L5;
import com.pdfjet.PDF417;
import com.pdfjet.Page;
import com.pdfjet.TextCompact;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarCode2D
implements Drawable {
    private static final int ALPHA = 8;
    private static final int LOWER = 4;
    private static final int MIXED = 2;
    private static final int PUNCT = 1;
    private static final int LATCH_TO_LOWER = 27;
    private static final int SHIFT_TO_ALPHA = 27;
    private static final int LATCH_TO_MIXED = 28;
    private static final int LATCH_TO_ALPHA = 28;
    private static final int SHIFT_TO_PUNCT = 29;
    private float x1 = 0.0f;
    private float y1 = 0.0f;
    private float w1 = 0.75f;
    private float h1 = 0.0f;
    private int rows = 50;
    private int cols = 18;
    private int[] codewords;
    private String str;

    public BarCode2D(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        this.str = string;
        this.h1 = 3.0f * this.w1;
        this.codewords = new int[this.rows * (this.cols + 2)];
        int[] nArray = new int[this.rows];
        int[] nArray2 = new int[this.rows];
        int[] nArray3 = new int[this.rows * this.cols];
        int n5 = 5;
        int n6 = 1;
        for (n4 = 0; n4 < this.rows; ++n4) {
            n3 = 0;
            n2 = 0;
            n = 30 * (n4 / 3);
            if (n6 == 1) {
                n3 = n + (this.rows - 1) / 3;
                n2 = n + (this.cols - 1);
            } else if (n6 == 2) {
                n3 = n + 3 * n5 + (this.rows - 1) % 3;
                n2 = n + (this.rows - 1) / 3;
            } else if (n6 == 3) {
                n3 = n + (this.cols - 1);
                n2 = n + 3 * n5 + (this.rows - 1) % 3;
            }
            nArray[n4] = n3;
            nArray2[n4] = n2;
            if (++n6 != 4) continue;
            n6 = 1;
        }
        n4 = this.rows * this.cols - ECC_L5.table.length;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray3[n3] = 900;
        }
        nArray3[0] = n4;
        this.addData(nArray3, n4);
        this.addECC(nArray3);
        for (n3 = 0; n3 < this.rows; ++n3) {
            n2 = (this.cols + 2) * n3;
            this.codewords[n2] = nArray[n3];
            for (n = 0; n < this.cols; ++n) {
                this.codewords[n2 + n + 1] = nArray3[this.cols * n3 + n];
            }
            this.codewords[n2 + this.cols + 1] = nArray2[n3];
        }
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x1 = f;
        this.y1 = f2;
    }

    @Override
    public void drawOn(Page page) throws Exception {
        this.drawPdf417(page);
    }

    private List<Integer> convertTheStringToListOfValues() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        int n2 = 8;
        int n3 = 0;
        char c = '\u0000';
        for (int i = 0; i < this.str.length(); ++i) {
            c = this.str.charAt(i);
            if (c == ' ') {
                arrayList.add(26);
                continue;
            }
            n = TextCompact.TABLE[c][1];
            n3 = TextCompact.TABLE[c][2];
            if (n3 == n2) {
                arrayList.add(n);
                continue;
            }
            if (n3 == 8 && n2 == 4) {
                arrayList.add(27);
                arrayList.add(n);
                continue;
            }
            if (n3 == 8 && n2 == 2) {
                arrayList.add(28);
                arrayList.add(n);
                n2 = n3;
                continue;
            }
            if (n3 == 4 && n2 == 8) {
                arrayList.add(27);
                arrayList.add(n);
                n2 = n3;
                continue;
            }
            if (n3 == 4 && n2 == 2) {
                arrayList.add(27);
                arrayList.add(n);
                n2 = n3;
                continue;
            }
            if (n3 == 2 && n2 == 8) {
                arrayList.add(28);
                arrayList.add(n);
                n2 = n3;
                continue;
            }
            if (n3 == 2 && n2 == 4) {
                arrayList.add(28);
                arrayList.add(n);
                n2 = n3;
                continue;
            }
            if (n3 == 1 && n2 == 8) {
                arrayList.add(29);
                arrayList.add(n);
                continue;
            }
            if (n3 == 1 && n2 == 4) {
                arrayList.add(29);
                arrayList.add(n);
                continue;
            }
            if (n3 != 1 || n2 != 2) continue;
            arrayList.add(29);
            arrayList.add(n);
        }
        return arrayList;
    }

    private void addData(int[] nArray, int n) {
        List<Integer> list = this.convertTheStringToListOfValues();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < list.size(); i += 2) {
            n3 = list.get(i);
            n4 = i + 1 == list.size() ? 29 : list.get(i + 1);
            if (++n2 == n) break;
            nArray[n2] = 30 * n3 + n4;
        }
    }

    private void addECC(int[] nArray) {
        int n;
        int[] nArray2 = new int[ECC_L5.table.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray.length - nArray2.length;
        for (n = 0; n < n5; ++n) {
            n2 = (nArray[n] + nArray2[nArray2.length - 1]) % 929;
            for (int i = nArray2.length - 1; i > 0; --i) {
                n3 = n2 * ECC_L5.table[i] % 929;
                n4 = 929 - n3;
                nArray2[i] = (nArray2[i - 1] + n4) % 929;
            }
            n3 = n2 * ECC_L5.table[0] % 929;
            n4 = 929 - n3;
            nArray2[0] = n4 % 929;
        }
        for (n = 0; n < nArray2.length; ++n) {
            if (nArray2[n] == 0) continue;
            nArray[nArray.length - 1 - n] = 929 - nArray2[n];
        }
    }

    private void drawPdf417(Page page) throws Exception {
        int n;
        int n2;
        int n3;
        float f = this.x1;
        float f2 = this.y1;
        int[] nArray = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            if (n3 % 2 == 0) {
                this.drawBar(page, f, f2, (float)n2 * this.w1, (float)this.rows * this.h1);
            }
            f += (float)n2 * this.w1;
        }
        this.x1 = f;
        n3 = 1;
        for (n2 = 0; n2 < this.codewords.length; ++n2) {
            n = this.codewords[n2];
            String string = Integer.toString(PDF417.TABLE[n][n3]);
            for (int i = 0; i < 8; ++i) {
                int n4 = string.charAt(i) - 48;
                if (i % 2 == 0) {
                    this.drawBar(page, f, f2, (float)n4 * this.w1, this.h1);
                }
                f += (float)n4 * this.w1;
            }
            if (n2 == this.codewords.length - 1) break;
            if ((n2 + 1) % (this.cols + 2) != 0) continue;
            f = this.x1;
            f2 += this.h1;
            if (++n3 != 4) continue;
            n3 = 1;
        }
        f2 = this.y1;
        int[] nArray2 = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
        for (n = 0; n < nArray2.length; ++n) {
            int n5 = nArray2[n];
            if (n % 2 == 0) {
                this.drawBar(page, f, f2, (float)n5 * this.w1, (float)this.rows * this.h1);
            }
            f += (float)n5 * this.w1;
        }
    }

    private void drawBar(Page page, float f, float f2, float f3, float f4) throws Exception {
        page.setPenWidth(f3);
        page.moveTo(f + f3 / 2.0f, f2);
        page.lineTo(f + f3 / 2.0f, f2 + f4);
        page.strokePath();
    }
}

