/*
 * Decompiled with CFR 0.152.
 */
package at.huber.youtubeExtractor;

public class VideoMeta {
    private static final String IMAGE_BASE_URL = "http://i.ytimg.com/vi/";
    private String videoId;
    private String title;
    private String shortDescript;
    private String author;
    private String channelId;
    private long videoLength;
    private long viewCount;
    private boolean isLiveStream;

    protected VideoMeta(String videoId, String title, String author, String channelId, long videoLength, long viewCount, boolean isLiveStream, String shortDescript) {
        this.videoId = videoId;
        this.title = title;
        this.author = author;
        this.channelId = channelId;
        this.videoLength = videoLength;
        this.viewCount = viewCount;
        this.isLiveStream = isLiveStream;
        this.shortDescript = shortDescript;
    }

    public String getThumbUrl() {
        return IMAGE_BASE_URL + this.videoId + "/default.jpg";
    }

    public String getMqImageUrl() {
        return IMAGE_BASE_URL + this.videoId + "/mqdefault.jpg";
    }

    public String getHqImageUrl() {
        return IMAGE_BASE_URL + this.videoId + "/hqdefault.jpg";
    }

    public String getSdImageUrl() {
        return IMAGE_BASE_URL + this.videoId + "/sddefault.jpg";
    }

    public String getMaxResImageUrl() {
        return IMAGE_BASE_URL + this.videoId + "/maxresdefault.jpg";
    }

    public String getVideoId() {
        return this.videoId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public boolean isLiveStream() {
        return this.isLiveStream;
    }

    public long getVideoLength() {
        return this.videoLength;
    }

    public long getViewCount() {
        return this.viewCount;
    }

    public String getShortDescription() {
        return this.shortDescript;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoMeta videoMeta = (VideoMeta)o;
        if (this.videoLength != videoMeta.videoLength) {
            return false;
        }
        if (this.viewCount != videoMeta.viewCount) {
            return false;
        }
        if (this.isLiveStream != videoMeta.isLiveStream) {
            return false;
        }
        if (this.videoId != null ? !this.videoId.equals(videoMeta.videoId) : videoMeta.videoId != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(videoMeta.title) : videoMeta.title != null) {
            return false;
        }
        if (this.author != null ? !this.author.equals(videoMeta.author) : videoMeta.author != null) {
            return false;
        }
        return this.channelId != null ? this.channelId.equals(videoMeta.channelId) : videoMeta.channelId == null;
    }

    public int hashCode() {
        int result = this.videoId != null ? this.videoId.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 31 * result + (this.channelId != null ? this.channelId.hashCode() : 0);
        result = 31 * result + (int)(this.videoLength ^ this.videoLength >>> 32);
        result = 31 * result + (int)(this.viewCount ^ this.viewCount >>> 32);
        result = 31 * result + (this.isLiveStream ? 1 : 0);
        return result;
    }

    public String toString() {
        return "VideoMeta{videoId='" + this.videoId + '\'' + ", title='" + this.title + '\'' + ", author='" + this.author + '\'' + ", channelId='" + this.channelId + '\'' + ", videoLength=" + this.videoLength + ", viewCount=" + this.viewCount + ", isLiveStream=" + this.isLiveStream + '}';
    }
}

