/*
 * Decompiled with CFR 0.152.
 */
package studio.carbonylgroup.textfieldboxes;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.design.widget.TextInputEditText;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import studio.carbonylgroup.textfieldboxes.CompositeListener;
import studio.carbonylgroup.textfieldboxes.R;

public class ExtendedEditText
extends TextInputEditText {
    public int DEFAULT_TEXT_COLOR;
    private View.OnFocusChangeListener defaultFocusListener;
    private CompositeListener focusListener = new CompositeListener();
    protected String prefix;
    protected String suffix;
    protected int prefixTextColor;
    protected int suffixTextColor;

    public ExtendedEditText(Context context) {
        this(context, null);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this.focusListener);
        this.initDefaultColor();
    }

    public ExtendedEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this.focusListener);
        this.initDefaultColor();
        this.handleAttributes(context, attrs);
    }

    public ExtendedEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this.focusListener);
        this.initDefaultColor();
        this.handleAttributes(context, attrs);
    }

    protected void initDefaultColor() {
        Resources.Theme theme = this.getContext().getTheme();
        TypedArray themeArray = theme.obtainStyledAttributes(new int[]{0x1010212});
        this.DEFAULT_TEXT_COLOR = themeArray.getColor(0, 0);
        themeArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setPrefix(this.prefix);
        this.setSuffix(this.suffix);
        this.setPrefixTextColor(this.prefixTextColor);
        this.setSuffixTextColor(this.suffixTextColor);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener l) {
        this.focusListener.clearListeners();
        this.focusListener.registerListener(this.defaultFocusListener);
        this.focusListener.registerListener(l);
    }

    void setDefaultOnFocusChangeListener(View.OnFocusChangeListener l) {
        this.defaultFocusListener = l;
        this.focusListener.registerListener(l);
    }

    protected void handleAttributes(Context context, AttributeSet attrs) {
        try {
            TypedArray styledAttrs = context.obtainStyledAttributes(attrs, R.styleable.ExtendedEditText);
            this.prefix = styledAttrs.getString(R.styleable.ExtendedEditText_prefix) == null ? "" : styledAttrs.getString(R.styleable.ExtendedEditText_prefix);
            this.suffix = styledAttrs.getString(R.styleable.ExtendedEditText_suffix) == null ? "" : styledAttrs.getString(R.styleable.ExtendedEditText_suffix);
            this.prefixTextColor = styledAttrs.getInt(R.styleable.ExtendedEditText_prefixTextColor, this.DEFAULT_TEXT_COLOR);
            this.suffixTextColor = styledAttrs.getInt(R.styleable.ExtendedEditText_suffixTextColor, this.DEFAULT_TEXT_COLOR);
            styledAttrs.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.setCompoundDrawables(new TextDrawable(), null, null, null);
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        this.setCompoundDrawables(new TextDrawable(), null, null, null);
    }

    public void setPrefixTextColor(int color) {
        this.prefixTextColor = color;
    }

    public void setSuffixTextColor(int color) {
        this.suffixTextColor = color;
    }

    private class TextDrawable
    extends Drawable {
        private TextDrawable() {
            this.setBounds(0, 0, (int)ExtendedEditText.this.getPaint().measureText(ExtendedEditText.this.prefix) + 2, (int)ExtendedEditText.this.getTextSize());
            ExtendedEditText.this.setPadding(0, 0, (int)ExtendedEditText.this.getPaint().measureText(ExtendedEditText.this.suffix) - 2, 0);
        }

        public void draw(@NonNull Canvas canvas) {
            int lineBase = ExtendedEditText.this.getLineBounds(0, null);
            int lineBottom = ExtendedEditText.this.getLineBounds(ExtendedEditText.this.getLineCount() - 1, null);
            float endX = (float)ExtendedEditText.this.getWidth() - ExtendedEditText.this.getPaint().measureText(ExtendedEditText.this.suffix) - 2.0f;
            TextPaint paint = ExtendedEditText.this.getPaint();
            paint.setColor(ExtendedEditText.this.prefixTextColor);
            canvas.drawText(ExtendedEditText.this.prefix, 0.0f, (float)(canvas.getClipBounds().top + lineBase), (Paint)paint);
            paint.setColor(ExtendedEditText.this.suffixTextColor);
            canvas.drawText(ExtendedEditText.this.suffix, endX, (float)(canvas.getClipBounds().top + lineBottom), (Paint)paint);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -1;
        }
    }
}

