/*
 * Decompiled with CFR 0.152.
 */
package studio.carbonylgroup.textfieldboxes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.widget.EditText;
import android.widget.TextView;
import java.lang.reflect.Field;
import studio.carbonylgroup.textfieldboxes.R;

public class Utils {
    public static int fetchPrimaryColor(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorPrimary});
        int color2 = a.getColor(0, 0);
        a.recycle();
        return color2;
    }

    public static void setCursorDrawableColor(EditText editText, int color2) {
        try {
            Field fCursorDrawableRes = TextView.class.getDeclaredField("mCursorDrawableRes");
            fCursorDrawableRes.setAccessible(true);
            int mCursorDrawableRes = fCursorDrawableRes.getInt(editText);
            Field fEditor = TextView.class.getDeclaredField("mEditor");
            fEditor.setAccessible(true);
            Object editor = fEditor.get(editText);
            Class<?> clazz = editor.getClass();
            Field fCursorDrawable = clazz.getDeclaredField("mCursorDrawable");
            fCursorDrawable.setAccessible(true);
            Drawable[] drawables = new Drawable[]{editText.getContext().getResources().getDrawable(mCursorDrawableRes), editText.getContext().getResources().getDrawable(mCursorDrawableRes)};
            drawables[0].setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            drawables[1].setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            fCursorDrawable.set(editor, drawables);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

